/**
 *
 */
package ibase.webitm.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;

import javax.naming.NamingException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.json.simple.parser.JSONParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.google.appengine.repackaged.org.json.JSONObject;
import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.JSONtoXMLConverter;
import ibase.utility.UserInfoBean;
import ibase.utility.XMLtoJSONConverter;
import ibase.webitm.bean.TemplateDetails;
import ibase.webitm.bean.UploadTemplateBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DBAccessRemote;
import ibase.webitm.ejb.DocumentHandlerEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMUploadFileEJB;
import ibase.webitm.ejb.MasterApplyEJB;
import ibase.webitm.ejb.UploadFileEJB;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;

import ibase.webitm.utility.ITMException;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

/**
 * @author base
 *
 */
public class UploadTemplateServlet extends HttpServlet
{
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	private ServletContext servletContext = null;
	private ServletConfig servletConfig = null;
	private HttpSession session = null;

	private UploadFileEJB uploadFile = null;
	private Workbook workbook = null;
	//Added By Ankush S on 21-oct-2022 [to get root node from xml file]
	private Node rootNode=null;
	private int noOfSheet = 1;
	private String userId = "";
	private String objName = "";
	private String templateKey = "";
	private boolean isNewTemplate = false;
	
	private E12GenericUtility genericUtility = null;
	private TreeMap<String, String> requestParamMap = null;
	private UserInfoBean userInfo = null;

	private UploadTemplateBean uploadBean = null;

	//Added By Ravindra C on 05-06-2018  For DBAcess - Start
 	private DBAccessEJB dbAccess = null;
	private final String COLUMN_SEPARATOR = ":";
	//Added by Ravindra C
	private String sessionId = "";
	//added by Ankush S on 29-Nov-2022[to use file type for get sample]
	private String fileFormatType="";
	private String sampleFilePath="";
	HashMap<Integer, String>sheetInfo = new HashMap<Integer, String>();
	
	//Added By Ravindra C on 05-06-2018  For DBAcess - Start
	/**
	 *
	 */
	public void init(ServletConfig servletConfig) throws ServletException
	{
		try
		{
			this.servletConfig = servletConfig;
			this.servletContext = servletConfig.getServletContext();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	/**
	 * @throws IOException
	 *
	 */
	public void doGet(HttpServletRequest request,HttpServletResponse response) throws IOException
	{
		BaseLogger.log("2",null,null,"Inside doGet....");
		doPost(request, response);
	}

	/**
	 * @throws IOException
	 *
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException
	{
		String responseStr = "";
		String caller = "";
		boolean isResponseWritten = true;
		try
		{
			session = request.getSession();
			genericUtility = new E12GenericUtility();
			isNewTemplate = false;
			dbAccess = null;
			uploadBean = null;
			String action = checkNull(request.getParameter("action"));
			BaseLogger.log("3",userInfo,null,"In UploadTemplateServlet.................., action - [" + action + "]");
			BaseLogger.log("3",userInfo,null,"In doPost added by Ankush");
			
			userInfo = (UserInfoBean) getSessionAttribute( "USER_INFO" );
			String profileId = "", transDB = "";
			try
			{
				profileId = userInfo.getProfileId();
				transDB = userInfo.getTransDB();
				userId = userInfo.getLoginCode();
			}
			catch (NullPointerException e)
			{
				response.sendRedirect("/ibase/webitm/jsp/E12UploadTemplate.jsp");
			}
			BaseLogger.log("3",userInfo,null,"profileId - [" + profileId + "]");
			//added by Ravindra c on 08-09-18 for download excel file.
			sessionId = request.getSession().getId();

			
			requestParamMap = getRequestParamMap( request );
			System.out.println("RequestParamMap"+requestParamMap);
			noOfSheet = 1;
			int formNo = 1;
			workbook = null;
			caller = ""+ getRequestParamValue( "caller" );

			uploadBean = (UploadTemplateBean) getSessionAttribute( caller + "UPLOAD_BEAN" );

			//setSessionAttribute( "errorMsg", null );

			if ( "GET_OBJ_LIST".equals( action ) )
			{
				HashMap<String, String> objListMap = null;
				//if( transDB.length() > 0 )
				//{
					//Changed by Ravindra C on 02-04-18 for upload utility
					//objListMap = uploadFile.getObjList(profileId,userInfo);
					objListMap = getUploadFile().getObjList(profileId, userInfo, caller);
				//}
				//setSessionAttribute( "objListMap", objListMap );
				uploadBean.setObjListMap( objListMap );
				String respPath = "/webitm/jsp/SearchObject.jsp?caller="+ caller;
				RequestDispatcher reqDis = servletContext.getRequestDispatcher(respPath);
				reqDis.forward(request, response);
			}
			//Added by Ankush S. on 07-Dec-2022 [to download sample file for uploading]START
			else if("GET_SAMPLE".equals(action)) {
				
				BaseLogger.log( "3", userInfo, null, "excelSheetInfo="+sheetInfo);
				String sampleString="<ROOT>";
				//iterating for multiple forms
				for(int index = 1;index<=sheetInfo.size();index++) {
					
					//sampleString = sampleString+"<"+sheetInfo.get(index).replaceAll(" ","_")+">";
					sampleString = sampleString+"<Detail"+index+">";
					sampleString = sampleString+getSampleString(objName,index);
					//sampleString = sampleString+"</"+sheetInfo.get(index).replaceAll(" ","_")+">";
					sampleString = sampleString+"</Detail"+index+">";
				}
				sampleString=sampleString+"</ROOT>";
				BaseLogger.log( "3", userInfo, null, "sampleString="+sampleString);
				String sampleFilePath=getSampleFile(sampleString,fileFormatType);
				
				try {
				
					File downloadFile = new File(sampleFilePath);
					String fileName = downloadFile.getName();
					String filePath = downloadFile.getAbsolutePath();
					BaseLogger.log( "3", userInfo, null, "sample file name="+fileName);
					//response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
					fileName =objName+" Sample for upload."+ FilenameUtils.getExtension(fileName);
					BaseLogger.log( "3", userInfo, null, "sample file name="+fileName);
					response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
					FileInputStream inStream =null;
					if (fileFormatType.equals("excel")) {
						// response.setContentType("application/vnd.ms-excel");
						System.out.println("Download excel file");
						response.setContentLength((int) downloadFile.length());
						response.setContentType("application/x-download");
						ServletOutputStream servletOutputStream = response.getOutputStream();
						byte[] b = new byte[1024];
						int i = 0;
						inStream = new FileInputStream(downloadFile);
						while ((i = inStream.read(b)) > 0) {
							servletOutputStream.write(b, 0, i);
						}
						servletOutputStream.flush();
						servletOutputStream.close();
						downloadFile.delete();//delete file after download.
					} else {
						response.setContentType("application/text");

						inStream = new FileInputStream(downloadFile);
						PrintWriter out = response.getWriter();
						int in;
						while ((in = inStream.read()) != -1) {
							out.write(in);
						}
						inStream.close();
						out.close();
						downloadFile.delete();//delete file after download
					}
				} catch (Exception e) {
					BaseLogger.log("3", userInfo, null,"Error in downloading file=["+ e.getMessage());
					e.printStackTrace();
				}
				
			}
			//Added by Ankush S. on 07-Dec-2022 [to download sample file for uploading]END
			else if ( "GET_LOGICAL_DATA".equals( action ) )
			{
				String mapLogic = request.getParameter("mapLogic");
				int colNo = Integer.parseInt(request.getParameter("colNo"));
				BaseLogger.log("3",null,null,"colNo = ["+ colNo +"], mapLogic = ["+ mapLogic +"]");

				Set<String> defineMapSet = getLogicalData( mapLogic, colNo, request );
				//request.getSession().setAttribute("defineMapSet", defineMapSet);
				uploadBean.setDefineMapSet( defineMapSet );

				String respPath = "/webitm/jsp/E12UploadColMap.jsp?displayData=true&colNo="+ colNo + "&mapLogic=" + mapLogic +"&caller="+ caller;
				RequestDispatcher reqDis = this.servletContext.getRequestDispatcher(respPath);
				reqDis.forward(request, response);
			}
			else if ( "GET_UPLOAD_STATUS".equals( action ) )
			{
				String batchId = checkNull( getRequestParamValue( "BATCH_ID" ) );
				responseStr = getUploadFile().getUploadStatusData( batchId, userInfo, null );
				isResponseWritten = false;
			}
			/*else if ( "GET_BATCH_DTL".equals( action ) )
			{
				String batchId = checkNull( getRequestParamValue( "BATCH_ID" ) );
				responseStr = getUploadFile().getBatchDetails(batchId, userInfo, null);
				isResponseWritten = false;
			}*/
			else if ( "GET_ALL_UPLOAD_STATUS".equals( action ) )
			{
				//Changed by Prasad on 07/03/18 [to get upload status data datewise] START
				String loadDate = checkNull( getRequestParamValue( "loadDate" ) );
				responseStr = getUploadFile().getAllUploadStatusData( userInfo, loadDate );
				isResponseWritten = false;
			}
			//Added by Ravindra C on 14-1-19 to delete existing template - Start 
			else if ( "DELETE_TEMPLATE".equals( action ) )
			{
				String tempName = request.getParameter("TEMP_NAME");
				String objName = request.getParameter("OBJ_NAME"); 
				BaseLogger.log("3", null, null, "objName : ["+objName+"] tempName : ["+ tempName +"]");
				
				responseStr = getUploadFile().deleteTemplate(tempName, objName, userInfo);
				BaseLogger.log("3", null, null, "responseStr : ["+responseStr+"]" );
				
				if( uploadBean !=null && responseStr.equals("Success"))
				{
					uploadBean.setSelectedTemplate("");
					uploadBean.setFilePath(null);
					uploadBean.setRightChar("");
					uploadBean.setScopeValue(""); 
					uploadBean.setTempAddUser("");
					uploadBean.setShareScope(""); 
					uploadBean.setTempRightsChar("");
					HashMap<String, HashMap<String, String>> templateMap = getUploadFile().getTemplateDetail( objName, caller, userInfo );
					uploadBean.setTemplateMap( templateMap );
					uploadBean.setMatrixRowMap(null); 
					uploadBean.setSheetInfo( null );
				}
				isResponseWritten = false;
			}
			//Added by Ravindra C on 14-1-19 to delete existing template - End
			else if ("DOWNLOAD_FILE".equals( action ) )
			{
				String batchId = checkNull( getRequestParamValue( "BATCH_ID" ) );
				BaseLogger.log("3",null,null, "batchId ["+batchId+"]" );

				//Added By Ravindra C on 10-08-18 to get DocId for Download Document  - Start
				String refSer = "";
				if( batchId != null )
				{
					//changed By Ravindra C on 26-11-18 to provide transDB
					//refSer = getDBAccess().getDBColumnValue( " TRANSETUP " , " REF_SER ", " TRAN_WINDOW = 'I-BL'" );
					refSer = getDBAccess().getDBColumnValue( " TRANSETUP " , " REF_SER ", " TRAN_WINDOW = 'I-BL'", transDB );
				}
				BaseLogger.log("3",null,null,"refSer : ["+ refSer +"]");
				String docId = getUploadFile().getDocId( batchId, refSer, userInfo );
				BaseLogger.log("3",null,null,"DocId :["+ docId +"]");

				responseStr = docId;
				isResponseWritten = false;
            }
			//Added By Ravindra C on 12-09-2020 for Stop upload Thread - Start
            else if( "GET_UPLOAD_USER".equals( action ) )
			{
				String batchId = checkNull( getRequestParamValue( "BATCH_ID" ) );
				BaseLogger.log("3",null,null, "batchId ["+batchId+"]" );
				String userId ="";
				if( batchId != null )
				{
					userId = getDBAccess().getDBColumnValue( "BATCHLOAD", "CHG_USER", "TRAN_SL = '1' AND BATCH_ID ='"+ batchId +"'", transDB );
				}
				responseStr = userId;
				isResponseWritten = false;
			}
			else if( "CANCEL_UPLOAD".equals( action ) )
			{
				responseStr = "";
				Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
				for ( Thread thread : threadSet ) 
				{
					String batchId = checkNull( getRequestParamValue( "BATCH_ID" ) );
					if( batchId.equals( thread.getName() ) )
					{
						MasterApplyEJB.cancelledUploadThreads.add( batchId );
						responseStr ="success";
						break;
					}
				}
				isResponseWritten = false;
			}
			//Added By Ravindra C on 12-09-2020 for Stop upload Thread - End
			else
			{
				objName = getRequestParamValue("objName");
				if ( objName.length() > 0 )
				{
					//setSessionAttribute("objName", objName);
					uploadBean.setObjName( objName );
				}

				String tempName = getRequestParamValue("existingTemplate");

				if ( "new_template".equalsIgnoreCase( tempName ) )
				{
					isNewTemplate = true;
				}
				templateKey = objName + "::" + tempName;
				BaseLogger.log("3",null,null,"templateKey - [" + templateKey + "]");

				String isRetainPkValue = getRequestParamValue( "isRetainPkValue" );
				if ( isRetainPkValue.length() > 0 )
				{
					//setSessionAttribute( "isRetainPkValue", isRetainPkValue );
					uploadBean.setIsRetainPkValue( isRetainPkValue );
				}

				String excelFilePath = getRequestParamValue( "excelFilePath" );
				//Added By Ravindra C on 26-06-18 to check file type(xml / Excel)
				//if ( excelFilePath.length() > 0 )
				if ( excelFilePath.length() > 0 && ! "structured_xml".equalsIgnoreCase(tempName) )
				{
					//setSessionAttribute( "excelFile", excelFilePath );
					uploadBean.setFilePath( excelFilePath );
					//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] START
					//createExcelSheetInfo( excelFilePath, request );
					if ( "excel".equalsIgnoreCase( getRequestParamValue( "fileType" ) ) )
					{
						createExcelSheetInfo( excelFilePath, request );
					}
					else if ( "json".equalsIgnoreCase( getRequestParamValue( "fileType" ) ) )
					{
						createJsonFormDetailsInfo( excelFilePath );
					}
					//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] END
				}

				if ( "GET_TEMPLATE_LIST".equals( action ) )
				{
					//Changed By Ravindra C on 06-05-2018  -- Start
					//responseStr = "<Root><Detail>Success</Detail></Root>";
					BaseLogger.log("3",null,null, "GET_TEMPLATE_LIST - objName - ["+ objName +"]" );
					responseStr = setObjectDetail(userInfo);
					//if ( isMetadataExist( objName ) )
					if ( responseStr.indexOf( "<Errors>" ) == -1 )
					{
						//setSessionAttribute("objName", objName);
						uploadBean.setObjName( objName );

						String objDesc = getRequestParamValue("objDesc");
						BaseLogger.log("3",null,null, "objDesc on get_template_list - ["+ objDesc +"]" );//getting blank
						//setSessionAttribute("objDesc", objDesc);
						uploadBean.setObjDesc( objDesc );

						HashMap<String, HashMap<String, String>> templateMap = getUploadFile().getTemplateDetail( objName, caller, userInfo );
						//setSessionAttribute("templateMap", templateMap);
						uploadBean.setTemplateMap( templateMap );

						TemplateDetails.get(objName).setTemplateMap(templateMap);

						String defaultTemplate = TemplateDetails.get(objName).getDefaultTemplate();
						//setSessionAttribute("defaultTemplate", defaultTemplate);
						uploadBean.setDefaultTemplate( defaultTemplate );

						TreeMap<Integer, String> formDetailInfo = getUploadFile().getFormWiseTitleMap(objName, userInfo);
						//setSessionAttribute("formDetailInfo", formDetailInfo);
						uploadBean.setFormDetailInfo( formDetailInfo );
					}
					//Commented BY Ravindra C on 05-06-2018 -- Start
					/*else
					{
						responseStr = genericUtility.getErrorString( "", "METADATANT", userId );
						//setSessionAttribute( "errorMsg", responseStr );

						//sessionRemoveAttribute( "objName" );
						//sessionRemoveAttribute( "objDesc" );
					}*/
					//Commented BY Ravindra C on 05-06-2018 -- End
					isResponseWritten = false;
				}
				else if ( "SET_SELECTED_TEMPLATE".equals( action ) )
				{
					String fileMappingXml = "";
					BaseLogger.log("3",null,null,"tempName - ["+tempName+"]");
					BaseLogger.log("3",null,null,"503 In SET_SELECTED_TEMPLATE =====>tempName - ["+tempName+"]");
					
					//Added By Ravindra C on 26-06-18 to check file type(xml / Excel) - Start
					if( "structured_xml".equalsIgnoreCase( tempName ) )
					{
						uploadBean.setSelectedTemplate( tempName );
						uploadBean.setObjName( objName );
						String objDesc = getRequestParamValue("objDesc");
						uploadBean.setObjDesc( objDesc );
					}
					else
					{
						//Added By Ravindra C on 26-06-18 to check file type(xml / Excel) - End
						if( ! isNewTemplate() )
						{
							BaseLogger.log("3",userInfo,null,"OBJNAME - ["+objName+"]");
							fileMappingXml = checkNull(TemplateDetails.get( objName ).getFileMapping(tempName));
							if( fileMappingXml.length() == 0 )
							{
								responseStr = genericUtility.getErrorString( "", "FILEMAPNOE", userId );
							}
						}
						BaseLogger.log("3",null,null,"fileMappingXml - ["+fileMappingXml+"]");
						//changed By Ravindra C on 06-09-18 for prevent SYSOUT. - End
						if ( responseStr.length() == 0 )
						{
							BaseLogger.log("3",null,null,"tempName - [" + tempName + "]");
							//setSessionAttribute("selectedTemplate", tempName);
							uploadBean.setSelectedTemplate( tempName );

							BaseLogger.log("3",null,null,"objName - [" + objName + "]");
							//setSessionAttribute("objName", objName);
							uploadBean.setObjName( objName );

							String objDesc = getRequestParamValue("objDesc");
							BaseLogger.log("3",null,null,"objDesc - [" + objDesc + "]");
							//setSessionAttribute("objDesc", objDesc);
							uploadBean.setObjDesc( objDesc );

							//Added By Prasad R on 23-04-18 for upload Utility - Start
							if( ! isNewTemplate() && ! "Process_Temp".equalsIgnoreCase( caller ) )
							{
								String docId = checkNull( TemplateDetails.get( objName ).getDocId( tempName ) );
								if ( docId.length() > 0 )
								{
									downloadTemplate( docId );
								}
							}
							//Added By Prasad R on 23-04-18 for upload Utility - End
							setSelectedTemplate( tempName );

							
							//Commented by Ravindra C on 15-02-2021 [as on template selection, it is not required] START
							//excelFilePath = (String) getSessionAttribute("excelFile");
							/*excelFilePath = uploadBean.getFilePath();
							BaseLogger.log("3",null,null,"excel file - [" + excelFilePath + "]");
							if ( excelFilePath != null )
							{
								//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] START
								//responseStr = createExcelColumnMap(excelFilePath, request);
								String fileType = getRequestParamValue("fileType");
								if( "excel".equalsIgnoreCase( fileType ) )
								{
									responseStr = createExcelColumnMap( excelFilePath, request );
								}
								else if( "json".equalsIgnoreCase( fileType ) )
								{
									responseStr = createJsonColumnMap( excelFilePath, request );
								}
								//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] END
							}*/
							//Commented by Ravindra C on 15-02-2021 [as on template selection, it is not required] END
						}
					}
					if ( responseStr.indexOf( "<Errors>" ) == -1 )
					{
						responseStr = "<Root><Detail>Success</Detail></Root>";
					}

					isResponseWritten = false;
				}
				else if ( "GET_HEADER_ROW_COUNT".equals( action ) )
				{
					
					if ( getRequestParamValue( "formNo" ).length() > 0 )
					{
						formNo = Integer.parseInt(getRequestParamValue("formNo"));
					}
					BaseLogger.log("3",null,null,"formNo - [" + formNo + "]");

					String fileType = getRequestParamValue("fileType");
				    fileFormatType = fileType;
					//setSessionAttribute("fileType", fileType);
					uploadBean.setFileType( fileType );

					//Removing excelSheetInfo session attribute to getHeaderRowCount
					//sessionRemoveAttribute( "excelSheetInfo" );
					
					uploadBean.setExcelSheetInfo( null );

					BaseLogger.log("3",null,null,"fileType - [" + fileType + "]");
					//excelFilePath = (String) getSessionAttribute("excelFile");
					excelFilePath = uploadBean.getFilePath();
					BaseLogger.log("3",null,null, "excelFilePath - [" + excelFilePath + "]" );
					//Added By Ravindra C on 26-06-18 to check file type(xml / Excel) - Start
					//if ( excelFilePath != null )
					if ( excelFilePath != null && ! "structured_xml".equalsIgnoreCase( tempName ) )
					{
						//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] START
						//responseStr = createExcelColumnMap(excelFilePath, request);
						if( "excel".equalsIgnoreCase( fileType ) )
						{
							responseStr = createExcelColumnMap( excelFilePath, request );
						}
						else if( "json".equalsIgnoreCase( fileType ) )
						{
							responseStr = createJsonColumnMap( excelFilePath, request );
						}
						else if("xml".equalsIgnoreCase(fileType)) {
							BaseLogger.log("3",null,null, "Got File Type XML in GET_HEADER_ROW_COUNT ["+ excelFilePath +"]" );
							responseStr = createXmlColumnMap(excelFilePath,request);
						}
						
						//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] END
						BaseLogger.log("3",null,null,"In GET_HEADER_ROW_COUNT =====>filePath - ["+uploadBean.getFilePath()+"]");
						sampleFilePath = uploadBean.getFilePath();
						sheetInfo.putAll( uploadBean.getFormDetailInfo());
						BaseLogger.log("3",userInfo,null, "responseStr - ["+ responseStr +"]" );
						BaseLogger.log("3",userInfo,null, "formdetailinfo new - ["+ uploadBean.getFormDetailInfo() +"]" );
						BaseLogger.log("3",userInfo,null, "formdetailinfo new - ["+ uploadBean.getExcelSheetInfo() +"]" );
						//changed By Ravindra C on 06-09-18 for prevent SYSOUT. - End
					}
					if ( responseStr.indexOf( "<Errors>" ) == -1 )
					{
						//Added By Ravindra C on 26-06-18 to check file type(xml / Excel) - Start
						if ( ! "structured_xml".equalsIgnoreCase(tempName) && "excel".equalsIgnoreCase( fileType ) )
						{
							responseStr = validateTemplate(formNo, request);

							BaseLogger.log("3",null,null,"responseStr GET_HEADER_ROW_COUNT - [" + responseStr + "]");
							if ( responseStr.indexOf( "<Errors>" ) == -1 && ! isNewTemplate() )
							{
								String uploadRowCount = getUploadRowCount( tempName, fileType, userInfo, request, response, templateKey, action );
								BaseLogger.log("3",null,null,"--------------uploadRowCount : [" + uploadRowCount + "]");
								responseStr = "<Root><Detail><upload_row_count>"+ uploadRowCount +"</upload_row_count></Detail></Root>";
							}
						}
					}
					//Added By Ravindra C on 26-08-19 for upload on another server related changes - Start 
					if( requestParamMap.containsKey( "SERVER_DOWN" ) )
					{ 		
						responseStr = genericUtility.getErrorString( "", "SERDOWN", userId );
					}
					//Added By Ravindra C on 26-08-19 for upload on another server related changes - End
					isResponseWritten = false;
				}
				else if ( "VALIDATE_TEMPLATE".equals( action ) )
				{
					BaseLogger.log("3",null,null,"tempName - [" + tempName + "]");
					if ( getRequestParamValue( "formNo" ).length() > 0 )
					{
						formNo = Integer.parseInt(getRequestParamValue("formNo"));
					}

					String templateXml = TemplateDetails.get(objName).getTemplateXml(tempName);
					String fileMappingXml = TemplateDetails.get(objName).getFileMapping(tempName);

					int totalForms = getNoOfForms();
					TemplateDetails.get(templateKey).createTemplateDetail(templateXml, totalForms);
					TemplateDetails.get(templateKey).createFileMappingDetail(fileMappingXml);

					//excelFilePath = (String) getSessionAttribute("excelFile");
					excelFilePath = uploadBean.getFilePath();
					if ( excelFilePath != null )
					{
						//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] START
						//createExcelColumnMap( excelFilePath, request );
						String fileType = getRequestParamValue("fileType");
						if( "excel".equalsIgnoreCase( fileType ) )
						{
							responseStr = createExcelColumnMap( excelFilePath, request );
						}
						else if( "json".equalsIgnoreCase( fileType ) )
						{
							responseStr = createJsonColumnMap( excelFilePath, request );
						}
						//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] END
					}

					responseStr = validateTemplate(formNo, request);
					if ( responseStr.indexOf( "<Errors>" ) == -1 )
					{
						BaseLogger.log("3",null,null, "valid" );
						//setSessionAttribute( "selectedTemplate", tempName );
						uploadBean.setSelectedTemplate( tempName );
						setSelectedTemplate( tempName );
					}
					else
					{
						BaseLogger.log("3",null,null,"Invalid template");
					}
					isResponseWritten = false;
				}
				else if ( "SAVE_TEMPLATE".equals( action ) )
				{
					//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] START
					String fileType = uploadBean.getFileType();
					BaseLogger.log( "3", null, null, "fileType : ["+ fileType +"]" );
					if( "excel".equalsIgnoreCase( fileType ) )
					{
						setTemplateData();
					}
					else
					{
						//TODO: for other format
					}
					//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] END
					responseStr = saveTemplate( request );
					BaseLogger.log( "3", null, null, "SAVE_TEMPLATE responseStr : ["+ responseStr +"]" );
					isResponseWritten = false;
				}
				else if ( "PROCESS_TEMPLATE".equals( action ) )
				{
					System.out.println("In PROCESS_TEMPLATE Action");
					BaseLogger.log("3",null,null,"tempName - [" + tempName + "]");
					BaseLogger.log("3",null,null,"TemplateKey - [" + templateKey + "]");
					BaseLogger.log("3",null,null,"tempName - [" + tempName + "]");

					//added by Ravindra c on 08-02-19 to check User's right for process template - Start
					String  userLevel = userInfo.getUserLevel();
					BaseLogger.log("3",null,null,"userLevel :[" + userLevel + "]");
					if( !"0".equals( userLevel ) )
					{
						String resStr = getUploadFile().getUserRightInfo( objName, userId, userInfo );
						BaseLogger.log("3",null,null,"resStr [" + resStr + "]");
						if( resStr.indexOf( "U" ) != -1 || resStr.indexOf( "*" ) != -1 ) 
						{}
						else
						{
							responseStr = genericUtility.getErrorString( "", "VTUPLDRGHT", userId );
						}
					}
					//added by Ravindra c on 08-02-19 to check User's right for process template - End
					if ( responseStr.indexOf("<Errors>") == -1 && responseStr.length() == 0 )
					{
						// Code re-added by Ankush S 07-Sep-2022
						String fileType = getRequestParamValue("fileType");
						BaseLogger.log("3", null, null, "Before filetype check FileType===>   " + fileType);
						// boolean dailyUploadLimitExceed = getUploadFile().checkDailyUploadLimitExcced(
						// userInfo );

						boolean dailyUploadLimitExceed = new UploadFileEJB().checkDailyUploadLimitExcced(userInfo);
						if (dailyUploadLimitExceed) {
							responseStr = genericUtility.getErrorString("", "ULIMEXCEED", userInfo.getLoginCode());
							BaseLogger.log("2", userInfo, null,
									"UploadTemplateServlet.doPost() PROCESS_TEMPLATE action Daily Upload Limit Exceed responseStr : ["
											+ responseStr + "]");
						} else {
							if ("json".equals(fileType)) {
								// Comment removed by Ankush S. 06-Sep-2022
								int index = uploadBean.getFilePath().lastIndexOf("/");
								String fileName = uploadBean.getFilePath().substring(index + 1);
								System.out.println("In file type json===========>");
								String[] fileInfoArr = new String[5];
								fileInfoArr[0] = "";
								fileInfoArr[1] = fileName;
								fileInfoArr[2] = objName;
								fileInfoArr[3] = "";
								fileInfoArr[4] = tempName;
								// BaseLogger.log("3",null,null," JSON fileInfoArr : ["+
								// Arrays.asList(fileInfoArr) +"]");
								BaseLogger.log("3", null, null,
										" JSON fileInfoArr : [<=========In File type JSON==========>]");
								File DUMP_DIR = new File(uploadBean.getFilePath().substring(0, index + 1));
								BaseLogger.log("3", null, null, "DUMP_DIR : [" + DUMP_DIR + "]");
								responseStr = new ITMUploadFileEJB().insertFileData(fileInfoArr, userInfo, DUMP_DIR,
										CommonConstants.APPLICATION_CONTEXT, "", false, false);

							} else if ("xml".equalsIgnoreCase(fileType)) {
								BaseLogger.log("3", null, null,
										"Got file Type in process_template - [" + fileType + "]");
								int index = uploadBean.getFilePath().lastIndexOf("/");
								String fileName = uploadBean.getFilePath().substring(index + 1);
								System.out.println("In file type json===========>");
								String[] fileInfoArr = new String[5];
								fileInfoArr[0] = "";
								fileInfoArr[1] = fileName;
								fileInfoArr[2] = objName;
								fileInfoArr[3] = "";
								fileInfoArr[4] = tempName;
								// BaseLogger.log("3",null,null," JSON fileInfoArr : ["+
								// Arrays.asList(fileInfoArr) +"]");
								BaseLogger.log("3", null, null,
										" JSON fileInfoArr : [<=========In File type JSON==========>]");
								File DUMP_DIR = new File(uploadBean.getFilePath().substring(0, index + 1));
								BaseLogger.log("3", null, null, "DUMP_DIR : [" + DUMP_DIR + "]");
								responseStr = new ITMUploadFileEJB().insertFileData(fileInfoArr, userInfo, DUMP_DIR,
										CommonConstants.APPLICATION_CONTEXT, "", false, false);
								BaseLogger.log("3", null, null,
										"responseStr in process_template - [" + responseStr + "]");
							}

							else {
								// in PROCESS_TEMPLATE
								responseStr = applyTemplate(tempName, fileType, userInfo, request, response,
										templateKey, action, sessionId);
							}
						}
						BaseLogger.log("3", null, null, "--------------returnString : " + responseStr);
						// request.getSession().setAttribute("respString", responseStr);
						if (responseStr.indexOf("<Errors>") == -1) {
							removeSessionAttribute(caller);
							responseStr = "<Root><Detail><BATCH_ID>" + responseStr + "</BATCH_ID></Detail></Root>";
						}
						// }

						/*******
						 * Comment added by Ankush 07-Sep-2022 Comment above
						 * 
						 * //Added By Pankaj T. on 06-07-2022 [To add validation for daily upload limit
						 * against enterprise ] - start /*boolean dailyUploadLimitExceed =
						 * getUploadFile().checkDailyUploadLimitExcced( userInfo ); if(
						 * dailyUploadLimitExceed ) { responseStr = genericUtility.getErrorString("",
						 * "ULIMEXCEED", userInfo.getLoginCode()); BaseLogger.log("2", userInfo, null,
						 * "UploadTemplateServlet.doPost() PROCESS_TEMPLATE action Daily Upload Limit
						 * Exceed responseStr : ["+responseStr+"]"); } //Added By Pankaj T. on
						 * 06-07-2022 [To add validation for daily upload limit against enterprise ] -
						 * end else { //changed By Ravindra C on 06-09-18 for prevent SYSOUT. - End
						 * String fileType = getRequestParamValue("fileType"); //Changed By Ravindra C
						 * on 07-09-18 for error file download. //responseStr = applyTemplate( tempName,
						 * fileType, userInfo, request, response, templateKey, action);
						 * BaseLogger.log("3",null,null,"Before filetype check FileType===> "+fileType);
						 * if( "json".equals(fileType) ) { //Comment removed by Ankush S. 06-Sep-2022
						 * int index = uploadBean.getFilePath().lastIndexOf("/"); String fileName =
						 * uploadBean.getFilePath().substring( index + 1 );
						 * 
						 * String[] fileInfoArr = new String[5]; fileInfoArr[0] = ""; fileInfoArr[1] =
						 * fileName; fileInfoArr[2] = objName; fileInfoArr[3] = ""; fileInfoArr[4] =
						 * tempName; //BaseLogger.log("3",null,null," JSON fileInfoArr : ["+
						 * Arrays.asList(fileInfoArr) +"]"); BaseLogger.log("3",null,null," JSON
						 * fileInfoArr : [<=========In File type JSON==========>]"); File DUMP_DIR = new
						 * File( uploadBean.getFilePath().substring(0, index + 1));
						 * BaseLogger.log("3",null,null,"DUMP_DIR : ["+ DUMP_DIR +"]"); responseStr =
						 * new ITMUploadFileEJB().insertFileData( fileInfoArr, userInfo, DUMP_DIR,
						 * CommonConstants.APPLICATION_CONTEXT, "", false, false ); } else { responseStr
						 * = applyTemplate( tempName, fileType, userInfo, request, response,
						 * templateKey, action, sessionId ); }
						 * BaseLogger.log("3",null,null,"--------------returnString : " + responseStr);
						 * //request.getSession().setAttribute("respString", responseStr); if (
						 * responseStr.indexOf("<Errors>") == -1 ) { removeSessionAttribute( caller );
						 * responseStr = "<Root><Detail><BATCH_ID>"+ responseStr
						 * +"</BATCH_ID></Detail></Root>"; } }
						 */
					}
					isResponseWritten = false;
				}
				else if( "GET_TEMP_ATTACHMENT_DETAILS".equals( action ) )
				{
					String attachobjName = getRequestParamValue( "OBJ_NAME" );

					//Commented By Ravindra C on 10-08-18 no need for these - Start
					/*HashMap<String, HashMap<String, String>> templateMap = getUploadFile().getTemplateDetail(attachobjName, caller, userInfo);
					objWiseTemplateBean.setTemplateMap( templateMap );*/
					//Commented By Ravindra C on 10-08-18 no need for these - End

					String templName = request.getParameter("TEMPL_NAME");
					String refId = checkNull( TemplateDetails.get(attachobjName).getTemplateId( templName ) );
					String docId = checkNull( TemplateDetails.get(attachobjName).getDocId( templName ) );
					responseStr = refId + "&" + docId;

					//added by ravindra c on 10-08-18 to get the DocId from database. - Start
					if( refId.equals("") && docId.equals("") )
					{
						responseStr = getUploadFile().getDocIdNrefId(attachobjName, templName, userInfo);
					}
					BaseLogger.log("3",null,null,"responseStr : ["+ responseStr +"]");
					//added by ravindra c on 10-08-18 to get the DocId from database. - End
					isResponseWritten = false;
				}
				else if ( "VALIDATE_INPUT_DATA".equals( action ) )
				{
					//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] START
					//responseStr = validateInputData();
					String fileType = uploadBean.getFileType();
					BaseLogger.log( "3", null, null, "fileType : ["+ fileType +"]" );
					BaseLogger.log( "3", null, null, "fileType : ["+ uploadBean.getFilePath() +"]" );
					
					if( "excel".equalsIgnoreCase( fileType ) )
					{
						responseStr = validateInputData();
					}
					//Added By Ankush S on 17Oct-2022 [to validate xml file data]START
					if("xml".equalsIgnoreCase(fileType)) {
						BaseLogger.log( "3", userInfo, null, "Got XML file to validate Data" );
						responseStr = validateXmlInputData();
					}
					//Added By Ankush S on 17Oct-2022 [to validate xml file data]END
					else
					{
						responseStr = "<Root><Detail>Success</Detail></Root>"; //Need to change
					}
					
					//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] END
					isResponseWritten = false;
				}
				else if ( "SET_TEMPLATE_DATA".equals( action ) )
				{
					//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] START
					//responseStr = setTemplateData();
					String fileType = uploadBean.getFileType();
					BaseLogger.log( "3", null, null, "fileType : ["+ fileType +"]" );
					BaseLogger.log( "3", userInfo, null, "fileType in SET_TEMPLATE_DATA: ["+ fileType +"]" );
					if( "excel".equalsIgnoreCase( fileType ) )
					{
						responseStr = setTemplateData();
					}
					else if("json".equalsIgnoreCase(fileType))
					{
						//uploadBean.setSheetInfo( uploadBean.getExcelSheetInfo() );
						//responseStr = "<Root><Detail>Success</Detail></Root>"; //Need to Change
						responseStr = setJsonTemplateData();
					}
					//Added By Ankush S on 27-Oct-2022 [to set xml file data]START
					else if("xml".equalsIgnoreCase(fileType)) {
						BaseLogger.log( "3", userInfo, null, "Got fileType XML in SET_TEMPLATE_DATA: ["+ fileType +"]" );
						responseStr = setXmlTemplateData();
					}
					//Added By Ankush S on 27-Oct-2022 [to set xml file data]END
					//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] END
					isResponseWritten = false;
				}
				
			}
			BaseLogger.log("3",null,null,"In UploadTemplateServlet..........., returnString - [" + responseStr + "]");
		}
		catch (ITMException e)
		{
			isResponseWritten = false;
			responseStr = genericUtility.createErrorString(e);
			BaseLogger.log("0",null,null,"ITMException - responseStr - [" + responseStr + "]");
			//setSessionAttribute("errorMsg", responseStr);
		}
		catch (Exception e)
		{
			isResponseWritten = false;
			responseStr = genericUtility.createErrorString(e);
			BaseLogger.log("0",null,null,"Exception -responseStr - [" + responseStr + "]");
			//setSessionAttribute("errorMsg", responseStr);
		}
		finally
		{
			if ( ! isResponseWritten )
			{
				//To remove exception or string message before xmlString
				if( responseStr != null && responseStr.indexOf( "<Errors>" ) != -1 && responseStr.indexOf( "<Errors>" ) != 0 )
				{
					responseStr = responseStr.substring( responseStr.indexOf( "<Errors>" ) );
				}
				PrintWriter out = response.getWriter();
				out.print(responseStr);
				out.flush();
			}
		}
	}
    //Commented By Ravindra C on 10-09-18 use direct instance. - Start
	/*private InitialContext getInitialContext()
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch (NamingException e)
		{
			e.printStackTrace();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return ctx;
	}*/
	//Commented By Ravindra C on 10-09-18 use direct instance. - End

	private UploadFileEJB getUploadFile() throws NamingException
	{
		//if ( uploadFile == null )
		//{
			//uploadFile = (UploadFileRemote) getInitialContext().lookup("ibase/UploadFileEJB/remote");
			uploadFile = new UploadFileEJB();
		//}
		return uploadFile;
	}

	private String checkNull( String nullStr )
	{
		return E12GenericUtility.checkNull(nullStr);
	}

	/**
	 * Create request param map
	 *
	 * @param request
	 * @return
	 */
	private TreeMap<String, String> getRequestParamMap( HttpServletRequest request )
	{
		TreeMap<String, String> dataMap = new TreeMap<String, String>();
		try
		{
			String paramName = "";
			String paramValue = "";
			//Added By Ravindra C on 10-08-19 for Remote upload server related option.
			String newExcelFilePath  ="";
			String uploadFilepath ="";
			String newFileName ="";
			//Added By Ravindra C on 10-08-19 for Remote upload server related option. -End
			if ( isMultipart( request ) )
			{
				MultipartParser parser = new MultipartParser(request, 10 * 1024 * 1024);
				Part part = null;
				while ( (part = parser.readNextPart()) != null )
				{
					if ( part.isParam() )
					{
						ParamPart paramPart = (ParamPart) part;
						paramName = checkNull(part.getName());
						paramValue = checkNull(paramPart.getStringValue());
						BaseLogger.log("3",null,null, "MultipartParser :: parameterName - ["+ paramName +"], parameterValue - ["+ paramValue +"]" );

						if ( ! paramValue.equalsIgnoreCase( "none" ) )
						{
							dataMap.put(paramName, paramValue);
						}
					}

					if ( part.isFile() )
					{
						FilePart filePart = (FilePart) part;
						String fileName = filePart.getFileName();
						if ( fileName != null )
						{
							File DUMP_DIR = new File( CommonConstants.TEMP_FOLDER );
							DUMP_DIR.mkdir();
							long size = filePart.writeTo(DUMP_DIR);

							String excelFilePath = DUMP_DIR + File.separator + fileName;
							File excelFile = new File( excelFilePath );
							BaseLogger.log("3",null,null,"filename: " + excelFile);

							newFileName = fileName.substring( 0, fileName.lastIndexOf( "." ) );
							String fileType = fileName.substring( fileName.lastIndexOf( "." ) + 1 );
							newFileName = newFileName + "_" + userId + "_" + System.currentTimeMillis() + "." + fileType;
							//commented By Ravindra C on 06-09-18 for prevent SYSOUT.
							//BaseLogger.log("3",null,null, "newFileName - ["+ newFileName +"]" );

							newExcelFilePath = DUMP_DIR + File.separator + newFileName;
							File newExcelFile = new File( newExcelFilePath );
					        if( excelFile.renameTo( newExcelFile ))
					        {
					            BaseLogger.log("3",null,null,"File rename success");
					        }
					        else
					        {
					            BaseLogger.log("3",null,null,"File rename failed");
					        }
					        dataMap.put( "excelFilePath", newExcelFilePath );
					        //excelFile = new File( excelFilePath );
							//BaseLogger.log("3",null,null,"filename: " + excelFile);
							//setSessionAttribute("excelFile", newExcelFilePath );
					        if ( uploadBean == null )
					        {
					        	String caller = dataMap.get( "caller" );
								uploadBean = (UploadTemplateBean) getSessionAttribute( caller + "UPLOAD_BEAN" );
					        }
					        if ( uploadBean != null )
					        {
					        	uploadBean.setFilePath( newExcelFilePath );
					        }

							//Added By Ravindra C on 14-04-18 For upload Utility --Start
							File DUMP_DIR2 = new File( CommonConstants.TEMP_FOLDER + File.separator + "to_upload" );
							DUMP_DIR2.mkdir();
							uploadFilepath = DUMP_DIR2 + File.separator + newFileName;
							InputStream inStream = null;
							OutputStream outStream = null;
							try
							{
								File temp = new File( newExcelFilePath );
								inStream = new FileInputStream( temp );

								File temp2 = new File( uploadFilepath );
								if ( ! temp2.exists() )
								{
									temp2.createNewFile();
								}
								outStream = new FileOutputStream( temp2 );

								byte[] buffer = new byte[1024];
								int length;
								while ((length = inStream.read(buffer)) > 0)
								{
									outStream.write(buffer, 0, length);
								}
								inStream.close();
								outStream.close();
								BaseLogger.log("3",null,null,"File is copied successful!");

								//setSessionAttribute( "uploadExcelpath", uploadExcelpath );
								if ( uploadBean != null )
						        {
									uploadBean.setUploadFilepath( uploadFilepath );
						        }
							}
							catch(IOException e)
							{
								BaseLogger.log("0",null,null, "IOException : ["+ e.getMessage() +"]" );
								e.printStackTrace();
							}
							//Changed By Ravindra C on 14-04-18 For upload Utility -- END
							
							//Added By Ravindra C on 10-08-19 for Remote upload server related option. - Start
							if( CommonConstants.BACKGROUND_JOB_SERVER.length() > 0 )
							{
								boolean isServerStop  = callRemoteUpoadTemplateServlet( newExcelFilePath, uploadFilepath, newFileName );
								if( isServerStop )
								{
									dataMap.put("SERVER_DOWN", CommonConstants.BACKGROUND_JOB_SERVER);
								}
							}
							//Added By Ravindra C on 10-08-19 for Remote upload server related option. - End
						}
					}
				}
			}
			else
			{
				Enumeration<String> parameterNames = request.getParameterNames();
				while (parameterNames.hasMoreElements())
				{
					paramName = checkNull(parameterNames.nextElement());
					paramValue = checkNull(request.getParameter(paramName));

					BaseLogger.log("3",null,null,"parameterName - [" + paramName + "], parameterValue - [" + paramValue + "]");
					dataMap.put(paramName, paramValue);
				}
			}
			BaseLogger.log("3",null,null,"dataMap - [" + dataMap + "]");
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return dataMap;
	}
	//Added By Ravindra C on 10-08-19 for Remote upload server related option. - Start
	private boolean callRemoteUpoadTemplateServlet( String newExcelFilePath, String uploadFilepath, String newFileName ) throws ITMException, RemoteException
	{
		
		String path = CommonConstants.BACKGROUND_JOB_SERVER;
		String userId = userInfo.getLoginCode();
		//String password = userInfo.getLoginPwd();
		
		DBAccessEJB accessEJB = new DBAccessEJB();
		String password = accessEJB.getDBColumnValue("USERS", "PASS_WD_SHA", "CODE ='"+ userId +"'" );
		BaseLogger.log("3", null, null, "password -> ["+ password +"]");
		
		FileInputStream inStream = null;
		BufferedInputStream bfr = null;
		ByteArrayOutputStream bout = null;
		byte[] byteArray = {0};
		String response = "";
		boolean isServerStop = false;
		try
		{
			File temp = new File( newExcelFilePath );
			inStream = new FileInputStream( temp );

			bfr=new BufferedInputStream(inStream);
			bout=new ByteArrayOutputStream();

			int i=-1;
			while(( i= bfr.read()) != -1 )
			{
				bout.write(i);
			}
			byteArray = bout.toByteArray();
			inStream.close();
		}
		catch(IOException io)
		{
			io.printStackTrace();
			BaseLogger.log("0", null, null," callRemoteUpalodTemplateServlet IOException : ["+ io.getMessage() +"]");
		}
		
		String requestURL = path + "/ibase/WebITMRemoteUploadTemplateServlet?ACTION=MOVE_UPLOAD_FILE"
				+ "&USER="+ userId
				+ "&PASSWORD="+ password 
		        + "&isSHA256Appld=true"; 

		BaseLogger.log("3", null, null,"requestUrl : ["+ requestURL +"]");
		try 
		{
			CloseableHttpClient client = HttpClients.createDefault();
			HttpPost httpPost = new HttpPost( requestURL );

			MultipartEntityBuilder builder = MultipartEntityBuilder.create();
			builder.addBinaryBody( "UPLOAD_FILE_DATA", byteArray, ContentType.DEFAULT_BINARY, newFileName );

			HttpEntity entity = builder.build();
			httpPost.setEntity( entity );

			CloseableHttpResponse httpResponse = client.execute( httpPost );

			HttpEntity responseEntity = httpResponse.getEntity();
			BaseLogger.log("3", userInfo,  null, "StatusCode : ["+ httpResponse.getStatusLine().getStatusCode() +"], ReasonPhrase : ["+ httpResponse.getStatusLine().getReasonPhrase() +"]");
			InputStream in = responseEntity.getContent();
			response = IOUtils.toString( in, CommonConstants.ENCODING );

			BaseLogger.log("0", null, null,"response : ["+ response +"]");

			in.close();
			client.close();
		} 
		catch ( Exception e) 
		{
			BaseLogger.log("0", null, null," callRemoteUpalodTemplateServlet Exception getMessage :["+ e.getMessage() +"]");
			BaseLogger.log("0", null, null," callRemoteUpalodTemplateServlet Exception getClass :["+ e.getClass() +"]");
			e.printStackTrace();
			
			if( "org.apache.http.conn.HttpHostConnectException".equalsIgnoreCase(e.getClass().getName()) )
			{
				isServerStop = true;
			}
		}
		return isServerStop; 
	}
	//Added By Ravindra C on 10-08-19 for Remote upload server related option. - End
	/**
	 * Get request parameter value
	 *
	 * @param paramName
	 * @return
	 */
	private String getRequestParamValue( String paramName )
	{
		if ( requestParamMap != null )
		{
			return checkNull(requestParamMap.get(paramName));
		}
		return "";
	}

	/**
	 * To check request is multipart or not
	 *
	 * @param request
	 * @return
	 */
	private boolean isMultipart( HttpServletRequest request )
	{
		if (request.getContentType() != null && request.getContentType().toLowerCase().indexOf("multipart/form-data") > -1 )
		{
			return true;
		}
		return false;
	}

	/**
	 * @return the noOfSheet
	 */
	private int getNoOfSheet()
	{
		return noOfSheet;
	}

	/**
	 * @param noOfSheet the noOfSheet to set
	 */
	private void setNoOfSheet(int noOfSheet)
	{
		this.noOfSheet = noOfSheet;
	}

	/**
	 * @return the userInfo
	 */
	private UserInfoBean getUserInfo()
	{
		return userInfo;
	}

	/**
	 * Create workbook from excel file path
	 *
	 * @param excelFilePath
	 * @return
	 * @throws ITMException
	 */
	private Workbook getWorkbook( String excelFilePath ) throws ITMException
	{
		try
		{
			if ( workbook == null )
			{
//				File excelFile = new File(excelFilePath);
//				workbook = Workbook.getWorkbook(excelFile);
				
				//Danish on 13OCT23 setting encoding while reading excel file
				System.out.println("Setting Cp1252 as UTF-8 Charset is not working");
				WorkbookSettings ws = new WorkbookSettings();
				ws.setEncoding("Cp1252");
				File excelFile = new File(excelFilePath);
				workbook = Workbook.getWorkbook(excelFile,ws);
				setNoOfSheet(workbook.getNumberOfSheets());
			}
		}
		catch (BiffException e)
		{
			throw new ITMException(e);
		}
		catch (IOException e)
		{
			throw new ITMException(e);
		}
		return workbook;
	}

	/**
	 * Create excel sheet info
	 *
	 * @param excelFilePath
	 * @param request
	 * @throws ITMException
	 */
	private void createExcelSheetInfo( String excelFilePath, HttpServletRequest request ) throws ITMException
	{
		try
		{
			HashMap<Integer, String> excelSheetInfo = uploadBean.getExcelSheetInfo();
			if ( excelSheetInfo == null )
			{
				excelSheetInfo = new HashMap<Integer, String>();
				workbook = getWorkbook(excelFilePath);
				int noOfSheet = getNoOfSheet();
				BaseLogger.log("3",null,null,"noOfSheet [" + noOfSheet + "]");

				for ( int i = 0; i < noOfSheet; i++ )
				{
					Sheet sheet = workbook.getSheet(i);
					if (sheet.getColumns() != 0)
					{
						excelSheetInfo.put(i + 1, sheet.getName());
					}
				}
				//setSessionAttribute("excelSheetInfo", excelSheetInfo);
				uploadBean.setExcelSheetInfo( excelSheetInfo );
				//sheetInfo.putAll(excelSheetInfo);
				BaseLogger.log("3",null,null,"excelSheetInfo [" + excelSheetInfo + "]");
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] START
	private void createJsonFormDetailsInfo( String excelFilePath ) throws Exception
	{
		HashMap<Integer, String> excelSheetInfo = uploadBean.getExcelSheetInfo();
		if( excelSheetInfo == null )
		{
			String jsonString = genericUtility.readFile( excelFilePath );
			
			excelSheetInfo =  (new JSONtoXMLConverter()).getJSONFormDetailsMap( jsonString );
		}
		
		BaseLogger.log( "3", null, null, "excelSheetInfo : ["+ excelSheetInfo +"]" );
		uploadBean.setExcelSheetInfo( excelSheetInfo );
		//sheetInfo.putAll(excelSheetInfo);
		//uploadBean.setSheetInfo(excelSheetInfo);
	}
	//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] END
	
	//Added By Ankush S on 13-Oct-2022 [to xml data mapping implementation]START
	private void createXmlFormDetailsInfo(String xmlFilePath)throws Exception {
		HashMap<Integer, String> excelSheetInfo = uploadBean.getExcelSheetInfo();
		BaseLogger.log( "3", null, null, "excelSheetInfo in createXmlFormDetailsInfo : ["+ excelSheetInfo +"]" );
		try {
		if( excelSheetInfo == null )
		{
			
			excelSheetInfo = new HashMap<Integer, String>();
			//read xml file and put data in excelSheetInfo Map
			/*DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document document = documentBuilder.parse(xmlFilePath);
			NodeList rootNodeList = document.getChildNodes();
			Node rootNode = null;
			NodeList rootNodeChildList= null;
			if(rootNodeList.getLength()==1) {
				rootNode = rootNodeList.item(0);*/
			System.out.println("GOt xmlfilepath "+xmlFilePath);
			NodeList rootNodeChildList= null;
				rootNode = getRootNode(xmlFilePath);
				rootNodeChildList = rootNode.getChildNodes();
				for(int i=0;i<rootNodeChildList.getLength();i++) {
					Node childNode = rootNodeChildList.item(i);		
					System.out.println("sheet info nodename"+childNode.getNodeName());
					if(!childNode.getNodeName().contains("#")) {	
						if(!excelSheetInfo.containsValue(childNode.getNodeName()))
						excelSheetInfo.put(excelSheetInfo.size()+1,childNode.getNodeName());
					}
				}
			}
		BaseLogger.log( "3", userInfo, null, "excelSheetInfo : ["+ excelSheetInfo +"]" );
		uploadBean.setExcelSheetInfo( excelSheetInfo );
		//sheetInfo.putAll(excelSheetInfo);
		}catch(Exception e) {
			BaseLogger.log("3",userInfo,null,"Error in createXmlFormDetailsInfo==>"+e.getMessage());
			e.printStackTrace();
		}
	}
	//Added By Ankush S on 13-Oct-2022 [to xml data mapping implementation]END
	//Added By Ankush s on 21-Oct-2022 [to get root node from xml document]START
	private Node getRootNode(String xmlFilePath) {
		DocumentBuilder documentBuilder;
		
		try {
			//if(rootNode==null) {
				
				documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
				Document document = documentBuilder.parse(xmlFilePath);
				NodeList rootNodeList = document.getChildNodes();
				
		if(rootNodeList.getLength()==1) {
			rootNode = rootNodeList.item(0);
			BaseLogger.log("3",null,null,"Root Node Name [ " + rootNode.getNodeName() + "]");
			setNoOfSheet(rootNode.getChildNodes().getLength());
			BaseLogger.log("3",null,null,"No Of sheet [ " + noOfSheet+ "]");
		}
			//}
		} catch (ParserConfigurationException | SAXException | IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
			return rootNode;
	}
	//Added By Ankush s on 21-Oct-2022 [to get root node from xml document]END
	/**
	 *
	 *
	 * @param excelFilePath
	 * @param request
	 * @throws ITMException
	 */
	private String createExcelColumnMap( String excelFilePath, HttpServletRequest request ) throws ITMException
	{
		//Added By Ravindra C on 25-04-19 to validate matrix template against selected excel file 
		String action = checkNull(request.getParameter("action"));
		String retString = "<Root><Detail>Success</Detail></Root>";
		try
		{
			workbook = getWorkbook( excelFilePath );
			HashMap<Integer, String> excelSheetInfo = uploadBean.getExcelSheetInfo();
			if ( excelSheetInfo == null )
			{
				createExcelSheetInfo(excelFilePath, request);
			}
			//HashMap<Integer, String> excelSheetsInfo = (HashMap<Integer, String>) getSessionAttribute( "excelSheetInfo");
			excelSheetInfo = uploadBean.getExcelSheetInfo();

			int noOfForms = getNoOfForms();
			BaseLogger.log("3",null,null,"noOfForms [ " + noOfForms + "]");
			HashMap<Integer, ArrayList<String>> excelColListMap = new HashMap<Integer, ArrayList<String>>();
			HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = new HashMap<Integer, LinkedHashMap<String, String>>();
			HashMap<Integer, ArrayList<String>> allActualColListMap = new HashMap<Integer, ArrayList<String>>();
			String sheetName = "";
			int sheetNo = 1;
			for ( int tabNo = 0; tabNo < noOfForms; tabNo++ )
			{
				int formNo = tabNo + 1;
				BaseLogger.log("3",null,null,"createExcelColumnMap formNo ["+formNo+"]");

				if ( isNewTemplate() )
				{
					if ( getRequestParamValue( "sheetName"+formNo ).length() > 0 )
					{
						sheetNo = Integer.parseInt( getRequestParamValue( "sheetName"+formNo ) );
					}
					sheetName = checkNull( excelSheetInfo.get( sheetNo ) );
				}
				else
				{
					sheetName = checkNull( TemplateDetails.get( templateKey ).getSheetName( formNo ) );
				}
				BaseLogger.log("3",null,null,"createExcelColumnMap sheetName ["+sheetName+"]");

				if ( sheetName.length() > 0 )
				{
					int headingRowNo = 0, matrixRowNo = -1 ,startMatrixColNo = 0, endMatrixColNo = 0, tempColSpan = 0;
					try
					{
						Sheet sheet = workbook.getSheet( sheetName );
						BaseLogger.log("3",null,null,"createExcelColumnMap sheet ["+sheet+"]");

						if ( sheet == null )
						{
							return genericUtility.getErrorString( "", "INVEXCL", userId );
						}
						BaseLogger.log("3",null,null,"formNo - [" + formNo + "], tabNo - [" + tabNo + "]");
						
						if ( ! isNewTemplate() )
						{
							headingRowNo = TemplateDetails.get( templateKey ).getHeadingRowNo(formNo);
							BaseLogger.log("3",null,null,"headingRowNo - [" + headingRowNo + "]");

							matrixRowNo = TemplateDetails.get( templateKey ).getMatrixRowNo(formNo);
							BaseLogger.log("3",null,null,"matrixRowNo - [" + matrixRowNo + "]");

							startMatrixColNo = TemplateDetails.get(templateKey).getStartMatrixColNo(formNo);
							BaseLogger.log("3",null,null,"startMatrixColNo :[" + startMatrixColNo + "]");
							
							endMatrixColNo = TemplateDetails.get(templateKey).getEndMatrixColNo(formNo);
							BaseLogger.log("3",null,null,"endMatrixColNo :[" + endMatrixColNo + "]");
							
							tempColSpan = TemplateDetails.get( templateKey ).getSheetColSpan(formNo);
							BaseLogger.log("3",null,null,"tempColSpan :["+ tempColSpan +"]");
						}
						else
						{
							if ( getRequestParamValue( "headingRowNo"+formNo ).length() > 0 )
							{
								headingRowNo = Integer.parseInt( getRequestParamValue( "headingRowNo"+formNo ) );
								headingRowNo -= 1;
							}
							if ( getRequestParamValue( "matrixRowNo"+formNo ).length() > 0 )
							{
								matrixRowNo = Integer.parseInt( getRequestParamValue( "matrixRowNo"+formNo ) );
								matrixRowNo -= 1;
							}
							if ( getRequestParamValue( "startMatrixColNo"+formNo ).length() > 0 )
							{
								startMatrixColNo = Integer.parseInt( getRequestParamValue( "startMatrixColNo"+formNo ) );
								startMatrixColNo -= 1;
							}
							if ( getRequestParamValue( "endMatrixColNo"+formNo ).length() > 0 )
							{
								endMatrixColNo = Integer.parseInt( getRequestParamValue( "endMatrixColNo"+formNo ) );
								endMatrixColNo -= 1;
							}
						}
						//Added By Ravindra C on 25-04-19 to validate matrix template against selected excel file - Start
						if ( "GET_HEADER_ROW_COUNT".equals( action ) && matrixRowNo >= 0 ) 
						{
							boolean isCorrectTemplate = checkMatrixTemplate( sheet, matrixRowNo, startMatrixColNo, endMatrixColNo, tempColSpan );
							BaseLogger.log("3",null,null,"isCorrectTemplate :: ["+ isCorrectTemplate +"]");
							if( isCorrectTemplate )
							{
								retString = genericUtility.getErrorString( "", "INVTEMPL", userId );
							}
						}
						//Added By Ravindra C on 25-04-19 to validate matrix template against selected excel file - End
						ArrayList<String> excelColumnList = getExcelColumnList( formNo, sheet, headingRowNo, matrixRowNo );
						BaseLogger.log("3",null,null,"excelColumns[" + excelColumnList + "]");

						excelColListMap.put( formNo, excelColumnList );
					}
					catch (Exception e)
					{
						throw new ITMException(e);
					}
				}

				HashMap<String, String> colListMap = getActualColListMap(objName, formNo);
				BaseLogger.log("3",null,null,"colListMap - [" + colListMap + "]");

				ArrayList<String> actualColList = new ArrayList<String>();
				LinkedHashMap<String, String> actualColMap = new LinkedHashMap<String, String>();
				for ( Map.Entry<String, String> entry : colListMap.entrySet() )
				{
					String codeName = entry.getKey();
					String simpleName = entry.getValue();
					if ( codeName.indexOf('.') != -1 )
					{
						codeName = codeName.substring(codeName.indexOf('.') + 1);
					}
					actualColMap.put(codeName, simpleName);
					actualColList.add(codeName);
				}
				BaseLogger.log("3",null,null,"actualColMap - [" + actualColMap + "]");
				actualColListMap.put(formNo, actualColMap);

				BaseLogger.log("3",null,null,"actualColList - [" + actualColList + "]");
				allActualColListMap.put(formNo, actualColList);
			}
			HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = null;
			HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = null;
			if ( ! isNewTemplate() )
			{
				TemplateDetails.get( templateKey ).setExcelColListMap(excelColListMap);
				TemplateDetails.get( templateKey ).setActualColMap(actualColListMap);
				TemplateDetails.get( templateKey ).setActualColListMap(allActualColListMap);

				defineValueAllMap = TemplateDetails.get( templateKey ).getFormWiseDefineValueAllMap();
				mapLogicValueMap = TemplateDetails.get( templateKey ).getFormWiseMapLogicValue();
			}
			else
			{
				//defineValueAllMap = (HashMap<Integer, HashMap<String, HashMap<String, String>>>)setSessionAttribute( "defineValueAllMap" );
				defineValueAllMap = uploadBean.getAllFormDefineValueMap();
				//mapLogicValueMap = (HashMap<Integer, LinkedHashMap<String, String>>)setSessionAttribute( "mapLogicValueMap" );
				mapLogicValueMap = uploadBean.getMapLogicValueMap();
			}
			//setSessionAttribute( "excelColListMap", excelColListMap );
			uploadBean.setExcelColListMap( excelColListMap );
			//setSessionAttribute( "actualColListMap", actualColListMap );
			uploadBean.setActualColListMap( actualColListMap );
			//setSessionAttribute( "allActualColListMap", allActualColListMap );
			uploadBean.setAllFormActualColListMap( allActualColListMap );
			if ( defineValueAllMap == null )
			{
				defineValueAllMap = new HashMap<Integer, HashMap<String,HashMap<String,String>>>();
			}
			//setSessionAttribute( "defineValueAllMap", defineValueAllMap );
			
			uploadBean.setAllFormDefineValueMap( defineValueAllMap );

			if ( mapLogicValueMap == null )
			{
				mapLogicValueMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			}
			//setSessionAttribute( "mapLogicValueMap", mapLogicValueMap );
			//Added by Ankush S on 23-FEB-2023 [to ensure if it is new template mapLogic value will be empty]  START     
			if(isNewTemplate())
			 {
				BaseLogger.log("3",null,null,"mapLogicValueMap sets empty in new template");
				mapLogicValueMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			}
			//Added by Ankush S on 23-FEB-2023 [to ensure if it is new template mapLogic value will be empty]  END
			uploadBean.setMapLogicValueMap( mapLogicValueMap );
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new ITMException(e);
		}
		//actualColMap = uploadBean.getActualColListMap();
		return retString;
	}
	
	//Added by Ravindra C on 19/01/2021 [to json data mapping implementation] START
	private String createJsonColumnMap( String jsonFilePath, HttpServletRequest request ) throws ITMException, Exception
	{
		String retString = "<Root><Detail>Success</Detail></Root>";

		try
		{
			HashMap<Integer, String> excelSheetInfo = uploadBean.getExcelSheetInfo();
			if ( excelSheetInfo == null )
			{
				createJsonFormDetailsInfo( jsonFilePath );
			}
			excelSheetInfo = uploadBean.getExcelSheetInfo();
			BaseLogger.log( "3", null, null, "excelSheetInfo : ["+ excelSheetInfo +"]" );

			int noOfForms = getNoOfForms();
			BaseLogger.log( "3", null, null, "noOfForms ["+ noOfForms +"]" );
			
			HashMap<Integer, ArrayList<String>> excelColListMap = new HashMap<Integer, ArrayList<String>>();
			HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = new HashMap<Integer, LinkedHashMap<String, String>>();
			HashMap<Integer, ArrayList<String>> allActualColListMap = new HashMap<Integer, ArrayList<String>>();
			String sheetName = "";
			int sheetNo = 1;
			
			for ( int tabNo = 0; tabNo < noOfForms; tabNo++ )
			{
				int formNo = tabNo + 1;
				BaseLogger.log( "3", null, null, "createExcelColumnMap formNo ["+formNo+"]" );

				if ( isNewTemplate() )
				{
					if ( getRequestParamValue( "sheetName"+formNo ).length() > 0 )
					{
						sheetNo = Integer.parseInt( getRequestParamValue( "sheetName"+formNo ) );
					}
					sheetName = checkNull( excelSheetInfo.get( sheetNo ) );
				}
				else
				{
					sheetName = checkNull( TemplateDetails.get( templateKey ).getSheetName( formNo ) );
				}
				BaseLogger.log( "3", null, null, "createExcelColumnMap sheetName ["+sheetName+"]" );

				HashMap<Integer, ArrayList<String>> excelColumnList = getJsonColumnList( jsonFilePath );
				BaseLogger.log( "3", null, null, "excelColumns ["+ excelColumnList +"]" );

				excelColListMap.put( formNo, excelColumnList.get(formNo) );
				BaseLogger.log( "3", null, null, "excelColListMap : ["+ excelColListMap +"]" );

				HashMap<String, String> colListMap = getActualColListMap(objName, formNo);
				BaseLogger.log( "3", null, null, "colListMap : ["+ colListMap +"]" );

				ArrayList<String> actualColList = new ArrayList<String>();
				LinkedHashMap<String, String> actualColMap = new LinkedHashMap<String, String>();
				for ( Map.Entry<String, String> entry : colListMap.entrySet() )
				{
					String codeName = entry.getKey();
					String simpleName = entry.getValue();
					if ( codeName.indexOf('.') != -1 )
					{
						codeName = codeName.substring(codeName.indexOf('.') + 1);
					}
					actualColMap.put(codeName, simpleName);
					actualColList.add(codeName);
				}
				BaseLogger.log( "3", null, null, "actualColMap : ["+ actualColMap +"]" );
				actualColListMap.put(formNo, actualColMap);

				BaseLogger.log( "3", null, null, "actualColList : ["+ actualColList +"]" );
				allActualColListMap.put(formNo, actualColList);
			}
			HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = null;
			HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = null;
			if ( ! isNewTemplate() )
			{
				TemplateDetails.get( templateKey ).setExcelColListMap(excelColListMap);
				TemplateDetails.get( templateKey ).setActualColMap(actualColListMap);
				TemplateDetails.get( templateKey ).setActualColListMap(allActualColListMap);

				defineValueAllMap = TemplateDetails.get( templateKey ).getFormWiseDefineValueAllMap();
				mapLogicValueMap = TemplateDetails.get( templateKey ).getFormWiseMapLogicValue();
			}
			else
			{
				defineValueAllMap = uploadBean.getAllFormDefineValueMap();
				mapLogicValueMap = uploadBean.getMapLogicValueMap();
			}
			uploadBean.setExcelColListMap( excelColListMap );
			uploadBean.setActualColListMap( actualColListMap );
			uploadBean.setAllFormActualColListMap( allActualColListMap );
			if ( defineValueAllMap == null )
			{
				defineValueAllMap = new HashMap<Integer, HashMap<String,HashMap<String,String>>>();
			}
			uploadBean.setAllFormDefineValueMap( defineValueAllMap );

			if ( mapLogicValueMap == null )
			{
				mapLogicValueMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			}
			//Added by Ankush S on 23-FEB-2023 [to ensure if it is new template mapLogic value will be empty]  START     
			if(isNewTemplate())
			 {
				BaseLogger.log("3",null,null,"mapLogicValueMap sets empty in new template");
				mapLogicValueMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			}
			//Added by Ankush S on 23-FEB-2023 [to ensure if it is new template mapLogic value will be empty]  END
			uploadBean.setMapLogicValueMap( mapLogicValueMap );
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new ITMException(e);
		}
		BaseLogger.log( "3", null, null, "In createJsonColumnMap :: retString : ["+ retString +"]");
		return retString;
	}
	//Added by Ravindra C on 19/01/2021 [to json data mapping implementation] END
	
	//Added by Ankush S on 13-Oct-2022 [to xml data mapping implementation]START
	private String createXmlColumnMap(String xmlFilePath,HttpServletRequest request)throws ITMException, Exception {
		String retString = "<Root><Detail>Success</Detail></Root>";
		try {
			HashMap<Integer, String> excelSheetInfo = uploadBean.getExcelSheetInfo();
			if ( excelSheetInfo == null )
			{
				createXmlFormDetailsInfo( xmlFilePath );
			}
			excelSheetInfo = uploadBean.getExcelSheetInfo();
			BaseLogger.log( "3", userInfo, null, "excelSheetInfo : ["+ excelSheetInfo +"]" );
			
			int noOfForms = getNoOfForms();
			BaseLogger.log( "3", null, null, "xml noOfForms ["+ noOfForms +"]" );
			HashMap<Integer, ArrayList<String>> xmlColListMap = new HashMap<Integer, ArrayList<String>>();
			HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = new HashMap<Integer, LinkedHashMap<String, String>>();
			HashMap<Integer, ArrayList<String>> allActualColListMap = new HashMap<Integer, ArrayList<String>>();
			String sheetName = "";
			int sheetNo = 1;
			for ( int tabNo = 0; tabNo < noOfForms; tabNo++ )
			{
				int formNo = tabNo + 1;
				BaseLogger.log( "3", userInfo, null, "createXmlColumnMap formNo ["+formNo+"]" );

				if ( isNewTemplate() )
				{
					if ( getRequestParamValue( "sheetName"+formNo ).length() > 0 )
					{
						sheetNo = Integer.parseInt( getRequestParamValue( "sheetName"+formNo ) );
					}
					sheetName = checkNull( excelSheetInfo.get( sheetNo ) );
				}
				else
				{
					sheetName = checkNull( TemplateDetails.get( templateKey ).getSheetName( formNo ) );
				}
				BaseLogger.log( "3", userInfo, null, "createExcelColumnMap sheetName ["+sheetName+"]" );
				HashMap<Integer, ArrayList<String>> xmlColumnList = getXmlColumnList( xmlFilePath );
				BaseLogger.log( "3", userInfo, null, "xmlColumns ["+ xmlColumnList +"]" );
				
				xmlColListMap.put( formNo, xmlColumnList.get(formNo) );
				BaseLogger.log( "3", userInfo, null, "xmlColListMap : ["+ xmlColListMap +"]" );
				
				BaseLogger.log( "3", userInfo, null, "OBJNAME to get Actual col List : ["+ objName +"]"+"Form No="+formNo );
				HashMap<String, String> colListMap = getActualColListMap(objName, formNo);
				BaseLogger.log( "3", userInfo, null, "actual colListMap : ["+ colListMap +"]" );
				
				ArrayList<String> actualColList = new ArrayList<String>();
				LinkedHashMap<String, String> actualColMap = new LinkedHashMap<String, String>();
				for ( Map.Entry<String, String> entry : colListMap.entrySet() )
				{
					String codeName = entry.getKey();
					String simpleName = entry.getValue();
					if ( codeName.indexOf('.') != -1 )
					{
						codeName = codeName.substring(codeName.indexOf('.') + 1);
					}
					actualColMap.put(codeName, simpleName);
					actualColList.add(codeName);
				}
				BaseLogger.log( "3", userInfo, null, "actualColMap : ["+ actualColMap +"]" );
				actualColListMap.put(formNo, actualColMap);
				
				HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = null;
				HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = null;
				if ( ! isNewTemplate() )
				{
					TemplateDetails.get( templateKey ).setExcelColListMap(xmlColListMap);
					TemplateDetails.get( templateKey ).setActualColMap(actualColListMap);
					TemplateDetails.get( templateKey ).setActualColListMap(allActualColListMap);

					defineValueAllMap = TemplateDetails.get( templateKey ).getFormWiseDefineValueAllMap();
					mapLogicValueMap = TemplateDetails.get( templateKey ).getFormWiseMapLogicValue();
				}
				else
				{
					defineValueAllMap = uploadBean.getAllFormDefineValueMap();
					mapLogicValueMap = uploadBean.getMapLogicValueMap();
				}
				uploadBean.setExcelColListMap( xmlColListMap );
				uploadBean.setActualColListMap( actualColListMap );
				uploadBean.setAllFormActualColListMap( allActualColListMap );
				
				if ( defineValueAllMap == null )
				{
					defineValueAllMap = new HashMap<Integer, HashMap<String,HashMap<String,String>>>();
				}
				System.out.println("DefineValueALLMap="+defineValueAllMap);
				uploadBean.setAllFormDefineValueMap( defineValueAllMap );

				if ( mapLogicValueMap == null )
				{
					mapLogicValueMap = new HashMap<Integer, LinkedHashMap<String,String>>();
				}
				//Added by Ankush S on 23-FEB-2023 [to ensure if it is new template mapLogic value will be empty]  START     
				if(isNewTemplate())
				 {
					BaseLogger.log("3",null,null,"mapLogicValueMap sets empty in new template");
					mapLogicValueMap = new HashMap<Integer, LinkedHashMap<String,String>>();
				}
				//Added by Ankush S on 23-FEB-2023 [to ensure if it is new template mapLogic value will be empty]  END
				uploadBean.setMapLogicValueMap( mapLogicValueMap );
			}
		} catch (IndexOutOfBoundsException e)
		{
			throw new ITMException(e);
		}
		BaseLogger.log( "3", userInfo, null, "In createXmlolumnMap :: retString : ["+ retString +"]");
		return retString;
	}
	//Added by Ankush S on 13-Oct-2022 [to xml data mapping implementation]END
	
	//Added By Ravindra C on 25-04-19 to validate matrix template against selected excel file - Start 
	private boolean checkMatrixTemplate( Sheet sheet, int matrixRowNo, int startMatrixColNum, int endMatrixColNum, int tempColSpan  )
	{
		Range[] range = sheet.getMergedCells();
		int mainRange  = range.length ;
		int noOfColumns = sheet.getColumns();
		BaseLogger.log("3",null,null,"mainRange :[" + mainRange + "]");
		int existingTempDiff =  ( endMatrixColNum + 1 ) - startMatrixColNum;
		if( mainRange == 0 )
		{
			try 
			{
				ArrayList<String > matrixCollist = new ArrayList<String>();
				for( int sigleMatrixNo = startMatrixColNum ; sigleMatrixNo <= endMatrixColNum ; sigleMatrixNo++ )
				{
					String colName = (String) sheet.getCell(sigleMatrixNo, matrixRowNo).getContents();
					matrixCollist.add(colName );
				}
				if( matrixCollist.size() == existingTempDiff )
				{
					return false;
				}
			} 
			catch ( ArrayIndexOutOfBoundsException e ) 
			{
				BaseLogger.log("3",null,null,"checkMatrixTemplate ArrayIndexOutOfBoundsException : ["+ e.getMessage() +"]");
				e.printStackTrace();
				return true;
			}
		}
		if( mainRange > 0 )
		{
			TreeMap<Integer, String> matrixColMap = new TreeMap<Integer, String>();
			int actualStartMatrixColNo = 0;
			int nextStartMatrixColNo = noOfColumns;

			for ( int i = 0; i < range.length ; i++ )
			{
				Cell cell = range[i].getTopLeft();
				if( ( cell.getRow() ) == matrixRowNo )
				{
					matrixColMap.put(cell.getColumn(), cell.getContents());
				}
			}
			int matrixCnt = 0;
			for ( Map.Entry<Integer, String> entry : matrixColMap.entrySet() )
			{
				if ( matrixCnt == 0 )
				{
					actualStartMatrixColNo = entry.getKey();
				}
				else if ( matrixCnt == 1 )
				{
					nextStartMatrixColNo = entry.getKey();
					break;
				}
				matrixCnt++;
			}
			int selectedExcelColSpan = nextStartMatrixColNo - actualStartMatrixColNo;
			BaseLogger.log("3",null,null,"selectedExcelColSpan :[" + selectedExcelColSpan + "]");
			
			if( selectedExcelColSpan != tempColSpan )
			{
				return true;
			}
		}
		return false;
	}
	//Added By Ravindra C on 25-04-19 to validate matrix template against selected excel file - End
	
	/**
	 * To validate template
	 *
	 * @param formNo
	 * @param request
	 * @return
	 * @throws ITMException
	 */
	private String validateTemplate( int formNo, HttpServletRequest request ) throws ITMException
	{
		String retString = "<Root><Detail>Success</Detail></Root>";

		try
		{
			ArrayList<String> excelColList = null;
			HashMap<String, String> targetCol = null;
			if ( isNewTemplate() )
			{
				//HashMap<Integer, ArrayList<String>> excelColListMap = (HashMap<Integer, ArrayList<String>>) getSessionAttribute( "excelColListMap" );
				HashMap<Integer, ArrayList<String>> excelColListMap = uploadBean.getExcelColListMap();
				excelColList = excelColListMap.get( formNo );
			}
			else
			{
				excelColList = TemplateDetails.get(templateKey).getExcelColList(formNo);
				targetCol = TemplateDetails.get(templateKey).getTargetCol(formNo);
			}
			BaseLogger.log("3",null,null,"excelColList - " + excelColList);
			BaseLogger.log("3",null,null,"targetCol - " + targetCol);

			if ( targetCol != null  )
			{
				for ( Map.Entry<String, String> entry : targetCol.entrySet() )
				{
					String excelColName = checkNull( entry.getValue() );
					BaseLogger.log("3",null,null,"excelColName - [" + excelColName + "]");
					if ( excelColName.length() > 0 && excelColList != null && ! excelColList.contains( excelColName ) )
					{
						BaseLogger.log("3",null,null,"Invalid template for - [" + excelColName + "]");
						retString = genericUtility.getErrorString( "", "INVTEMPL", userId );
						break;
					}
				}
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retString;
	}

	/**
	 * Get actual column list
	 *
	 * @param objName
	 * @param tabNo
	 * @return
	 * @throws ITMException
	 */
	private HashMap<String, String> getActualColListMap(String objName, int tabNo) throws ITMException
	{
		HashMap<String, String> targetUpdatableColMap = new LinkedHashMap<String, String>();
		try
		{
			
			HashMap targetColMap = new HashMap();
			String pageContext = "2";
			//Changed by Ajinkya D on 29/11/2017 [for fetching metadata from resource path]
			
			String objContext = Integer.toString(tabNo);
			String editor = "WebEditor";
			HashMap<String, String> propEditorInfoMap = new HashMap<String,String>();
			if ( userInfo != null )
			{
				propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
				propEditorInfoMap.put("ENTERPRISE_ID_RES", "");
				//Added by Sadique on 15/03/2021 [pass userid to apply table properties]
				propEditorInfoMap.put("USER_ID", checkNull(userInfo.getLoginCode()));
			}
			propEditorInfoMap.put("EDITOR", editor);

			String formName = checkNull( TemplateDetails.get( objName ).getFormName( objContext ) );
			BaseLogger.log("3",null,null,"formName - ["+ formName +"]");
			String metadataFilePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, formName, propEditorInfoMap, userInfo.getTransDB());
			BaseLogger.log("3",null,null,"metadataFilePath - ["+metadataFilePath+"]");

			DWObject dw = new DWObject(metadataFilePath, userInfo); //CommonConstants.JBOSSHOME + File.separator + "bin" + File.separator + "metadata"+ File.separator + objName.trim() + pageContext + tabNo + ".xml"

			ArrayList actualColValue = dw.getColumnsList();
			targetColMap = dw.getPhysicalNameDisplayNameMap();
			Hashtable updateColMapTemp = dw.getUpdateableLogPhyColNames();
			BaseLogger.log("3",null,null,"updateColMapTemp === [" + updateColMapTemp + "]");
			Hashtable updateColMap = dw.getNonEditableLogPhyColNames();
			BaseLogger.log("3",null,null,"updateColMap === [" + updateColMap + "]");

			//Changed by Prasad on 04/06/18 [to display metadata column tab order wise]
			HashMap<String, String> tabOrderWiseLogicalNameMap = dw.getTabOrderWiseLogicalNameMap();
			BaseLogger.log("3",null,null, "tabOrderWiseLogicalNameMap ["+ tabOrderWiseLogicalNameMap + "]" );

			ArrayList<String> updatableColList = new ArrayList<String>();
			for( Object keyObject : updateColMap.keySet() )
			{
				updatableColList.add(keyObject.toString().trim());
			}

			/*for( Object updateColName : targetColMap.keySet() )
			{
				if( updatableColList.contains( updateColName.toString().trim() ) )
				{
					targetUpdatableColMap.put("" + updateColName, "" + targetColMap.get(updateColName));
				}
			}*/
			for( Object updateColName : tabOrderWiseLogicalNameMap.keySet() )
			{
				if( updatableColList.contains( updateColName.toString().trim() ) )
				{
					targetUpdatableColMap.put( ""+ updateColName, ""+ tabOrderWiseLogicalNameMap.get( updateColName ) );
				}
			}
			//Changed by Prasad on 04/06/18 [to display metadata column tab order wise] END

			dw.remove();
			dw = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return targetUpdatableColMap;
	}
	//Added by Ankush S. on 07-Dec-2022 [to create sample file  for uploading]START
	private String getSampleFile(String sampleString,String fileFormatType){
			FileWriter fileWriter = null;
			String filePath="";
			BufferedWriter bufferedWriter = null;
			try {
			if("json".equalsIgnoreCase(fileFormatType)) {
				
				//remove attrib from xml string
				DocumentBuilder documentBuilder;
				documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
				Document document = documentBuilder.parse(new ByteArrayInputStream(sampleString.getBytes()));
				NodeList rootNodeList = document.getChildNodes();
				NodeList rootNodeChild = rootNodeList.item(0).getChildNodes();
				BaseLogger.log("3",null,null,"before pasrsing Sample String before=== [" );
				StringBuilder xmlString = new StringBuilder("<ROOT>");
				
				for (int index = 0; index < rootNodeChild.getLength(); index++) {
					Node sheetNode = rootNodeChild.item(index);
					NodeList colNodeList = sheetNode.getChildNodes();
					// iterate column list
					xmlString.append("<"+sheetNode.getNodeName()+">");
					for (int colIndex = 0; colIndex < colNodeList.getLength(); colIndex++) {
						Node colNode = colNodeList.item(colIndex);
						//System.out.println("node name"+colNode.getNodeName());
						xmlString.append("<"+colNode.getNodeName()+">@");
						xmlString.append("</"+colNode.getNodeName()+">");
						
					}
					xmlString.append("</"+sheetNode.getNodeName()+">");
				}
				xmlString.append("</ROOT>");
				BaseLogger.log("3",null,null,"Sample String before=== [" +xmlString.toString() + "]");
				//remove ROW tag before converting xml to json
				sampleString = xmlString.toString();
				BaseLogger.log("3",null,null,"Sample String before=== [" +sampleString + "]");
				//sampleString = sampleString.replaceAll("<ROW>","").replaceAll("</ROW>","");
				//sampleString = sampleString.replaceAll("<ROOT>","").replaceAll("</ROOT>","");
				String jsonData = new XMLtoJSONConverter().xmlToJSONString(sampleString);
				//jsonData = jsonData.replace("{\"ROOT\":", "").replace("}}}}}]", "}}}}}]");
				jsonData = jsonData.replaceAll("@", "").replace("{\"ROOT\":", "");
				jsonData = jsonData.replace(":{", ":[{");
				jsonData = jsonData.replace("\"}", "\"}]");
				jsonData = jsonData.substring(0,jsonData.length()-1);
				BaseLogger.log("3",null,null,"Sample JSON String === [" +jsonData + "]");
				filePath = sampleFilePath.split("\\.")[0]+"_sample.json";
				File file = new File(filePath);
				fileWriter = new FileWriter(file);
				fileWriter.write(jsonData);
				fileWriter.close();			
				BaseLogger.log("3",null,null,"json file written @-["+filePath);
				
			}
			if("xml".equalsIgnoreCase(fileFormatType))
			{
				
				BaseLogger.log("3",null,null,"Sample JSON String === [" +sampleString + "]");
				filePath = sampleFilePath.split("\\.")[0]+"_sample.xml";
				File file = new File(filePath);
				fileWriter = new FileWriter(file);
				fileWriter.write(sampleString);
				fileWriter.close();
				BaseLogger.log("3",null,null,"xml file written @-["+filePath);
			}
			if ("excel".equalsIgnoreCase(fileFormatType)) {
				DocumentBuilder documentBuilder;
				WritableWorkbook workbook = null;
				try {
					filePath = sampleFilePath.split("\\.")[0] + "_sample.xls";
					BaseLogger.log("3",null,null,"Sample xcel file path === [" +filePath + "]");
					workbook = Workbook.createWorkbook(new File(filePath));
					documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
					Document document = documentBuilder.parse(new ByteArrayInputStream(sampleString.getBytes()));
					
					NodeList rootNodeList = document.getChildNodes();
					NodeList rootNodeChild = rootNodeList.item(0).getChildNodes();

					for (int index = 0; index < rootNodeChild.getLength(); index++) {
						// get screen name from list
						Node sheetNode = rootNodeChild.item(index);
						
						// create sheet
						WritableSheet excelSheet = workbook.createSheet(rootNodeChild.item(index).getNodeName(), 0);
						// get ROW node
						Node rowNode = sheetNode.getChildNodes().item(0);
					    
						// create row in sheet
						// HSSFRow rowhead = sheet.createRow((short)0);
						// get actual column list from ROW node
						//NodeList colNodeList = rowNode.getChildNodes();//if contains <ROW>Tag
						NodeList colNodeList = sheetNode.getChildNodes();
						// iterate column list
						for (int colIndex = 0; colIndex < colNodeList.getLength(); colIndex++) {
							// get column name
							Node colNode = colNodeList.item(colIndex);
							
							// create cell as per column
							Label label = new Label(colIndex, 0, colNode.getNodeName());
							excelSheet.addCell(label);
						}
					}
					workbook.write();
					BaseLogger.log("3", null, null, "Excel file  generated");
				} catch (ParserConfigurationException | SAXException | IOException e) {
					e.printStackTrace();
					BaseLogger.log("3", null, null, "Error in creating Excel file[" + e.getMessage() + "]");
				} finally {
					if (workbook != null) {
						try {
							workbook.close();
						} catch (IOException e) {
							e.printStackTrace();
						} catch (WriteException e) {
							e.printStackTrace();
						}
					}
				}

			}

		} catch (Exception e) {
			BaseLogger.log("3", null, null, "Error in creating file[" + e.getMessage() + "]");
			e.printStackTrace();

		}

		return filePath;
	}
	//Added by Ankush S. on 07-Dec-2022 [to create sample file  for uploading]END
	//Added by Ankush S. on 07-Dec-2022 [to get sample file data for uploading]START
	private String getSampleString(String objName,int tabNo) {
		String sampleString ="" ;
		try {
			//StringBuilder xmlString = new StringBuilder("<ROW>");
			StringBuilder xmlString = new StringBuilder();
			
			String pageContext = "2";
			String objContext = String.valueOf(tabNo);
			String editor = "WebEditor";
			Map<String,String>colNames = getActualColListMap(objName,tabNo);
			HashMap<String, String> propEditorInfoMap = new HashMap<String,String>();
			if ( userInfo != null )
			{
				propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
				propEditorInfoMap.put("ENTERPRISE_ID_RES", "");
				propEditorInfoMap.put("USER_ID", checkNull(userInfo.getLoginCode()));
			}
			propEditorInfoMap.put("EDITOR", editor);
			String formName = checkNull( TemplateDetails.get( objName ).getFormName( objContext ) );
			
			String metadataFilePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, formName, propEditorInfoMap, userInfo.getTransDB());
			BaseLogger.log("3",null,null,"metadataFilePath === [" +metadataFilePath + "]");
			
			DocumentBuilder documentBuilder;

			documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document document = documentBuilder.parse(metadataFilePath);
			Node rNode = document.getFirstChild();
			BaseLogger.log("3", null, null, "Sample Root Node Name [ " + rNode.getNodeName() + "]");
			NodeList tableNodeList = document.getElementsByTagName("TableDefinition");
			
			NodeList tableNodeChildList = tableNodeList.item(0).getChildNodes();
			BaseLogger.log("3", null, null, "Sample table child Node list length= [ " + tableNodeChildList.getLength() + "]");
			for(int index=0;index<tableNodeChildList.getLength();index++) {
				Node node = tableNodeChildList.item(index);
				
				if(node.getNodeName().equalsIgnoreCase("table_column")) {
					BaseLogger.log("3", null, null, "Node name=["+node.getNodeName());
					
					NodeList dataList = node.getChildNodes();
					BaseLogger.log("3", null, null, "data Node list size=["+dataList.getLength());
					String colName="";
					String label="";
					String dataType="";
					String attribute="";
					String isNull="";
					
					for(int dataIndex=0;dataIndex<dataList.getLength();dataIndex++) {
						
						if(!dataList.item(dataIndex).getNodeName().contains("#")) {
							Node data = dataList.item(dataIndex);
							
							if(data.getNodeName().equalsIgnoreCase("name")) {
								colName=data.getFirstChild().getTextContent();
								label =checkNull( colNames.get(colName));
								BaseLogger.log("3", null, null, "data Node label=["+label);
							}
							if (data.getNodeName().equalsIgnoreCase("type")) {
								dataType = data.getFirstChild().getTextContent();
								
								if (data.getAttributes().getLength() > 0) {
								
									NamedNodeMap attributes = data.getAttributes();
									for (int attrIndex = 0; attrIndex < attributes.getLength(); attrIndex++) {
										attribute = attribute + attributes.item(attrIndex).getNodeName() + "='"
												+ attributes.item(attrIndex).getNodeValue() + "' ";
									}
								}
							}
							
						}
					}
					//Ignore add_user, add_term, add_date, chg_user, chg_date,chg_term fields
					switch(colName) {
					case "add_user":break;
					case "add_term":break;
					case "add_date":break;
					case "chg_user":break;
					case "chg_date":break;
					case "chg_term":break;
					default:xmlString.append("<"+colName+" label='"+label+"' dataType='"+dataType+"' "+attribute+"></"+colName+">");
					break;
					}
				}
			}
			//xmlString.append("</ROW>");
			sampleString = xmlString.toString();
			BaseLogger.log("3", null, null,"created xmlString=["+xmlString.toString());
		} catch (Exception e) {
			BaseLogger.log("3", null, null, "Exception reading sample=[ " + e.getMessage() + "]");
		}
		return sampleString;
	}
	//Added by Ankush S. on 07-Dec-2022 [to get sample file data for uploading]END
	private Object getSessionAttribute( String attribute )
	{
		Object sessionVal = null;
		if ( session.getAttribute( attribute ) != null )
		{
			sessionVal = session.getAttribute(attribute);
		}
		return sessionVal;
	}

	/*private void setSessionAttribute( String attribute, Object attributeVal )
	{
		session.setAttribute(attribute, attributeVal);
	}

	private void sessionRemoveAttribute( String attribute )
	{
		session.removeAttribute(attribute);
	}*/

	private ArrayList<String> getExcelColumnList( int formNo, Sheet sheet, int headingRowNo, int matrixRowNo ) throws ITMException
	{
		ArrayList<String> excelColList = new ArrayList<String>();
		try
		{
			int noOfColumns = sheet.getColumns();

			//int headingRowNo = TemplateDetails.get(templateKey).getHeadingRowNo(formNo);
			BaseLogger.log("3",null,null,"headingRowNo - [" + headingRowNo + "]");
			//int matrixRowNo = TemplateDetails.get(templateKey).getMatrixRowNo(formNo);
			BaseLogger.log("3",null,null,"matrixRowNo - [" + matrixRowNo + "]");

			if ( matrixRowNo >= 0  )
			{
				excelColList.add("MatrixColumn");
			}

			for ( int i = 0; i < noOfColumns; i++ )
			{
				String colName = (String) sheet.getCell(i, headingRowNo).getContents();
				colName = checkNull(colName);
				if ( colName.length() > 0 )
				{
					colName = colName.replaceAll(" ", "_");
					if ( ! excelColList.contains( colName ) )
					{
						excelColList.add(colName);
					}
				}
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return excelColList;
	}
	
	//Added by Ravindra C on 19/01/2021 [to json data mapping implementation] START
	private HashMap<Integer, ArrayList<String>> getJsonColumnList( String jsonFilePath ) throws Exception
	{
		String jsonString = genericUtility.readFile( jsonFilePath );
		HashMap<Integer, ArrayList<String>> getFormColMap = (new JSONtoXMLConverter()).getFormColNameInfoMap(jsonString);
		return getFormColMap;
	}
	//Added by Ravindra C on 19/01/2021 [to json data mapping implementation] END
	//Added By Ankush S. on 14-Oct-2022 [to get column map of xml file]START
	private HashMap<Integer, ArrayList<String>> getXmlColumnList( String xmlFilePath ) throws Exception
	{
		
		HashMap<Integer, ArrayList<String>> getFormColMap = new HashMap<Integer, ArrayList<String>>();
		ArrayList<String>colNameList = null;
		//get column Names from xml file
		DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		Document document = documentBuilder.parse(xmlFilePath);
		NodeList rootNodeList = document.getChildNodes();
		Node rootNode = null;
		NodeList rootNodeChildList= null;
		
		if(rootNodeList.getLength()==1) {
			rootNode = rootNodeList.item(0);
			BaseLogger.log("3",userInfo,null,"RootNode name="+rootNode.getNodeName());
			rootNodeChildList = rootNode.getChildNodes();
			int index=1;
			for(int i=0;i<rootNodeChildList.getLength();i++) {
				Node childNode = rootNodeChildList.item(i);					
				if(!childNode.getNodeName().contains("#"))//for ignoring whitespace node
					{	
					BaseLogger.log("3",userInfo,null,"detail name="+childNode.getNodeName());
					NodeList childNodeList = childNode.getChildNodes();
					colNameList = new ArrayList<String>();
					for(int j=0;j<childNodeList.getLength();j++) {
						
						Node node = childNodeList.item(j);
						
						if(!node.getNodeName().contains("#"))//for ignoring whitespace node
						{
							BaseLogger.log("3",userInfo,null,"detail child node name="+node.getNodeName());
							colNameList.add(node.getNodeName());
							/*NodeList chilNodeChildList = node.getChildNodes();
							if(chilNodeChildList!=null && chilNodeChildList.getLength()>0) {
								//colNameList = new ArrayList<String>();
								
								for(int k=0;k<chilNodeChildList.getLength();k++) {
									Node dataNode = chilNodeChildList.item(k);
									if(!chilNodeChildList.item(k).getNodeName().contains("#")) {
									
									//colNameList.add(chilNodeChildList.item(k).getNodeName());
									}
								}
							}else {
								colNameList.add(node.getNodeName());
							}*/
						}
					}
					BaseLogger.log("3",userInfo,null,"Col Name list=="+colNameList);
					getFormColMap.put(index,colNameList);
					index++;
				}
			}
		}
		return getFormColMap;
	}
	//Added By Ankush S. on 14-Oct-2022 [to get column map of xml file]END
	private int getNoOfForms()
	{
		int noOfForms = 1;
		try
		{
			//TreeMap<Integer, String> formDetailInfo = (TreeMap) getSessionAttribute("formDetailInfo");
			TreeMap<Integer, String> formDetailInfo = uploadBean.getFormDetailInfo();
			noOfForms = formDetailInfo.size();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return noOfForms;
	}

	/**
	 * Check metadata is exist or not
	 *
	 * @param objName
	 * @return
	 */
	/*boolean isMetadataExist = false;
	private final boolean isMetadataExist( final String objName )
	{
		try
		{
			String filePath = CommonConstants.JBOSSHOME + File.separator + "bin" + File.separator + "metadata" + File.separator + objName + "21.xml";
			File fileObj = new File(filePath);
			if ( fileObj.exists() )
			{
				isMetadataExist = true;
			}
		}
		catch( Exception e )
		{
			isMetadataExist = false;
			e.printStackTrace();
		}
		BaseLogger.log("3",null,null,"isMetadataExist - [" + isMetadataExist + "]");
		return isMetadataExist;
	}*/

	/**
	 *
	 * @return
	 * @throws ITMException
	 */
	private String getUploadRowCount( String tempName, String fileType, UserInfoBean userInfo, HttpServletRequest request, HttpServletResponse response, String templateKey, String action ) throws ITMException
	{
		String uploadRowCount = "0";
		try
		{
			if ( ! isNewTemplate() )
			{
				int noOfSheet = getNoOfSheet();
				int sheetRowCnt = 0;
				if ( noOfSheet > 0 )
				{
					String sheetName = checkNull( TemplateDetails.get( templateKey ).getSheetName( 1 ) );
					Sheet sheet = sheetName.length() > 0 ? workbook.getSheet( sheetName ) : workbook.getSheet( 0 );
					sheetRowCnt = sheet.getRows();
				}

				int startsFrom = TemplateDetails.get( templateKey ).getDataStartsFrom( 1 );
				int uploadRowCnt = ( sheetRowCnt - startsFrom );
				uploadRowCnt = uploadRowCnt < 0 ? 0 : uploadRowCnt;
				uploadRowCount = ""+ uploadRowCnt;
				//uploadRowCount = applyTemplate( tempName, fileType, userInfo, request, response, templateKey, action );
			}
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new ITMException(e);
		}
		return uploadRowCount;
	}

	//private String applyTemplate( String tempName, String fileType, UserInfoBean userInfo, HttpServletRequest request, HttpServletResponse response ) throws ITMException
	//Changed By Ravindra C on 08-09-18 for download error file
	//private String applyTemplate( String tempName, String fileType, UserInfoBean userInfo, HttpServletRequest request, HttpServletResponse response, String templateKey, String action ) throws ITMException
	private String applyTemplate( 
			String tempName, String fileType, UserInfoBean userInfo, HttpServletRequest request, HttpServletResponse response, String templateKey,
			String action, String sessionId ) throws ITMException
	{
		String responseStr = "";
		try
		{
			BaseLogger.log("3",userInfo,null,"--------------File Type : [" + fileType + "]");

			String filePath = uploadBean.getFilePath();
			
			BaseLogger.log("3",userInfo,null,"--------------excelFilePath : [" + filePath + "]");

			
			TemplateDetails tempdetails = TemplateDetails.get(objName);
			BaseLogger.log("3",userInfo,null,"--------------Temp. tempdetails template map size : [" + tempdetails.getTemplateMap().size() + "]");
			
			
			String tempXml = tempdetails.getTemplateXml(tempName);
			
			System.out.println("tempName value in Map====>"+tempdetails.getTemplateMap().get(tempName));
			if("xml".equalsIgnoreCase(fileType)) {
				
			}
			BaseLogger.log("3",userInfo,null,"--------------Temp. tempXml : [" + tempXml + "]");
			
			String tempString = TemplateDetails.get(objName).getTemplateXml(tempName);
			BaseLogger.log("3",userInfo,null,"--------------Temp. Name : [" + tempName + "]");
			BaseLogger.log("3",userInfo,null,"--------------Temp. objName : [" + objName + "]");
			BaseLogger.log("3",userInfo,null,"--------------Temp. String : [" + tempString + "]");

			ArrayList<Integer> sheetsUsed = TemplateDetails.get(objName).getTotalRowsInTemplate(tempName);
			BaseLogger.log("3",userInfo,null,"--------------totalRowsInTemp : [" + sheetsUsed + "]");

			HashMap<Integer, HashMap<String, HashMap<String,String>>> sheetMapDetailMap = TemplateDetails.get( templateKey ).getSheetMapDetailMap();
			BaseLogger.log("3",userInfo,null,"Sheet Detail Map : " + sheetMapDetailMap);

			HashMap<Integer, LinkedHashMap<String, String>> sheetSrcTargetColumnMap = TemplateDetails.get( templateKey ).getFormWiseTargetCol();
			BaseLogger.log("3",userInfo,null,"sheet Src Target Column Map : " + sheetSrcTargetColumnMap);

			HashMap<Integer, LinkedHashMap<String, String>> sheetMappingLogicMap = TemplateDetails.get( templateKey ).getFormWiseMapLogicData();
			BaseLogger.log("3",userInfo,null,"sheet Mapping Logic Map : " + sheetMappingLogicMap);

			LinkedHashMap<String, String> dataMap = null;
			if ( ("excel").equalsIgnoreCase( fileType ) )
			{
				dataMap = buildExcelData( filePath, userInfo, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, sheetsUsed, templateKey );
			}
			else if ( ("xml").equalsIgnoreCase( fileType ) )
			{
				//Added By Ravindra C on 25-06-18 for xml file Upload.
				dataMap = buildXmlData( filePath );
			}
			else if ( ("csv").equalsIgnoreCase( fileType ) )
			{

			}
			BaseLogger.log("3",userInfo,null,"dataMap : "+ dataMap +"]");
			//Added By Ravindra C on 20-06-18 for upload Utility - Start
			if ( dataMap != null )
			{
				if ( ! dataMap.containsKey( "INPUT_DATA_ERR" ) )
				{
					//Changed By Ravindra C on 08-09-18 for download error file
					//responseStr = createBatchLoadNProcess( objName, userInfo, request, response, filePath, templateKey, dataMap, fileType );
					responseStr = createBatchLoadNProcess( objName, userInfo, request, response, filePath, templateKey, dataMap, fileType, tempName, sessionId );
				}
				else
				{
					responseStr = dataMap.get( "INPUT_DATA_ERR" );
				}
			}
			//Added By Ravindra C on 20-06-18 for upload Utility - End
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return responseStr;
	}

	/**
	 *
	 * @param excelFilePath
	 * @param userInfo
	 * @param sheetMapDetailMap
	 * @param sheetSrcTargetColumnMap
	 * @param sheetMappingLogicMap
	 * @param sheetsUsed
	 * @param templateKey
	 * @return
	 * @throws ITMException
	 */
	private LinkedHashMap<String, String> buildExcelData( String excelFilePath, UserInfoBean userInfo,
			HashMap<Integer, HashMap<String, HashMap<String, String>>> sheetMapDetailMap,
			HashMap<Integer, LinkedHashMap<String, String>> sheetSrcTargetColumnMap,
			HashMap<Integer, LinkedHashMap<String, String>> sheetMappingLogicMap,
			ArrayList<Integer> sheetsUsed, String templateKey ) throws ITMException
	{
		LinkedHashMap<String, String> detailDataMap = new LinkedHashMap<String, String>();
		LinkedHashMap<String, Integer> detailDomIdMap = new LinkedHashMap<String, Integer>();
		//added by Ravindra C on 01-02-19 to write matrix error file - Start
		HashMap<String, Integer> matrixSheetColSpanMap = new  HashMap<String, Integer>();
		
		try
		{
			Sheet sheet = null;
			String sheetName = "";
			ArrayList<String> parentPkNameList = TemplateDetails.get( objName ).getPKFieldNameList( "1" );
			if ( parentPkNameList == null )
			{
				detailDataMap.put( "INPUT_DATA_ERR", genericUtility.getErrorString( "", "INVTRANID", userId ) );
				return detailDataMap;
			}
			workbook = getWorkbook(excelFilePath);

			for ( int n = 0; n < sheetsUsed.size(); n++ )
			{
				int tabNo = sheetsUsed.get(n);
				ArrayList<String> pkNameList = TemplateDetails.get( objName ).getPKFieldNameList( ""+ tabNo );
				if ( pkNameList == null )
				{
					detailDataMap.put( "INPUT_DATA_ERR", genericUtility.getErrorString( "", "INVTRANID", userId ) );
					return detailDataMap;
				}
				int detailDomId = 1;

				sheetName = TemplateDetails.get(templateKey).getSheetName(tabNo);
				if ( sheetName.length() == 0 )
				{
					continue;
				}
				sheet = workbook.getSheet(sheetName);
				if ( sheet == null )
				{
					continue;
				}
				int noOfColumns = sheet.getColumns();
				int noOfRows = sheet.getRows();

				int headingRowNo = TemplateDetails.get(templateKey).getHeadingRowNo(tabNo);
				int matrixRowNo = TemplateDetails.get(templateKey).getMatrixRowNo(tabNo);
				int startMatrixColNo = TemplateDetails.get(templateKey).getStartMatrixColNo(tabNo);
				int endMatrixColNo = TemplateDetails.get(templateKey).getEndMatrixColNo(tabNo);
				if ( endMatrixColNo == -1 )
				{
					endMatrixColNo = noOfColumns;
				}
				int startsFrom = TemplateDetails.get(templateKey).getDataStartsFrom(tabNo);

				BaseLogger.log("3",userInfo,null,"headingRowNo [" + headingRowNo + "]");
				BaseLogger.log("3",userInfo,null,"matrixRowNo [" + matrixRowNo + "]");
				BaseLogger.log("3",userInfo,null,"startMatrixColNo [" + startMatrixColNo + "]");
				BaseLogger.log("3",userInfo,null,"endMatrixColNo [" + endMatrixColNo + "]");
				BaseLogger.log("3",userInfo,null,"startsFrom [" + startsFrom + "], noOfRows [" + noOfRows + "]");

				if ( headingRowNo > noOfRows )
				{
					detailDataMap.put( "INPUT_DATA_ERR", genericUtility.getErrorString( "", "INVEXHDR", userId ) );
					return detailDataMap;
				}
				else if ( startsFrom == -1 || startsFrom > noOfRows )
				{
					detailDataMap.put( "INPUT_DATA_ERR", genericUtility.getErrorString( "", "INVDSF", userId ) );
					return detailDataMap;
				}

				ArrayList<String> actualColList = TemplateDetails.get(templateKey).getActualColList(tabNo);
				if ( actualColList == null )
				{
					actualColList = new ArrayList<String>();
				}
				HashMap<String, String> dbColLogNameTypeMap = TemplateDetails.get( objName ).getColumnTypeDB( ""+ tabNo ); 
				
				//Added By Ravindra C on 20-07-2020 for data and datetime validation through metadata file - Start
				HashMap<String, String> metaDataColLogNameTypeMap = TemplateDetails.get( objName ).getColumnTypeMetaDeta( ""+ tabNo );
				
				HashMap<String, Integer> colLogNameSizeMap = TemplateDetails.get( objName ).getColumnSize( ""+ tabNo );
				
				//added By Ravindra on 20-11-18 for upper case data value 
				HashMap<String, String> fieldCaseValueMap = TemplateDetails.get( objName ).getFieldCase( ""+ tabNo );

				//added By Ravindra C on 08-09-18 for dropDown item data list
				HashMap<String, HashMap<String, String>> dropDownColValueMap = TemplateDetails.get( objName ).getDropDownColValueMap( ""+ tabNo );
				
				//Added By Ravindra C on 13-12-18 for field value precision realted data.
				HashMap<String, Integer> colLogNamePrecisionMap = TemplateDetails.get( objName ).getColumnPrecision( ""+ tabNo );
				
				for ( int rowNo = startsFrom; rowNo < noOfRows; rowNo++ )
				{
					if ( ! validateCell( sheet, rowNo, noOfColumns ) )
					{
						break;
					}
					String rowData = "";
					LinkedHashMap<String, String> dataMap = null;
					
					//added By Ravindra c on 22-10-18 - [to ignore matrix row if there is every cell value ignore ] 
					int colSpan = 0;
					if ( matrixRowNo >= 0 )
					{
						//Added By Ravindra C on 07-08-19 for header matrix sheet with single primary key - Start
						if( parentPkNameList.size() == 1 )
						{
							HashMap<String,String> parentPkNameMap = sheetSrcTargetColumnMap.get(1);
							String parentPkName = getTempPKVal( parentPkNameMap );
							parentPkNameList.add( parentPkName );
							parentPkNameList.add("Y");
						}
						if( pkNameList.size() == 1 )
						{
							HashMap<String,String> pkNameMap = sheetSrcTargetColumnMap.get(tabNo);
							String tempPkVal = getTempPKVal( pkNameMap );
							pkNameList.add(tempPkVal);
							pkNameList.add("Y");
						}
						//Added By Ravindra C on 07-08-19 for header matrix sheet with single primary key - End
						//changed By RAvindra C on 12-03-18 for single matrix upload 
						//HashMap<String, Object> matrixDetailMap = getMatrixDetailMap(sheet, matrixRowNo);
						HashMap<String, Object> matrixDetailMap = getMatrixDetailMap(sheet, matrixRowNo, startMatrixColNo, endMatrixColNo  );
						BaseLogger.log("3",userInfo,null,"matrixDetailMap ["+matrixDetailMap+"]");
						TreeMap<Integer, String> matrixColMap = (TreeMap<Integer, String>) matrixDetailMap.get("MATRIX_COL_MAP");
						BaseLogger.log("3",userInfo,null,"matrixColMap [" + matrixColMap + "]");

						colSpan = (Integer) matrixDetailMap.get("COLSPAN");
						//added by Ravindra C on 01-02-19 to write matrix error file - Start
						matrixSheetColSpanMap.put( sheetName, colSpan ); 
						//added by Ravindra C on 01-02-19 to write matrix error file - End
						
						BaseLogger.log("3",userInfo,null,"colSpan - [" + colSpan + "]");
						for ( Map.Entry<Integer, String> matrixEntry : matrixColMap.entrySet() )
						{
							int matrixStartFrom = matrixEntry.getKey();
							String matrixContentVal = matrixEntry.getValue();
							BaseLogger.log("3",userInfo,null,"matrixContentVal - [" + matrixContentVal + "]");

							ArrayList<Integer> matrixColList = getMatrixColList(noOfColumns, startMatrixColNo, endMatrixColNo, matrixStartFrom, colSpan);
							BaseLogger.log("3",userInfo,null,"columnList = " + matrixColList);
							//added By Ravindra on 20-11-18 for upper case data value
							//dataMap = buildDetailDataMap(sheet, tabNo, rowNo, actualColList, matrixColList, matrixContentVal, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, pkNameList, colLogNameTypeMap, colLogNameSizeMap, parentPkNameList, dropDownColValueMap);
							
							//added By Ravindra c on 22-10-18 - [to ignore matrix row if there is every cell value ignore and to check field precision ] 
							//dataMap = buildDetailDataMap(sheet, tabNo, rowNo, actualColList, matrixColList, matrixContentVal, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, pkNameList, colLogNameTypeMap, colLogNameSizeMap, parentPkNameList, dropDownColValueMap, fieldCaseValueMap );
							dataMap = buildDetailDataMap( sheet, tabNo, rowNo, actualColList, matrixColList, matrixContentVal, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, pkNameList, metaDataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, parentPkNameList, dropDownColValueMap, fieldCaseValueMap, colLogNamePrecisionMap, colSpan );
							//Added by Prasad on 18/09/18 [to resolve matrix upload issue, upload only last record] START
							if ( dataMap != null )
							{
								if ( dataMap.containsKey( "INPUT_DATA_ERR" ) )
								{
									detailDataMap.put( "INPUT_DATA_ERR", genericUtility.getErrorString( "", dataMap.get( "INPUT_DATA_ERR" ), "Invalid data!", "" ) );
									return detailDataMap;
								}

								String[] pkDetails = getPkDetails( dataMap, pkNameList, parentPkNameList );
								String pkName = pkDetails[0];
								String pkValue = pkDetails[1];
								String parentPkValue = pkDetails[2];
								
								//Added By Ravindra C on 07-08-19 for header matrix sheet with single primary key - Start
								if( pkNameList.contains("Y") )
								{
									 String array1[]= pkName.split("\\:");
									 pkName = array1[0];
								}
								if( parentPkNameList.contains("Y") )
								{
									 String array2[]= pkValue.split("\\:");
									 pkValue = array2[0];
								}
								//Added By Ravindra C on 07-08-19 for header matrix sheet with single primary key - End
								
								String detailPkValue = parentPkValue + "~" + tabNo;
								BaseLogger.log("3",userInfo,null,"detailPkValue ["+ detailPkValue +"]");

								if( detailDomIdMap.containsKey( detailPkValue ) )
								{
									detailDomId = detailDomIdMap.get(detailPkValue);
									detailDomId = detailDomId + 1;
								}
								else
								{
									detailDomId = 1;
								}
								detailDomIdMap.put( detailPkValue, detailDomId );

								rowData = buildDetailData( dataMap, tabNo, pkValue, detailDomId, pkName );
								if( tabNo == 1 )
								{
									detailDataMap.put(parentPkValue, rowData);
								}
								else
								{
									if( detailDataMap.containsKey( parentPkValue ) )
									{
										StringBuffer dataBuff = new StringBuffer();
										String existingData = detailDataMap.get( parentPkValue );
										dataBuff.append( existingData ).append( rowData );
										detailDataMap.put( parentPkValue, dataBuff.toString() );
									}
								}
							}
							//Added by Prasad on 18/09/18 [to resolve matrix upload issue, upload only last record] END
						}
					}
					else
					{
						//added By Ravindra on 20-11-18 for upper case data value
						//dataMap = buildDetailDataMap(sheet, tabNo, rowNo, actualColList, null, null, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, pkNameList, colLogNameTypeMap, colLogNameSizeMap, parentPkNameList, dropDownColValueMap);
						//added By Ravindra c on 22-10-18 - [to ignore matrix row if there is every cell value ignore and to check field precision ]
						//dataMap = buildDetailDataMap(sheet, tabNo, rowNo, actualColList, null, null, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, pkNameList, colLogNameTypeMap, colLogNameSizeMap, parentPkNameList, dropDownColValueMap, fieldCaseValueMap);
						dataMap = buildDetailDataMap( sheet, tabNo, rowNo, actualColList, null, null, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, pkNameList, metaDataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, parentPkNameList, dropDownColValueMap, fieldCaseValueMap, colLogNamePrecisionMap, colSpan );
						//Added by Prasad on 18/09/18 [to resolve matrix upload issue, upload only last record] START
						if ( dataMap != null )
						{
							if ( dataMap.containsKey( "INPUT_DATA_ERR" ) )
							{
								detailDataMap.put( "INPUT_DATA_ERR", genericUtility.getErrorString( "", dataMap.get( "INPUT_DATA_ERR" ), "Invalid data!", "" ) );
								return detailDataMap;
							}

							String[] pkDetails = getPkDetails( dataMap, pkNameList, parentPkNameList );
							String pkName = pkDetails[0];
							String pkValue = pkDetails[1];
							String parentPkValue = pkDetails[2];

							String detailPkValue = parentPkValue + "~" + tabNo;
							BaseLogger.log("3",userInfo,null,"detailPkValue ["+ detailPkValue +"]");

							if( detailDomIdMap.containsKey( detailPkValue ) )
							{
								detailDomId = detailDomIdMap.get(detailPkValue);
								detailDomId = detailDomId + 1;
							}
							else
							{
								detailDomId = 1;
							}
							detailDomIdMap.put( detailPkValue, detailDomId );

							rowData = buildDetailData( dataMap, tabNo, pkValue, detailDomId, pkName );
							if( tabNo == 1 )
							{
								detailDataMap.put(parentPkValue, rowData);
							}
							else
							{
								if( detailDataMap.containsKey( parentPkValue ) )
								{
									StringBuffer dataBuff = new StringBuffer();
									String existingData = detailDataMap.get( parentPkValue );
									dataBuff.append( existingData ).append( rowData );
									detailDataMap.put( parentPkValue, dataBuff.toString() );
								}
								else
								{
									//Added By Ravindra C on 07-08-19 for header matrix sheet with single primary key - Start
									for ( Entry<String, String> entry : detailDataMap.entrySet() ) 
									{
										String headerParentKey = entry.getKey();
										BaseLogger.log("3",userInfo,null,"headerParentKey :: ==> ["+ headerParentKey +"]");  

										String array3[]= headerParentKey.split("\\:");
										String tempPkVal = array3[0];
										BaseLogger.log("3",userInfo,null,"tempPkVal : ["+ tempPkVal +"]");

										if( tempPkVal.equals( parentPkValue) )
										{  
											StringBuffer dataBuff = new StringBuffer();
											String existingData = detailDataMap.get( headerParentKey );
											dataBuff.append( existingData ).append( rowData );
											detailDataMap.put( headerParentKey, dataBuff.toString() );
										}
									}
								}
								//Added By Ravindra C on 07-08-19 for header matrix sheet with single primary key - End
							}
						}
						//Added by Prasad on 18/09/18 [to resolve matrix upload issue, upload only last record] END
					}
				}
				BaseLogger.log("3",userInfo,null,"matrixSheetColSpanMap ::- [" + matrixSheetColSpanMap + "]");
				TemplateDetails.get( templateKey ).setMatrixColSpanMap( matrixSheetColSpanMap );
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return detailDataMap;
	}

	/**
	 * to check blank row in sheet
	 *
	 * @param sheet
	 * @param rowNo
	 * @param noOfCols
	 * @return
	 */
	private boolean validateCell( Sheet sheet, int rowNo, int noOfCols )
	{
		boolean isValid = true;
		try
		{
			String columnData = "";
			for ( int k = 0; k < noOfCols; k++ )
			{
				columnData += checkNull((String) sheet.getCell(k, rowNo).getContents());
			}
			if ( columnData.length() == 0 || "END_OF_FILE".equalsIgnoreCase( columnData ) )
			{
				isValid = false;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return isValid;
	}
	//changed By Ravindra C on 12-03-19 for the single matrix upload. 
	//private HashMap<String, Object> getMatrixDetailMap( Sheet sheet, int matrixRowNo, int startMatrixColNum, int endMatrixColNum  ) throws ITMException
	private HashMap<String, Object> getMatrixDetailMap( Sheet sheet, int matrixRowNo, int startMatrixColNum, int endMatrixColNum  ) throws ITMException
	{
		HashMap<String, Object> matrixDetailMap = new HashMap<String, Object>();
		try
		{
			int noOfColumns = sheet.getColumns();
			int actualStartMatrixColNo = 0;
			int nextStartMatrixColNo = noOfColumns;
			Range[] range = sheet.getMergedCells();
			BaseLogger.log("3",null,null,"sheet.getMergedCells() [" + range.length + "]");
			TreeMap<Integer, String> matrixColMap = new TreeMap<Integer, String>();
			//added By Ravindra C on 12-03-19 for the single matrix upload. - Start
			if( range.length  == 0 )
			{
				for( int sigleMatrixNo = startMatrixColNum ; sigleMatrixNo <= endMatrixColNum ; sigleMatrixNo++ )
				{
					String colName = (String) sheet.getCell(sigleMatrixNo, matrixRowNo).getContents();
					matrixColMap.put( sigleMatrixNo , colName );
				}
				BaseLogger.log("3",null,null,"matrixColMap  - [" + matrixColMap + "]");
			}
			else
				//added By Ravindra C on 12-03-19 for the single matrix upload. - End
			{
				for ( int i = 0; i < range.length ; i++ )
				{
					BaseLogger.log("3",null,null,"i - [" + i + "]");
					Cell cell = range[i].getTopLeft();
					if( ( cell.getRow() ) == matrixRowNo )
					{
						matrixColMap.put(cell.getColumn(), cell.getContents());
					}
				}
			}
			BaseLogger.log("3",null,null,"matrixMap [" + matrixColMap + "]");
			matrixDetailMap.put("MATRIX_COL_MAP", matrixColMap);

			//Changed by Prasad on 01/02/18 [to resolve matrix upload issue] START
			int matrixCnt = 0;
			for ( Map.Entry<Integer, String> entry : matrixColMap.entrySet() )
			{
				if ( matrixCnt == 0 )
				{
					actualStartMatrixColNo = entry.getKey();
				}
				else if ( matrixCnt == 1 )
				{
					nextStartMatrixColNo = entry.getKey();
					break;
				}
				matrixCnt++;
			}
			//Changed by Prasad on 01/02/18 [to resolve matrix upload issue] END
			BaseLogger.log("3",null,null,"nextStartMatrixColNo - ["+ nextStartMatrixColNo +"], actualStartMatrixColNo - ["+ actualStartMatrixColNo +"]");
			matrixDetailMap.put( "ACTUAL_MATRIX_START_FROM", actualStartMatrixColNo );
			matrixDetailMap.put( "NEXT_MATRIX_START_FROM", nextStartMatrixColNo );

			int colSpan = nextStartMatrixColNo - actualStartMatrixColNo;
			BaseLogger.log("3",null,null,"colSpan - [" + colSpan + "]");
			matrixDetailMap.put("COLSPAN", colSpan);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return matrixDetailMap;
	}

	private ArrayList<Integer> getMatrixColList( int noOfColumns, int startMatrixColNo, int endMatrixColNo, int matrixStartFrom, int colSpan )
	{
		ArrayList<Integer> matrixColList = new ArrayList<Integer>();
		for (int colNo = 0; colNo < noOfColumns; colNo++)
		{
			if ( colNo < startMatrixColNo || colNo > endMatrixColNo )
			{
				matrixColList.add(colNo);
			}
			else if ( colNo >= matrixStartFrom && colNo < matrixStartFrom + colSpan )
			{
				matrixColList.add(colNo);
			}
		}
		return matrixColList;
	}

	private String getExcelContent( Sheet sheet, int headingRowNo, int rowNo, String targetColName, ArrayList<Integer> matrixColList, String matrixColVal ) throws ITMException
	{
		String contentData = "";
		try
		{
			int noOfColumns = sheet.getColumns();
			if ( matrixColList != null )
			{
				if ( "MatrixColumn".equalsIgnoreCase( targetColName ) )
				{
					contentData = matrixColVal;
				}
				else
				{
					for ( int i = 0; i < noOfColumns; i++ )
					{
						if ( matrixColList != null && matrixColList.contains( i ) )
						{
							String colName = (String) sheet.getCell(i, headingRowNo).getContents();
							colName = checkNull(colName).replaceAll(" ", "_");
							if( colName.equals(targetColName) )
							{
								contentData = sheet.getCell(i, rowNo).getContents();
							}
						}
					}
				}
			}
			else
			{
				for ( int i = 0; i < noOfColumns; i++ )
				{
					String colName = (String) sheet.getCell(i, headingRowNo).getContents();
					colName = checkNull(colName).replaceAll(" ", "_");
					if( colName.equals(targetColName) )
					{
						contentData = sheet.getCell(i, rowNo).getContents();
					}
				}
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return contentData;
	}

	private String removeLastComma( String inputStr )
	{
		try
		{
			if ( inputStr != null && inputStr.length() > 0 && inputStr.lastIndexOf(",") != -1 )
			{
				inputStr = inputStr.substring(0, inputStr.length() - 1);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return inputStr;
	}

	//Added By Ravindra C on 20-06-18 for building DetailData Map - Start
	/**
	 *
	 * @param sheet
	 * @param formNo
	 * @param rowNo
	 * @param actualColList
	 * @param matrixColList
	 * @param matrixContentVal
	 * @param sheetMapDetailMap
	 * @param sheetSrcTargetColumnMap
	 * @param sheetMappingLogicMap
	 * @param pkNameList
	 * @param colLogNameTypeMap
	 * @param colLogNameSizeMap
	 * @param parentPkNameList
	 * @return
	 * @throws ITMException
	 */
	private LinkedHashMap<String, String> buildDetailDataMap( Sheet sheet, int formNo, int rowNo, ArrayList<String> actualColList, ArrayList<Integer> matrixColList, String matrixContentVal,
			HashMap<Integer, HashMap<String, HashMap<String, String>>> sheetMapDetailMap,
			HashMap<Integer, LinkedHashMap<String, String>> sheetSrcTargetColumnMap,
			HashMap<Integer, LinkedHashMap<String, String>> sheetMappingLogicMap,
			ArrayList<String> pkNameList, HashMap<String, String> metadataColLogNameTypeMap,
			HashMap<String, String> dbColLogNameTypeMap,
			HashMap<String, Integer> colLogNameSizeMap,
			ArrayList<String> parentPkNameList, HashMap<String, HashMap<String, String>> dropDownColValueMap,
			HashMap<String, String> fieldCaseValueMap, HashMap<String, Integer> colLogNamePrecisionMap, int colSpan ) throws ITMException
	{
		LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
		try
		{
			HashMap<String, HashMap<String, String>> innerMap = sheetMapDetailMap.get(formNo);
			HashMap<String, String> srcTargetColumnMap = sheetSrcTargetColumnMap.get(formNo);
			HashMap<String, String> mapLogicMap = sheetMappingLogicMap.get(formNo);

			int headingRowNo = TemplateDetails.get(templateKey).getHeadingRowNo(formNo);

			int colSpanCnt = 0;

			String rowData = "";
			String colName = "", targetCol = "";
			int actualColListLen = actualColList.size();
			for ( int colNo = 0; colNo < actualColListLen; colNo++ )
			{
				colName = actualColList.get(colNo);
				if ( srcTargetColumnMap != null && srcTargetColumnMap.containsKey(colName) )
				{
					targetCol = srcTargetColumnMap.get(colName);
					BaseLogger.log("3",null,null,"<====> target Colum Name : [" + targetCol + "]");
					String excelContent = "";
					HashMap<String, String> contentMap = innerMap.get(colName);
					BaseLogger.log("3",null,null,"contentMap " + contentMap);

					String mapLogic = mapLogicMap.get(colName);
					BaseLogger.log("3",null,null,"mapLogic [" + mapLogic + "]");
					if( "R".equals( mapLogic ) )
					{
						String sqlInput = checkNull(contentMap.get("SQL_INPUT"));
						BaseLogger.log("3",null,null,"sqlInput - [" + sqlInput + "]");
						StringBuffer finalVal = new StringBuffer();
						if( sqlInput.contains(",") )
						{
							String[] sqlInputArray = sqlInput.split(",");
							for( int cnt= 0; cnt < sqlInputArray.length; cnt++ )
							{
								String sqlInputArg = checkNull(sqlInputArray[cnt]);
								String contentData = getExcelContent(sheet, headingRowNo, rowNo, sqlInputArg, matrixColList, matrixContentVal);
								finalVal.append(contentData);
								finalVal.append(",");
							}
						}
						else
						{
							String contentData = getExcelContent(sheet, headingRowNo, rowNo, sqlInput, matrixColList, matrixContentVal);
							finalVal.append(contentData);
							finalVal.append(",");
						}
						BaseLogger.log("3",null,null,"finalVal [" + finalVal + "]");
						excelContent = checkNull(finalVal.toString());
						excelContent = removeLastComma(excelContent);
					}
					else
					{
						excelContent = getExcelContent(sheet, headingRowNo, rowNo, targetCol, matrixColList, matrixContentVal);
					}
					
					BaseLogger.log("3",null,null,"excelContent: [" + excelContent + "]");
					String finalContent = applyMapLogic(excelContent, contentMap, mapLogic, userInfo);
					rowData += finalContent;
					//added By Ravindra C on 23-11-18 to prevent excel row's cell data - Start
					//if((CommonConstants.UPLOAD_IGNORE_VALUES).trim().length() > 0 && finalContent.equalsIgnoreCase(CommonConstants.UPLOAD_IGNORE_VALUES))
					//if((CommonConstants.UPLOAD_IGNORE_VALUES).trim().length() > 0 && finalContent.equalsIgnoreCase(CommonConstants.UPLOAD_IGNORE_VALUES))
					if((CommonConstants.UPLOAD_IGNORE_VALUES).trim().length() > 0 && finalContent.equalsIgnoreCase( CommonConstants.UPLOAD_IGNORE_VALUES) )
					{
						if( matrixColList != null )
						{
							if( colSpan > colSpanCnt )
							{
								colSpanCnt++;
							}
							if( colSpan == colSpanCnt )
							{
								return null;
							}
						}
						continue;
					}
					else
					{
						String errorDataStr = validateExcelInputData( colName, finalContent, metadataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, dropDownColValueMap, colLogNamePrecisionMap );
						errorDataStr = checkNull( errorDataStr );
						if ( errorDataStr.length() > 0 )
						{
							dataMap.put( "INPUT_DATA_ERR", errorDataStr );
							return dataMap;
						}
						//Added By Ravindra C on 20-11-18 for upper case data value -Start
						if( finalContent != null && finalContent.length() > 0 )
						{
							finalContent = fieldCaseData( fieldCaseValueMap, colName, finalContent );
						}
						//Added By Ravindra C on 20-11-18 for upper case data value - End
						//Added By Ravindra C on 20-11-18 to check line_no column size/data - Start 
						if ( "line_no".equalsIgnoreCase( colName ) || pkNameList.contains( colName ) )
						{
							finalContent = setCharFieldSpaces( dbColLogNameTypeMap, colLogNameSizeMap, colName, finalContent );
						}
						//Added By Ravindra C on 20-11-18 to check line_no column size/data - End
						dataMap.put( colName, finalContent );
						//added By Ravindra C on 15-11-18 to prevent excel row data - End
					}
					//Added By Ravindra C on 28-11-18 to to prevent excel row's cell data in Matrix excel file -Start
				}
			}
			rowData = checkNull( rowData );
			if ( rowData.length() == 0 )
			{
				return null;
			}
		}
		catch (ITMException e)
		{
			throw new ITMException(e);
		}
		return dataMap;
	}

	//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
	private String applyMapLogic(String excelContent, HashMap<String, String> dataMap, String mapLogic, UserInfoBean userInfo) throws ITMException
	{
		String respString = "";
		try
		{
			//changed By Ravindra C on 06-09-18 for prevent SYSOUT. - Start
			/*BaseLogger.log("3",null,null,"dataMap = " + dataMap);
			BaseLogger.log("3",null,null,"mapLogic = " + mapLogic);
			BaseLogger.log("3",null,null,"excelContent = " + excelContent);*/
			//changed By Ravindra C on 06-09-18 for prevent SYSOUT. - End

			if ("D".equals(mapLogic))
			{
				if ("".equals(excelContent))
				{
					excelContent = "~NOVALUE~";
				}
				BaseLogger.log("3",userInfo,null,"excelContent renamed = " + excelContent);
				if (dataMap.get(excelContent) != null && dataMap.get(excelContent).length() > 0)
				{
					respString = dataMap.get(excelContent);
				}
				else
				{
					respString = excelContent;
				}
			}
			else if ( "R".equals(mapLogic) )
			{
				respString = getSqlValue(dataMap.get("SQL"), excelContent);
			}
			else if ("S".equals(mapLogic))
			{
				if ( checkNull( dataMap.get("START_FROM") ).length() > 0 && checkNull( dataMap.get("UP_TO") ).length() > 0 )
				{
					int startFrom = (Integer.parseInt(dataMap.get("START_FROM")));
					int upTo = (Integer.parseInt(dataMap.get("UP_TO")));
					BaseLogger.log("3",userInfo,null," startFrom = " + startFrom);
					BaseLogger.log("3",userInfo,null," upTo = " + upTo);
					try
					{
						respString = excelContent.substring(startFrom, upTo);
					}
					catch (Exception e)
					{
						throw new ITMException(e);
					}
				}
				else
				{
					respString = excelContent;
				}
			}
			else if ("A".equals(mapLogic))
			{
				respString = excelContent;
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		BaseLogger.log("3",userInfo,null,"respString= " + respString);
		return respString;
	}

	private String getSqlValue(String sqlString, String sqlInput) throws ITMException
	{
		String respString = "";
		try
		{
			//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			respString = getUploadFile().getSqlValue(sqlString, sqlInput, userInfo);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return respString;
	}

    //Added By Ravindra C on 5-06-18 for batch load Process And to check file type(xml / Excel) - [Start]
	//private String createBatchLoadNProcess( final String objName, final UserInfoBean userInfo, HttpServletRequest request, HttpServletResponse response, final String excelFilePath, final String templateKey, HashMap<String, String> detailDataMap) throws ITMException
	//changed by Ravindra C on 08-09-18 for Validate dropDown Data
	//private String createBatchLoadNProcess( final String objName, final UserInfoBean userInfo, HttpServletRequest request, HttpServletResponse response, final String excelFilePath, final String templateKey, HashMap<String, String> detailDataMap, String fileType) throws ITMException
	private String createBatchLoadNProcess( final String objName, final UserInfoBean userInfo, HttpServletRequest request, HttpServletResponse response, final String excelFilePath, final String templateKey, HashMap<String, String> detailDataMap, String fileType, String tempName, String sessionId) throws ITMException
	{
		String respString = "";
		try
		{
			String winName = "w_" + objName;
			String xtraParam = getXtraParams(userInfo);

			//E12CreateBatchLoadRemote uBatchLoad = ( E12CreateBatchLoadRemote ) getInitialContext().lookup("ibase/E12CreateBatchLoadEjb/remote");
			E12CreateBatchLoadEjb uBatchLoad = new E12CreateBatchLoadEjb();
			//changed by Ravindra C on 08-09-18 for Validate dropDown Data
			//respString = uBatchLoad.createBatchLoad( detailDataMap, winName, "A", excelFilePath, xtraParam, userInfo, templateKey, fileType );
			respString = uBatchLoad.createBatchLoad( detailDataMap, winName, "A", excelFilePath, xtraParam, userInfo, templateKey, fileType, tempName, sessionId );
			BaseLogger.log("3",userInfo,null, "respString : ["+ respString +"]" );
			uBatchLoad = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return respString;
	}
	//Added By Ravindra C on 5-06-18 for batch load Process - [End]

	//Commented By Ravindra C on 25-06-18 and added this in the createBatchLoad()-for background batcload table entry -   Satrt
	/*private String uploadData( String batchId, UserInfoBean userInfo, String excelFilePath, String templateKey, String objName, String fileType )
	{
		String returnStr = "";
		try
		{
			String xtraParams = getXtraParams(userInfo);
			if ( batchId != null && batchId.length() > 0 )
			{
				MasterApplyEJBRemote masterApply = (MasterApplyEJBRemote) getInitialContext().lookup("ibase/MasterApplyEJB/remote");
				//Added By Ravindra C on 05-06-18 for xml file Upload -[Start]
				//returnStr = masterApply.applyMasterTable( batchId, xtraParams, userInfo, excelFilePath, templateKey );
				returnStr = masterApply.uploadBatchData( batchId, objName, excelFilePath, templateKey, xtraParams, userInfo, fileType );
				//Added By Ravindra C on 05-06-18 for xml file Upload -[End]
				BaseLogger.log("3",null,null, "returnStr : ["+ returnStr +"]" );
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}

		return returnStr;
	}*/
	//Commented By Ravindra C on 25-06-18 and added this in the createBatchLoad()-for background batcload table entry - End

	private String getXtraParams( UserInfoBean userInfo ) throws Exception
	{
		final String XTRA_PARAMS_SEPARATOR = "~~";
		StringBuffer xtraParamsBuff = new StringBuffer();

		xtraParamsBuff.append("loginCode=" + userInfo.getLoginCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + userInfo.getEmpCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + userInfo.getSiteCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + userInfo.getEntityCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + userInfo.getProfileId());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userInfo.getUserType());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId=" + userInfo.getRemoteHost());
		String chgTerm = userInfo.getRemoteHostName();

		if (chgTerm != null && chgTerm.length() > 15)
		{
			chgTerm = chgTerm.substring(0, 15);
		}
		else if (chgTerm == null || chgTerm.length() == 0)
		{
			chgTerm = userInfo.getRemoteHost();
		}

		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm);
		return xtraParamsBuff.toString();
	}

	private Set<String> getLogicalData(String mapLogic, int colNo, HttpServletRequest request)
	{
		Set<String> set = new HashSet<String>();

		try
		{
			String filePath = checkNull(request.getParameter("excelFilePath"));
			BaseLogger.log("3",null,null,"filePath = " + filePath);

			String colName = checkNull(request.getParameter("colName"));
			BaseLogger.log("3",null,null,"colName = " + colName);

			objName = uploadBean.getObjName();
			if ( request.getParameter( "objName" ) != null )
			{
				objName = "" + request.getParameter("objName");
				//setSessionAttribute("objName", objName);
				uploadBean.setObjName( objName );
			}
			/*else if ( getSessionAttribute( "objName" ) != null )
			{
				objName = (String) getSessionAttribute("objName");
			}*/

			String tempName = uploadBean.getSelectedTemplate();
			/*if ( tempName != null )
			{
				tempName = (String) getSessionAttribute("selectedTemplate");
			}*/
			if ( "new_template".equalsIgnoreCase( tempName ) )
			{
				isNewTemplate = true;
			}
			templateKey = objName + "::" + tempName;
			BaseLogger.log("3",null,null,"templateKey = " + templateKey);

			//String fileType = (String) getSessionAttribute("fileType");
			String fileType = uploadBean.getFileType();
			BaseLogger.log("3",null,null,"fileType = " + fileType);

			int tabNo = uploadBean.getTabNo();
			if ( request.getParameter( "formNo" ) != null )
			{
				tabNo = Integer.parseInt(request.getParameter("formNo"));
			}
			/*else if ( getSessionAttribute("tabNo") != null)
			{
				tabNo = (Integer) getSessionAttribute("tabNo");
			}*/
			BaseLogger.log("3",null,null,"TAB No. :: " + tabNo);

			String tabName = uploadBean.getTabName();
			if ( request.getParameter( "sheetName" ) != null )
			{
				tabName = request.getParameter("sheetName");
			}
			/*else if ( getSessionAttribute("tabName") != null)
			{
				tabName = (String) getSessionAttribute("tabName");
			}*/
			BaseLogger.log("3",null,null,"TAB NAME :: " + tabName);

			if ("D".equals(mapLogic) && "excel".equalsIgnoreCase(fileType))
			{
				workbook = getWorkbook(filePath);
				BaseLogger.log("3",null,null,"sheetName ["+ tabName +"]");
				Sheet sheet = workbook.getSheet(tabName);
				BaseLogger.log("3",null,null,"sheet ["+ sheet +"]");
				int noOfRows = sheet.getRows();
				int noOfColumns = sheet.getColumns();

				/*int headingRowNo = TemplateDetails.get(templateKey).getHeadingRowNo(tabNo);
				BaseLogger.log("3",null,null,"headingRowNo [" + headingRowNo + "]");

				int startsFrom = TemplateDetails.get(templateKey).getDataStartsFrom(tabNo);
				BaseLogger.log("3",null,null,"startsFrom [" + startsFrom + "]");*/

				int headingRowNo = 0, startsFrom = 1;
				if ( ! isNewTemplate() )
				{
					headingRowNo = TemplateDetails.get( templateKey ).getHeadingRowNo(tabNo);
					startsFrom = TemplateDetails.get( templateKey ).getDataStartsFrom(tabNo);
				}
				else
				{
					HashMap<Integer, HashMap<String, Integer>> matrixRowMap = uploadBean.getMatrixRowMap();
					if ( matrixRowMap != null )
					{
						//HashMap<Integer, HashMap<String, Integer>> matrixRowMap = (HashMap<Integer, HashMap<String, Integer>>) getSessionAttribute( "matrixRowMap" );
						HashMap<String, Integer> matrixValueMap = matrixRowMap.get( tabNo );
						if ( matrixValueMap != null )
						{
							headingRowNo = matrixValueMap.get( "HEADING_ROW" );
							startsFrom = matrixValueMap.get( "DATA_STARTS_FROM_ROW" );
						}
					}
				}
				BaseLogger.log("3",null,null,"headingRowNo - [" + headingRowNo + "]");
				BaseLogger.log("3",null,null,"matrixRowNo - [" + startsFrom + "]");
				/*int matrixRowNo = TemplateDetails.get( templateKey ).getMatrixRowNo( tabNo );
				int startMatrixColNo = TemplateDetails.get( templateKey ).getStartMatrixColNo( tabNo );
				int endMatrixColNo = TemplateDetails.get( templateKey ).getEndMatrixColNo( tabNo );
				BaseLogger.log("3",null,null,"matrixRowNo ["+ matrixRowNo +"]");
				BaseLogger.log("3",null,null,"startMatrixColNo ["+ startMatrixColNo +"]");
				BaseLogger.log("3",null,null,"endMatrixColNo ["+ endMatrixColNo +"]");*/

				if ( startsFrom > noOfRows )
				{
					startsFrom = 1;
				}
				BaseLogger.log("3",null,null,"startsFrom = [" + startsFrom + "] noOfRows = [" + noOfRows + "]");

				for (int i = 0; i < noOfColumns; i++)
				{
					String colsName = (String) sheet.getCell(i, headingRowNo).getContents();
					colsName = checkNull(colsName).replaceAll(" ", "_");
					if ( colName.equalsIgnoreCase( colsName ) )
					{
						colNo = i;
					}
				}
				for (int i = startsFrom; i < noOfRows; i++)
				{
					set.add(sheet.getCell(colNo, i).getContents());
				}
			}
			else if ("D".equals(mapLogic) && "xml".equalsIgnoreCase(fileType))
			{
				BaseLogger.log("3",null,null,"INSIDE XML MAP DATA ::: ");
				Document document = null;
				Node node = null;
				NodeList nodeList = null;
				Element element = null;

				File xmlFile = new File(filePath);
				DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
				document = parser.parse(xmlFile);
				//HashMap<Integer, String> tabMap = (HashMap<Integer, String>) getSessionAttribute("sheetInfoMap");
				HashMap<Integer, String> tabMap = uploadBean.getSheetInfo();
				nodeList = document.getElementsByTagName("DETAIL");
				node = nodeList.item(0);
				String selectedNode = "";
				tabName = uploadBean.getTabName();
				//if (setSessionAttribute("tabName") != null)
				if ( tabName != null)
				{ // In case of Multiple SheetNodes
					selectedNode = (String) tabMap.get(tabNo);
					nodeList = node.getChildNodes();// Gets " DETAIL+# " Node
					for (int i = 0; i < nodeList.getLength(); i++)
					{
						if (selectedNode.equalsIgnoreCase((String) nodeList.item(i).getNodeName()))
						{
							element = (Element) nodeList.item(i);
							break;
						}
					}
				}
				else
				{
					selectedNode = (String) node.getNodeName(); // In case of Single SheetNode
					nodeList = node.getChildNodes();// Gets " DETAIL+# " Node
					element = (Element) nodeList.item(0);
				}
				nodeList = (NodeList) element.getChildNodes();// gets the list of Rows in that Node. ChildNodes
				int length = nodeList.getLength(); // Total number of Rows Node present in XML File
				NodeList childNodeList = null;
				String nodeValue = "";
				for (int i = 0; i < length; i++)
				{ // Iterate Rows List
					node = nodeList.item(i); // Pick each row.
					childNodeList = node.getChildNodes(); // Get the column names within that row.
					for (int j = 0; j < childNodeList.getLength(); j++)
					{ // iterate Columns List
						if (j == colNo)
						{
							node = childNodeList.item(j).getFirstChild(); // Pick Column Node
							nodeValue = (String) node.getNodeValue(); // Get Data in that Column Node
							set.add(nodeValue);
						}
					}
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		BaseLogger.log("3",null,null,"set = " + set);
		return set;
	}

	private String saveTemplate( HttpServletRequest request ) throws ITMException
	{
		String returnStr = "";
		BufferedInputStream bfr = null;
		ByteArrayOutputStream bout = null;
		try
		{
			//Added by Ajinkya D on 16-NOV-2017 [For Upload Utility][START]
			//Changed By Ravindra C on 13-04-18 for Upload Utility
			//Sting filePath = ""+ getSessionAttribute( "excelFile" );

			/*byte[] byteArray ={0};
			File file = new File( filePath );
			String fileName = file.getName();
			FileInputStream input = new FileInputStream(file);
			bfr = new BufferedInputStream( input );
			bout = new ByteArrayOutputStream();
			int j = -1;
			while ( ( j = bfr.read() ) != -1 )
			{
				bout.write(j);
			}
			byteArray = bout.toByteArray();
			input.close();
			input = null;*/

			String shareScope = getRequestParamValue("shareScope");
			String scopeValue = getRequestParamValue("SCOPE_VAL");
			String templateRightsChar = getRequestParamValue("RIGHT_CHAR");
			//Added by Ajinkya D on 16-NOV-2017 [For Upload Utility] [END]

			int noOfForms = getNoOfForms();
			BaseLogger.log("3",null,null,"noOfForms [" + noOfForms + "]");

			int noOfSheets = getNoOfSheet();
			BaseLogger.log("3",null,null,"noOfSheets [" + noOfSheets + "]");

			//HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = TemplateDetails.get(templateKey).getFormWiseDefineValueAllMap();
			//HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = (HashMap<Integer, HashMap<String, HashMap<String, String>>>) getSessionAttribute( "defineValueAllMap" );
			HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = uploadBean.getAllFormDefineValueMap();
			BaseLogger.log("3",null,null,"defineValueAllMap [" + defineValueAllMap + "]");
			if ( defineValueAllMap == null )
			{
				defineValueAllMap = new HashMap<Integer, HashMap<String,HashMap<String,String>>>();
			}

			//HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = TemplateDetails.get(templateKey).getActualColMap();
			//HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = (HashMap<Integer, LinkedHashMap<String, String>>)setSessionAttribute( "actualColListMap" );
			HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = uploadBean.getActualColListMap();
			BaseLogger.log("3",null,null,"actualColListMap [" + actualColListMap + "]");
			if ( actualColListMap == null )
			{
				actualColListMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			}

			//HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = (HashMap<Integer, LinkedHashMap<String, String>>)setSessionAttribute( "mapLogicValueMap" ) ;
			HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = uploadBean.getMapLogicValueMap();
			if ( mapLogicValueMap == null )
			{
				mapLogicValueMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			}

			LinkedHashMap<String, String> parsedLogicValue = new LinkedHashMap<String, String>();
			//LinkedHashMap<String, String> targetColumn = new LinkedHashMap<String, String>();
			LinkedHashMap<String, String> actualColMap = new LinkedHashMap<String, String>();
			HashMap<String, HashMap<String, String>> defineValueMap = new HashMap<String, HashMap<String, String>>();

			StringBuffer xmlString = new StringBuffer();
			xmlString.append("<TEMPLATE>");
			for ( int formNum = 1; formNum <= noOfForms; formNum++ )
			{
				BaseLogger.log("3",null,null,"formNo [" + formNum + "]");

				//parsedLogicValue = TemplateDetails.get(templateKey).getMapLogicValue(i);
				if ( mapLogicValueMap != null )
	 			{
		 			parsedLogicValue = mapLogicValueMap.get( formNum );
	 			}
				BaseLogger.log("3",null,null,"parsedLogicValue ::: [" + parsedLogicValue + "]");

				//targetColumn = TemplateDetails.get( templateKey ).getTargetCol( i );
				//BaseLogger.log("3",null,null, "targetColumn ::: [" + targetColumn + "]" );
				actualColMap = actualColListMap.get(formNum);
				BaseLogger.log("3",null,null,"actualColMap ::: [" + actualColMap + "]");

				defineValueMap = defineValueAllMap.get(formNum);
				BaseLogger.log("3",null,null,"defineValueMap ::: [" + defineValueMap + "]");

				String colName = "";
				String targetCol = "";
				xmlString.append("<DETAIL" + formNum + ">");

				int rowCnt = 0;
				for ( Map.Entry<String, String> entry : actualColMap.entrySet() )
				{
					colName = entry.getKey();
					BaseLogger.log("3",null,null,"colName ::: [" + colName + "]");

					targetCol = getRequestParamValue("targetCol" + rowCnt + "_" + formNum);
					BaseLogger.log("3",null,null,"targetCol ::: [" + targetCol + "]");
					if ( targetCol.length() > 0 && ! "none".equalsIgnoreCase( targetCol ) )
					{
						xmlString.append("<COLUMN>");
						xmlString.append("<SRC_COL>" + colName + "</SRC_COL>");
						String mapLogicVal = getRequestParamValue("mapLogic" + rowCnt + "_" + formNum);
						BaseLogger.log("3",null,null,"mapLogicVal ::: [" + mapLogicVal + "]");
						xmlString.append("<MAP_LOGIC TYPE = '" + mapLogicVal + "'>");
						if ( "D".equals( mapLogicVal ) )
						{
							if ( defineValueMap.get("valueMap" + rowCnt) != null )
							{
								HashMap<String, String> valueMap = (HashMap<String, String>) defineValueMap.get("valueMap" + rowCnt);
								BaseLogger.log("3",null,null,"valueMap ::: [" + valueMap + "]");
								Iterator<String> it = valueMap.keySet().iterator();

								while (it.hasNext())
								{
									String srcVal = (String) it.next();
									String replaceVal = (String) valueMap.get(srcVal);
									xmlString.append("<SRC_VAL KEY = '" + srcVal + "'><![CDATA[" + replaceVal + "]]>" + "</SRC_VAL>");
								}
							}
						}
						else if ( "R".equals( mapLogicVal ) )
						{
							String sql = parsedLogicValue.get("SQL_" + colName);
							String sqlInput = parsedLogicValue.get("SQL_INPUT_" + colName);
							BaseLogger.log("3",null,null,"sql - [" + sql + "], sqlInput - [" + sqlInput + "]");

							xmlString.append("<SQL><![CDATA[" + sql + "]]></SQL>");
							xmlString.append("<SQL_INPUT><![CDATA[" + sqlInput + "]]></SQL_INPUT>");
						}
						else if ( "S".equals( mapLogicVal ) )
						{
							String startFrom = parsedLogicValue.get("START_FROM_" + colName);
							String upTo = parsedLogicValue.get("UP_TO_" + colName);
							BaseLogger.log("3",null,null,"startFrom - [" + startFrom + "], upTo - [" + upTo + "]");

							xmlString.append("<START_FROM><![CDATA[" + startFrom + "]]></START_FROM>");
							xmlString.append("<UP_TO><![CDATA[" + upTo + "]]></UP_TO>");
						}
						xmlString.append("</MAP_LOGIC>");
						xmlString.append("<TARGET_COL><![CDATA[" + targetCol + "]]></TARGET_COL>");
						xmlString.append("</COLUMN>");
					}
					rowCnt++;
				}
				xmlString.append("</DETAIL" + formNum + ">");
			}
			xmlString.append("</TEMPLATE>");
			BaseLogger.log("3",null,null,"CREATED TEMPLATE ::: " + xmlString);

			//HashMap excelSheetInfo = (HashMap) getSessionAttribute( "excelSheetInfo" );
			HashMap<Integer, String> excelSheetInfo = uploadBean.getExcelSheetInfo();

			StringBuffer mappingXml = new StringBuffer();
			mappingXml.append("<ROOT>");
			for ( int formNum = 1; formNum <= noOfForms; formNum++ )
			{
				BaseLogger.log("3",null,null,"formNo [" + formNum + "]");

				mappingXml.append("<DETAIL" + formNum + ">");

				int sheetNo = Integer.parseInt( getRequestParamValue( "sheetName" + formNum ) );
				String sheetName = "";
				if ( excelSheetInfo != null && excelSheetInfo.containsKey( sheetNo ) )
				{
					sheetName = (String)excelSheetInfo.get( sheetNo );
				}
				
				//Added By Ravindra C on 25-04-19 to validate matrix template against selected excel file - Start
				if ( getRequestParamValue( "sheetName"+formNum ).length() > 0 )
				{
					sheetNo = Integer.parseInt( getRequestParamValue( "sheetName"+formNum ) );
				}
				sheetName = checkNull((String)excelSheetInfo.get( sheetNo ));
				int colSpan = uploadBean.getMatrixColSpan( sheetName ); 
				//Added By Ravindra C on 25-04-19 to validate matrix template against selected excel file - End

				mappingXml.append("<SHEETNAME><![CDATA[" + sheetName + "]]></SHEETNAME>");

				String headingRowNo = getRequestParamValue("headingRowNo" + formNum);
				mappingXml.append("<HEADING_ROW><![CDATA[" + headingRowNo + "]]></HEADING_ROW>");

				String dataStartFrom = getRequestParamValue("dataStartFrom" + formNum);
				mappingXml.append("<DATA_STARTS_FROM_ROW><![CDATA[" + dataStartFrom + "]]></DATA_STARTS_FROM_ROW>");

				String matrixRowNo = getRequestParamValue("matrixRowNo" + formNum);
				mappingXml.append("<MATRIX_HEADER_ROW><![CDATA[" + matrixRowNo + "]]></MATRIX_HEADER_ROW>");

				String startMatrixColNo = getRequestParamValue("startMatrixColNo" + formNum);
				mappingXml.append("<MATRIX_START_COL><![CDATA[" + startMatrixColNo + "]]></MATRIX_START_COL>");

				String endMatrixColNo = getRequestParamValue("endMatrixColNo" + formNum);
				mappingXml.append("<MATRIX_END_COL><![CDATA[" + endMatrixColNo + "]]></MATRIX_END_COL>");
				
				//Added By Ravindra C on 25-04-19  to validate matrix Excel template against selected excel file 
				mappingXml.append("<COL_SPAN><![CDATA[" + colSpan + "]]></COL_SPAN>");

				mappingXml.append("</DETAIL" + formNum + ">");
				//removeRowsFromExcel( sheetName, headingRowNo );
			}
			mappingXml.append("</ROOT>");
			BaseLogger.log("3",null,null,"Mapping xml ::: " + mappingXml);

			String tempName = getRequestParamValue( "existingTemplate" );
			String isDefaultTemplate = getRequestParamValue( "isDefault" );
			
			//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload]
			String isAutoConfirm = getRequestParamValue( "isAutoConfirm" );
			BaseLogger.log("3",null,null,"isAutoConfirm : ["+ isAutoConfirm +"]");
			
			String templateId = "";
			BaseLogger.log("3", userInfo,  null," isNewTemplate=[" + isNewTemplate() + "]");
			if ( ! isNewTemplate() )
			{
				templateId = checkNull( TemplateDetails.get(objName).getTemplateId(tempName) );
			}
			else
			{
				tempName = getRequestParamValue( "newTemplateName" );
				//setSessionAttribute( "selectedTemplate", tempName );
				uploadBean.setSelectedTemplate( tempName );
				BaseLogger.log("3",null,null,"tempName : ["+ tempName +"]");
				//Added By Ravindra C on 23-04-18 for [Duplicate Template Name ]-- Start
				boolean templetErrorMsg = getUploadFile().checkExistingTempName( objName, tempName, getUserInfo() );
				BaseLogger.log("3",null,null,"tempErroMsg : ["+ templetErrorMsg +"]");
				if( templetErrorMsg )
				{
					returnStr = genericUtility.getErrorString( "", "VTEMPNAME", userId );
					return returnStr;
				}
				//Added By Ravindra C on 23-04-18 for [Duplicate Template Name ]-- End
			}

			//Changed By Ravindra C on 14-04-18 For upload Utility --- Start
			//String filePath = ""+ getSessionAttribute( "uploadExcelpath" );
			String filePath = uploadBean.getUploadFilepath();
			BaseLogger.log("3",userInfo,null, "filePath : ["+ filePath +"]" );
			byte[] byteArray = null;
			String fileName = "";
			if ( filePath != null && filePath.length() > 0 )
			{
				File file = new File( filePath );
				if( file.exists() )
				{
					fileName = file.getName();
					FileInputStream input = new FileInputStream( file );
					bfr = new BufferedInputStream( input );
					bout = new ByteArrayOutputStream();
					int j = -1;
					while ( ( j = bfr.read() ) != -1 )
					{
						bout.write(j);
					}
					byteArray = bout.toByteArray();
					input.close();
					input = null;

					//Changed by Prasad on 07/06/18 [resolving file upload issue]
					//file.delete();
				}
			}
			//Changed By Ravindra C on 14-04-18 For upload Utility-- End

			//Changed by Ajinkya D on 16-NOV-2017 [For Upload Utility changes][END]
			//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload]
			returnStr = getUploadFile().saveTemplate( templateId, objName, tempName, xmlString.toString(), isDefaultTemplate, mappingXml.toString(), shareScope, scopeValue, templateRightsChar, fileName, byteArray, filePath, isAutoConfirm, getUserInfo() );
			//Changed by Ajinkya D on 16-NOV-2017 [For Upload Utility changes][END]
			
			//Changed by Prasad on 07/06/18 [resolving file upload issue] START
			if ( filePath != null && filePath.length() > 0 )
			{
				File file = new File( filePath );
				if( file.exists() )
				{
					file.delete();
				}
			}
			//Changed by Prasad on 07/06/18 [resolving file upload issue] END

			BaseLogger.log("3",null,null,"returnStr ::: " + returnStr);

			if ( returnStr.indexOf( "Success" ) != -1 )
			{
				/*TemplateDetails.get(objName).setTemplateXml(tempName, xmlString.toString());
				TemplateDetails.get(objName).setFileMapping(tempName, mappingXml.toString());
				TemplateDetails.get(objName).setDefaultTemplate(tempName, isDefaultTemplate);*/
				templateKey = objName + "::" + tempName;
				isNewTemplate = false;
				//String caller = ""+ getSessionAttribute( "caller" );
				String caller = uploadBean.getCaller();
				HashMap<String, HashMap<String, String>> templateMap = getUploadFile().getTemplateDetail(objName, caller, userInfo);
				//setSessionAttribute("templateMap", templateMap);
				uploadBean.setTemplateMap( templateMap );

				TemplateDetails.get(objName).setTemplateMap(templateMap);

				String defaultTemplate = TemplateDetails.get(objName).getDefaultTemplate();
				//setSessionAttribute("defaultTemplate", defaultTemplate);
				uploadBean.setDefaultTemplate( defaultTemplate );

				String templateXml = TemplateDetails.get(objName).getTemplateXml(tempName);
				String fileMappingXml = TemplateDetails.get(objName).getFileMapping(tempName);

				int totalForms = getNoOfForms();
				TemplateDetails.get(templateKey).createTemplateDetail(templateXml, totalForms);
				//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] START
				//TemplateDetails.get(templateKey).createFileMappingDetail(fileMappingXml);
				BaseLogger.log("3",userInfo,null,"excelSheetInfo=[" + excelSheetInfo+"]");
				BaseLogger.log("3",userInfo,null,"fileMappingXml=[" + fileMappingXml+"]");
				if ( "json".equalsIgnoreCase( uploadBean.getFileType() ) )
				{
					uploadBean.setSheetInfo( excelSheetInfo );
				}
				//Added by Ankush S. on 02-Nov-2022 [save xml file template data]START 
				else if("xml".equalsIgnoreCase(uploadBean.getFileType())) {
					System.out.println("Got file type xml in save template");
					uploadBean.setSheetInfo( excelSheetInfo );
				}//Added by Ankush S. on 02-Nov-2022 [save xml file template data]END
				else
				{
					TemplateDetails.get(templateKey).createFileMappingDetail(fileMappingXml);
				}
				//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] END

				shareScope = TemplateDetails.get(objName).getShareScope(tempName);
				//setSessionAttribute( "shareScopeVal", shareScope );
				uploadBean.setShareScope( shareScope );

				scopeValue = TemplateDetails.get(objName).getScopeValue(tempName);
				//setSessionAttribute( "scopeValueVal", scopeValue );
				uploadBean.setScopeValue( scopeValue );

				String tempRightsChar = TemplateDetails.get(objName).getTempRightsChar(tempName);
				//setSessionAttribute( "tempRightsChar", tempRightsChar );
				uploadBean.setTempRightsChar( tempRightsChar );

				String excelFilePath = uploadBean.getFilePath();
				if ( excelFilePath != null )
				{
					//String excelFilePath = (String) getSessionAttribute("excelFile");
					//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] START
					BaseLogger.log( "3", null, null, "Filetype :: ["+ uploadBean.getFileType() +"]" );
					if( "json".equalsIgnoreCase( uploadBean.getFileType() ) )
					{
						createJsonColumnMap( excelFilePath, request );
					}
					else if("xml".equalsIgnoreCase(uploadBean.getFileType())) {
						System.out.println("Creating xml columnMap");
						createXmlColumnMap(excelFilePath, request);
					}
					else
					{
						if ( workbook == null )
						{
							getWorkbook(excelFilePath);
						}
						createExcelColumnMap(excelFilePath, request);
					}
					//Changed by Ravindra C on 19/01/2021 [to json data mapping implementation] END
				}

				boolean isDefault = TemplateDetails.get(objName).isDefaultTemplate(tempName);
				if( isDefault )
				{
					//setSessionAttribute("isDefaultTemp", "Y");
					uploadBean.setIsDefaultTemp( "Y" );
				}
				else
				{
					//setSessionAttribute("isDefaultTemp", "N");
					uploadBean.setIsDefaultTemp( "N" );
				}
				//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload] START
				boolean autoConfirm = TemplateDetails.get(objName).isAutoConfirm(tempName);
				if( autoConfirm )
				{
					uploadBean.setAutoConfirm( "Y" );
				}
				else
				{
					uploadBean.setAutoConfirm( "N" );
				}
				//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload] END
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( bfr != null )
				{
					bfr.close();
					bfr = null;
				}
				if( bout != null )
				{
					bout.close();
					bout = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}
		return returnStr;
	}


	// Added By Ankush S. on 17-Oct-2022 [To validate xml input data]START
	private String validateXmlInputData() throws ITMException {
		String retStr = "<Root><Detail>Success</Detail></Root>";
		try {
			String sheetName = "";
			int sheetNo = 0;
			Node rootNode = null;

			HashMap<Integer, String> excelSheetsInfo = uploadBean.getExcelSheetInfo();
			BaseLogger.log("3", null, null, "excelSheetInfo - [" + excelSheetsInfo + "]");
			TreeMap<Integer, String> formDetailInfo = uploadBean.getFormDetailInfo();
			if (formDetailInfo == null) {
				formDetailInfo = new TreeMap<Integer, String>();
			}
			String excelFilePath = uploadBean.getFilePath();
			
			BaseLogger.log("3", userInfo, null, "xmlFilePath - [" + excelFilePath + "]");
			BaseLogger.log("3", userInfo, null, " validateXML file formDetailInfo - [" + formDetailInfo + "]");
			rootNode = getRootNode(excelFilePath);
			BaseLogger.log("3", userInfo, null, "xml root node - [" + rootNode.getNodeName() + "]");

			int formNo = Integer.parseInt(getRequestParamValue("formNo"));
			BaseLogger.log("3", userInfo, null, "formNo - [" + formNo + "]");

			sheetNo = Integer.parseInt(getRequestParamValue("sheetName" + formNo));
			BaseLogger.log("3", userInfo, null, "sheetName - [" + sheetName + "]");

			String formName = formDetailInfo.get(formNo);
			BaseLogger.log("3", userInfo, null, "formName - [" + formName + "]");

			sheetName = excelSheetsInfo.get(sheetNo);
			BaseLogger.log("3", null, null, "sheetName 11 - [" + sheetName + "]");
			sheetName = "Detail"+sheetNo;
			NodeList childNodeList = rootNode.getChildNodes();
			Node childNode = null;
			List<Node>detailNodeList = new ArrayList<>();
			for (int i = 0; i < childNodeList.getLength(); i++) {
				BaseLogger.log("3", userInfo, null, "Node Name - [" + childNodeList.item(i).getNodeName() + "]");
				if (childNodeList.item(i).getNodeName().equalsIgnoreCase(sheetName)) {
					System.out.println("Got matched Child Node Name="+sheetName);
					childNode = childNodeList.item(i);
					detailNodeList.add(childNodeList.item(i));
				}
			}
			BaseLogger.log("3", userInfo, null, "node Name - [" + childNode.getNodeName() + "]");
			
			detailNodeList.stream().forEach(e->System.out.println("node name in list["+e.getNodeName()));;
			int noOfRows = 0;
			noOfRows = detailNodeList.size();
			NodeList childNodeNodeList = childNode.getChildNodes();
			Node childDataNode = null;
			List<Node> actualChildNodeList = new ArrayList<Node>();
			for (int i = 0; i < childNodeNodeList.getLength(); i++) {
				if (!childNodeNodeList.item(i).getNodeName().contains("#")) {
                     System.out.println("Got Child Node=<"+childNodeNodeList.item(i).getNodeName());
					if (childDataNode == null) {
						childDataNode = childNodeNodeList.item(i);
					}
					actualChildNodeList.add(childNodeNodeList.item(i));

					//noOfRows++;
				}
			}
			///actualChildNodeList.clear();
			//actualChildNodeList.addAll(detailNodeList);
			//childDataNode =	actualChildNodeList.size()>0?actualChildNodeList.get(0) :null;
			childDataNode = childNode;
			
			System.out.println("Got childDataNode Name="+childDataNode.getNodeName());
			System.out.println("Got actualChildNodeList Name="+actualChildNodeList);
			BaseLogger.log("3", userInfo, null, "node no of rows - [" + noOfRows + "]");
			int noOfColumns = 0;
			NodeList childNodeDataNodeList = childDataNode.getChildNodes();

			for (int i = 0; i < childNodeDataNodeList.getLength(); i++) {
				if (!childNodeDataNodeList.item(i).getNodeName().contains("#")) {

					noOfColumns++;
				}
			}
			
			BaseLogger.log("3", userInfo, null, "noOfColumns - [" + noOfColumns + "]");

			BaseLogger.log("3", userInfo, null, "noOfRows - [" + noOfRows + "]");

			int headingRowNum = 1, matrixRowNum = -1, startMatrixColNum = -1, endMatrixColNum = -1, dataStartsFrom = 2;
			if ((getRequestParamValue("dataStartFrom" + formNo)).length() > 0) {
				dataStartsFrom = Integer.parseInt(getRequestParamValue("dataStartFrom" + formNo));
				BaseLogger.log("3", userInfo, null, "dataStartsFrom - [" + dataStartsFrom + "]");
			}
			dataStartsFrom -= 1;
			if ((getRequestParamValue("headingRowNo" + formNo)).length() > 0) {
				headingRowNum = Integer.parseInt(getRequestParamValue("headingRowNo" + formNo));
				headingRowNum -= 1;
				BaseLogger.log("3", userInfo, null, "headingRowNum - [" + headingRowNum + "]");
			}
			if ((getRequestParamValue("matrixRowNo" + formNo)).length() > 0) {
				matrixRowNum = Integer.parseInt(getRequestParamValue("matrixRowNo" + formNo));
				BaseLogger.log("3", userInfo, null, "matrixRowNum - [" + matrixRowNum + "]");
				matrixRowNum -= 1;
			}
			if ((getRequestParamValue("startMatrixColNo" + formNo)).length() > 0) {
				startMatrixColNum = Integer.parseInt(getRequestParamValue("startMatrixColNo" + formNo));
				BaseLogger.log("3", userInfo, null, "startMatrixColNum - [" + startMatrixColNum + "]");
				startMatrixColNum -= 1;
			}
			if ((getRequestParamValue("endMatrixColNo" + formNo)).length() > 0) {
				endMatrixColNum = Integer.parseInt(getRequestParamValue("endMatrixColNo" + formNo));
				BaseLogger.log("3", userInfo, null, "endMatrixColNum - [" + endMatrixColNum + "]");
				endMatrixColNum -= 1;
			}

			if (matrixRowNum != -1 && endMatrixColNum == -1) {
				endMatrixColNum = noOfColumns;
			}
			BaseLogger.log("3", null, null, "Form [" + formNo + "],xml dataStartsFrom - [" + dataStartsFrom + "]");
			BaseLogger.log("3", null, null, "Form [" + formNo + "],xml headingRowNo - [" + headingRowNum + "]");
			BaseLogger.log("3", null, null, "Form [" + formNo + "],xml matrixRowNo - [" + matrixRowNum + "]");
			BaseLogger.log("3", null, null, "Form [" + formNo + "],xml startMatrixColNum - [" + startMatrixColNum + "]");
			BaseLogger.log("3", null, null, "Form [" + formNo + "],xml endMatrixColNum - [" + endMatrixColNum + "]");
			if (dataStartsFrom > 0)
				dataStartsFrom -= 1;
			dataStartsFrom=0;
			String rowdata = "";
			if (noOfRows >= dataStartsFrom) {
				try {
					for (int i = dataStartsFrom; i < actualChildNodeList.size(); i++) {
						String data = "";
						if (!actualChildNodeList.get(i).getNodeName().contains("#")) {
							Node rowNode = actualChildNodeList.get(i);
							System.out.println("Data node Name"+actualChildNodeList.get(i).getNodeName());
							data = rowNode.getFirstChild()!=null?rowNode.getFirstChild().getTextContent():"";
							rowdata =rowdata+ checkNull(data);
							data="";
							//System.out.println("GOt RowData="+rowdata);
							NodeList rowChildNodeList = rowNode.getChildNodes();
							/*for (int j = 0; j < rowChildNodeList.getLength(); j++) {
								Node dataNode = rowChildNodeList.item(j);
								if (!dataNode.getNodeName().contains("#")) {
									//String data = "";
									if (dataNode.getFirstChild() != null) {
										data = dataNode.getFirstChild().getTextContent();
									} else {
										data = "";
									}
									rowdata += checkNull(data);
									data = "";
								}
							}*/
							if (rowdata.length() == 0) {
								retStr = genericUtility.getErrorString("", "INVDSF", userId);
							}
							if (retStr.indexOf("<Errors>") == -1 && headingRowNum != -1) {
								NodeList headingNodeList = rowChildNodeList.item(0).getChildNodes();
								/*for (int k = 0; k < headingNodeList.getLength(); k++) {
									String headData = "";
									if (headingNodeList.item(k).getFirstChild() != null) {
										headData = headingNodeList.item(k).getFirstChild().getTextContent();
									}
									
									rowdata = rowdata + headData;
								}*/
								
								//rowdata = rowdata + rowdata;
								rowdata = checkNull(rowdata);
//								BaseLogger.log("3", null, null, "rowdata = [" + rowdata + "]");
//								if (rowdata.length() == 0) {
//									retStr = genericUtility.getErrorString("", "INVEXHDR", userId);
//								}
							}
						}
					}
					BaseLogger.log("3", null, null, "rowdata = [" + rowdata + "]");
					if (rowdata.length() == 0) {
						retStr = genericUtility.getErrorString("", "INVEXHDR", userId);
					}

				} catch (Exception e) {
					BaseLogger.log("3", userInfo, null, "Exception [" + e.getMessage() + "]");
				}
			} else {
				retStr = genericUtility.getErrorString("", "INVDSF", userId);
			}
		} catch (Exception e) {
			BaseLogger.log("0", userInfo, null, "Exception in validateInputData - [" + e.getMessage() + "]");
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo, null, "xml validateXmlInputData= retStr - [" + retStr + "]");
		return retStr;
	}
	// Added By Ankush S. on 17-Oct-2022 [To validate xml input data]END
	
	private String validateInputData() throws ITMException
	{
		String retStr = "<Root><Detail>Success</Detail></Root>";
		try
		{
			String sheetName = "";
			int sheetNo = 0;
			//HashMap<Integer, String> excelSheetsInfo = (HashMap<Integer, String>) getSessionAttribute( "excelSheetInfo");
			HashMap<Integer, String> excelSheetsInfo = uploadBean.getExcelSheetInfo();
			BaseLogger.log("3",null,null, "excelSheetInfo - ["+ excelSheetsInfo +"]" );
			//TreeMap<Integer,String> formDetailInfo = (TreeMap) getSessionAttribute( "formDetailInfo" );
			TreeMap<Integer,String> formDetailInfo = uploadBean.getFormDetailInfo();
			if(formDetailInfo == null)
			{
				formDetailInfo = new TreeMap<Integer,String>();
			}
			String excelFilePath = uploadBean.getFilePath();
			/*if ( getSessionAttribute( "excelFile" ) != null )
			{
				excelFilePath = (String) getSessionAttribute( "excelFile" );
			}*/
			BaseLogger.log("3",null,null, "excelFilePath - ["+ excelFilePath +"]" );
			workbook = getWorkbook( excelFilePath );

			BaseLogger.log("3",null,null, "workbook - ["+ workbook +"]" );

			int formNo = Integer.parseInt( getRequestParamValue( "formNo" ) );
			BaseLogger.log("3",null,null, "formNo - ["+ formNo +"]" );

			sheetNo = Integer.parseInt(getRequestParamValue("sheetName"+formNo ));
			BaseLogger.log("3",null,null, "sheetName - ["+ sheetName +"]" );

			String formName = formDetailInfo.get( formNo );
			BaseLogger.log("3",null,null, "formName - ["+ formName +"]" );

			//sheetName = TemplateDetails.get( templateKey ).getSheetName( formNo );
			sheetName = excelSheetsInfo.get( sheetNo );
			BaseLogger.log("3",null,null, "sheetName 11 - ["+ sheetName +"]" );

			Sheet sheet = workbook.getSheet( sheetName );
			BaseLogger.log("3",null,null, "sheet - ["+ sheet +"]" );

			int noOfRows = sheet.getRows();
			BaseLogger.log("3",null,null, "noOfRows - ["+ noOfRows +"]" );

			int noOfColumns = sheet.getColumns();
			BaseLogger.log("3",null,null, "noOfColumns - ["+ noOfColumns +"]" );

			int headingRowNum = 1, matrixRowNum = -1, startMatrixColNum = -1, endMatrixColNum = -1, dataStartsFrom = 2;
			if ( ( getRequestParamValue("dataStartFrom"+formNo) ).length() > 0 )
			{
				dataStartsFrom = Integer.parseInt( getRequestParamValue("dataStartFrom"+formNo) );
				BaseLogger.log("3",null,null, "dataStartsFrom - ["+ dataStartsFrom +"]" );
			}
			dataStartsFrom -= 1;
			if ( ( getRequestParamValue("headingRowNo"+formNo) ).length() > 0 )
			{
				headingRowNum = Integer.parseInt( getRequestParamValue("headingRowNo"+formNo) );
				headingRowNum -= 1;
				BaseLogger.log("3",null,null, "headingRowNum - ["+ headingRowNum +"]" );
			}
			if ( ( getRequestParamValue("matrixRowNo"+formNo) ).length() > 0 )
			{
				matrixRowNum = Integer.parseInt( getRequestParamValue("matrixRowNo"+formNo) );
				BaseLogger.log("3",null,null, "matrixRowNum - ["+ matrixRowNum +"]" );
				matrixRowNum -= 1;
			}
			if ( ( getRequestParamValue("startMatrixColNo"+formNo) ).length() > 0 )
			{
				startMatrixColNum = Integer.parseInt( getRequestParamValue("startMatrixColNo"+formNo) );
				BaseLogger.log("3",null,null, "startMatrixColNum - ["+ startMatrixColNum +"]" );
				startMatrixColNum -= 1;
			}
			if ( ( getRequestParamValue("endMatrixColNo"+formNo) ).length() > 0 )
			{
				endMatrixColNum = Integer.parseInt( getRequestParamValue("endMatrixColNo"+formNo) );
				BaseLogger.log("3",null,null, "endMatrixColNum - ["+ endMatrixColNum +"]" );
				endMatrixColNum -= 1;
			}

			if ( matrixRowNum != -1 && endMatrixColNum == -1 )
			{
				endMatrixColNum = noOfColumns;
			}
			BaseLogger.log("3",null,null,"Form ["+ formNo +"], dataStartsFrom - ["+ dataStartsFrom +"]");
			BaseLogger.log("3",null,null,"Form ["+ formNo +"], headingRowNo - ["+ headingRowNum +"]");
			BaseLogger.log("3",null,null,"Form ["+ formNo +"], matrixRowNo - ["+ matrixRowNum +"]");
			BaseLogger.log("3",null,null,"Form ["+ formNo +"], startMatrixColNum - ["+ startMatrixColNum +"]");
			BaseLogger.log("3",null,null,"Form ["+ formNo +"], endMatrixColNum - ["+ endMatrixColNum +"]");

			String rowdata = "";
			if ( noOfRows >= dataStartsFrom )
			{
				try
				{
					for (int j = 0; j < noOfColumns; j++)
					{
						rowdata += checkNull( (String) sheet.getCell(j, dataStartsFrom).getContents() );
					}
					BaseLogger.log("3",null,null, "rowdata = ["+ rowdata +"]" );
					if ( rowdata.length() == 0 )
					{
						//retStr = "DATA_START_FROM_ERROR";
						retStr = genericUtility.getErrorString( "", "INVDSF", userId );
					}
					if ( retStr.indexOf( "<Errors>" ) == -1 && headingRowNum != -1 )
					{
						rowdata = checkNull( (String) sheet.getCell(0, headingRowNum).getContents() );
						BaseLogger.log("3",null,null, "rowdata = ["+ rowdata +"]" );
						if ( rowdata.length() == 0 )
						{
							//retStr = "EXCEL_HEADER_ERROR";
							retStr = genericUtility.getErrorString( "", "INVEXHDR", userId );
						}
					}
					if ( retStr.indexOf( "<Errors>" ) == -1 && matrixRowNum >= 0 )
					{
						//changed By Ravindra C on 12-03-19 for the single matrix upload. 
						//HashMap<String, Object> matrixDetailMap = getMatrixDetailMap( sheet, matrixRowNum );
						HashMap<String, Object> matrixDetailMap = getMatrixDetailMap( sheet, matrixRowNum, startMatrixColNum, endMatrixColNum );
						BaseLogger.log("3",null,null,"matrixMap ["+ matrixDetailMap +"]");

						int actualStartMatrixColNo = (Integer) matrixDetailMap.get( "ACTUAL_MATRIX_START_FROM" );
						BaseLogger.log("3",null,null, "actualStartMatrixColNo - ["+ actualStartMatrixColNo +"]" );

						if ( startMatrixColNum != actualStartMatrixColNo )
						{
							//retStr = "START_MATRIX_COLUMN_ERROR";
							retStr = genericUtility.getErrorString( "", "INVSTMCOL", userId );
						}
						else
						{
							int colSpan = (Integer) matrixDetailMap.get( "COLSPAN" );
							BaseLogger.log("3",null,null, "colSpan - ["+ colSpan +"]" );
							int nextStartMatrixColNo = (Integer) matrixDetailMap.get( "NEXT_MATRIX_START_FROM" );
							BaseLogger.log("3",null,null, "nextStartMatrixColNo - ["+ nextStartMatrixColNo +"]" );

							ArrayList<String> matrixSubColList = new ArrayList<String>();
							for ( int j = actualStartMatrixColNo; j < nextStartMatrixColNo; j++ )
							{
								String colVal = (String) sheet.getCell( j, headingRowNum ).getContents();
								matrixSubColList.add( colVal );
							}
							BaseLogger.log("3",null,null, "matrixSubColList - "+ matrixSubColList );
							int loopCnt = 0;
							int prevStartMatrixColNo = nextStartMatrixColNo;

							TreeMap<Integer, String> matrixColMap = (TreeMap<Integer, String>) matrixDetailMap.get( "MATRIX_COL_MAP" );
							BaseLogger.log("3",null,null, "matrixColMap - "+ matrixColMap );

							int matrixColSize = matrixColMap.size();
							BaseLogger.log("3",null,null, "matrixColSize - "+ matrixColSize );
						loop:for ( Map.Entry<Integer, String> matrixEntry : matrixColMap.entrySet() )
							{
								int currentStartFromColNo = matrixEntry.getKey();
								BaseLogger.log("3",null,null, "loopCnt - ["+ loopCnt +"], currentStartFromColNo - ["+ currentStartFromColNo +"], prevStartMatrixColNo - ["+ prevStartMatrixColNo +"]" );
								if ( loopCnt >= 1  )
								{
									if ( matrixColSize == (loopCnt + 1) )
									{
										if ( ( (endMatrixColNum + 1) - currentStartFromColNo ) != colSpan )
										{
											//retStr = "MATRIX_SUB_HEADER_ERROR";
											retStr = genericUtility.getErrorString( "", "INVMSUBHDR", userId );
											break;
										}
									}
									else if ( ( currentStartFromColNo - prevStartMatrixColNo ) != colSpan )
									{
										//retStr = "MATRIX_SUB_HEADER_ERROR";
										retStr = genericUtility.getErrorString( "", "INVMSUBHDR", userId );
										break;
									}
									else
									{
										for ( int j = prevStartMatrixColNo; j < currentStartFromColNo; j++ )
										{
											String colVal = (String) sheet.getCell( j, headingRowNum ).getContents();
											if ( ! matrixSubColList.contains( colVal ) )
											{
												//retStr = "MATRIX_SUB_HEADER_CONTENT_ERROR";
												retStr = genericUtility.getErrorString( "", "INVHDRCONT", userId );
												break loop;
											}
										}
										prevStartMatrixColNo = currentStartFromColNo;
									}
								}
								else
								{
									prevStartMatrixColNo = currentStartFromColNo;
								}
								loopCnt++;
							}
						}
					}
				}
				catch (Exception e)
				{
					BaseLogger.log("0",null,null,"exception = ["+ e.getMessage() +"]");
					//retStr = "EXCEL_CONTENT_ERROR";
					retStr = genericUtility.getErrorString( "", "INVEXCONT", userId );
					e.printStackTrace();
				}
			}
			else
			{
				//retStr = "DATA_START_FROM_ERROR";
				retStr = genericUtility.getErrorString( "", "INVDSF", userId );
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception in validateInputData - ["+ e.getMessage() +"]" );
			throw new ITMException( e );
		}
		BaseLogger.log("2",null,null, "retStr - ["+ retStr +"]" );

		return retStr;
	}

	private String setTemplateData() throws ITMException
	{
		String retStr = "<Root><Detail>Success</Detail></Root>";
		try
		{
			//HashMap<Integer, HashMap<String, Integer>> matrixRowMap = (HashMap<Integer, HashMap<String, Integer>>) getSessionAttribute( "matrixRowMap" );
			HashMap<Integer, HashMap<String, Integer>> matrixRowMap = uploadBean.getMatrixRowMap();
			
			//added by Ravindra C on 01-02-19 to write matrix error file - Start
			HashMap<String, Integer> matrixSheetColSpanMap = new  HashMap<String, Integer>();
			
			if ( matrixRowMap == null )
			{
				matrixRowMap = new HashMap<Integer, HashMap<String,Integer>>();
			}

			//HashMap<Integer, String> sheetInfoMap = (HashMap<Integer, String>) getSessionAttribute( "sheetInfoMap" );
			HashMap<Integer, String> sheetInfoMap = uploadBean.getSheetInfo();
			if ( sheetInfoMap == null )
			{
				sheetInfoMap = new HashMap<Integer, String>();
			}

			int formNo = Integer.parseInt( getRequestParamValue( "formNo" ) );

			HashMap<String, Integer> matrixValueMap = matrixRowMap.get( formNo );
			if ( matrixValueMap == null )
			{
				matrixValueMap = new HashMap<String, Integer>();
			}
			int headingRowNum = 1, matrixRowNum = -1, startMatrixColNum = -1, endMatrixColNum = -1, dataStartsFrom = 2;
			if ( ( getRequestParamValue("dataStartFrom"+formNo) ).length() > 0 )
			{
				dataStartsFrom = Integer.parseInt( getRequestParamValue("dataStartFrom"+formNo) );
			}
			dataStartsFrom -= 1;
			if ( ( getRequestParamValue("headingRowNo"+formNo) ).length() > 0 )
			{
				headingRowNum = Integer.parseInt( getRequestParamValue("headingRowNo"+formNo) );
				headingRowNum -= 1;
			}
			if ( ( getRequestParamValue("matrixRowNo"+formNo) ).length() > 0 )
			{
				matrixRowNum = Integer.parseInt( getRequestParamValue("matrixRowNo"+formNo) );
				matrixRowNum -= 1;
			}
			if ( ( getRequestParamValue("startMatrixColNo"+formNo) ).length() > 0 )
			{
				startMatrixColNum = Integer.parseInt( getRequestParamValue("startMatrixColNo"+formNo) );
				startMatrixColNum -= 1;
			}
			if ( ( getRequestParamValue("endMatrixColNo"+formNo) ).length() > 0 )
			{
				endMatrixColNum = Integer.parseInt( getRequestParamValue("endMatrixColNo"+formNo) );
				endMatrixColNum -= 1;
			}

			matrixValueMap.put( "HEADING_ROW", headingRowNum ); //Heading Row No - [0]
			matrixValueMap.put( "MATRIX_HEADER_ROW", matrixRowNum ); //Matrix Row No - [1]
			matrixValueMap.put( "MATRIX_START_COL", startMatrixColNum ); //Start Matrix Column No - [2]
			matrixValueMap.put( "MATRIX_END_COL", endMatrixColNum ); //End Matrix Column No - [3]
			matrixValueMap.put( "DATA_STARTS_FROM_ROW", dataStartsFrom ); //Data Start From - [4]

			matrixRowMap.put( formNo, matrixValueMap );

			//setSessionAttribute( "matrixRowMap", matrixRowMap );
			uploadBean.setMatrixRowMap( matrixRowMap );
			BaseLogger.log("3",null,null, "matrixRowMap - ["+ matrixRowMap +"]" );

			//HashMap excelSheetInfo = (HashMap) getSessionAttribute( "excelSheetInfo" );
			HashMap<Integer, String> excelSheetInfo = uploadBean.getExcelSheetInfo();
			int sheetNo = Integer.parseInt( getRequestParamValue( "sheetName"+ formNo ) );
			BaseLogger.log("3",null,null, "sheetNo - ["+ sheetNo +"]" );
			String sheetName = "";
			Sheet sheet = null;
			if ( excelSheetInfo != null && excelSheetInfo.containsKey( sheetNo ) )
			{
				sheetName = (String)excelSheetInfo.get( sheetNo );
			}
			sheetInfoMap.put( formNo, sheetName );

			//setSessionAttribute( "sheetInfoMap", sheetInfoMap );
			uploadBean.setSheetInfo( sheetInfoMap );
			BaseLogger.log("3",null,null, "sheetInfoMap - ["+ sheetInfoMap +"]" );

			String shareScope = getRequestParamValue( "shareScope" );
			//setSessionAttribute( "shareScopeVal", shareScope );
			uploadBean.setShareScope( shareScope );

			String scopeValue = getRequestParamValue( "SCOPE_VAL" );
			//setSessionAttribute( "scopeValueVal", scopeValue );
			uploadBean.setScopeValue( scopeValue );

			String tempRightsChar = getRequestParamValue( "RIGHT_CHAR" );
			//setSessionAttribute( "tempRightsChar", tempRightsChar );
			uploadBean.setTempRightsChar( tempRightsChar );

			String excelFilePath = uploadBean.getFilePath();
			if ( excelFilePath != null )
			{
				//excelFilePath = (String) getSessionAttribute( "excelFile" );
				BaseLogger.log("3",null,null, "excelFilePath - ["+ excelFilePath +"]" );

				if ( sheetName.length() > 0 )
				{
					if ( workbook == null )
					{
						workbook = getWorkbook( excelFilePath );
					}
					sheet = workbook.getSheet( sheetName );
					BaseLogger.log("3",null,null,"sheet ["+sheet+"]");

					ArrayList<String> excelColList = getExcelColumnList( formNo, sheet, headingRowNum, matrixRowNum );
					BaseLogger.log("3",null,null, "excelColList - ["+ excelColList +"]" );

					HashMap<Integer, ArrayList<String>> excelColListMap = uploadBean.getExcelColListMap();
					/*if ( getSessionAttribute( "excelColListMap" ) != null )
					{
						excelColListMap = (HashMap<Integer, ArrayList<String>>) getSessionAttribute( "excelColListMap" );
					}*/
					if ( excelColListMap == null )
					{
						excelColListMap = new HashMap<Integer, ArrayList<String>>();
					}
					excelColListMap.put( formNo, excelColList );
					//setSessionAttribute( "excelColListMap", excelColListMap );
					uploadBean.setExcelColListMap( excelColListMap );
				}
				
				//Added By Ravindra C on 25-04-19 to validate matrix template against selected excel file -start ==kkkk
				if( matrixRowNum >= 0) 
				{
					HashMap<String, Object> matrixDetailMap = getMatrixDetailMap( sheet, matrixRowNum, startMatrixColNum, endMatrixColNum );
					BaseLogger.log("3",null,null,"matrixDetailMap[" + matrixDetailMap + "]");
					
					int colSpan = (Integer) matrixDetailMap.get("COLSPAN");
					BaseLogger.log("3",null,null,"colSpan --["+ colSpan +"]");
					matrixSheetColSpanMap.put( sheetName, colSpan ); 
					
					BaseLogger.log("3",null,null,"matrixSheetColSpanMap :--: [" + matrixSheetColSpanMap + "]");
					uploadBean.setMatrixColSpanMap( matrixSheetColSpanMap );
				}
				//Added By Ravindra C on 25-04-19 to validate matrix template against selected excel file - End
				
				LinkedHashMap<String, String> targetColMap = null;
				//HashMap<Integer, LinkedHashMap<String, String>> targetColAllMap = ( HashMap<Integer, LinkedHashMap<String, String>> ) getSessionAttribute( "targetColAllMap" );
				HashMap<Integer, LinkedHashMap<String, String>> targetColAllMap = uploadBean.getTargetColAllMap();
				BaseLogger.log("3",null,null,"targetColAllMap [" + targetColAllMap + "]");
			  	if ( targetColAllMap != null )
			  	{
					targetColMap = targetColAllMap.get( formNo );
			  	}
			  	else
			  	{
			  		targetColAllMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			  	}
			  	if ( targetColMap == null )
			  	{
			  		targetColMap = new LinkedHashMap<String, String>();
			  	}
				BaseLogger.log("3",null,null,"targetColMap [" + targetColMap + "]");

				LinkedHashMap<String, String> mapLogicData = null;
				//HashMap<Integer, LinkedHashMap<String, String>> mapLogicDataMap = (HashMap<Integer, LinkedHashMap<String, String>>) getSessionAttribute( "mapLogicDataMap" );
				HashMap<Integer, LinkedHashMap<String, String>> mapLogicDataMap = uploadBean.getMapLogicDataMap();
				BaseLogger.log("3",null,null, "mapLogicDataMap - "+ mapLogicDataMap );
				if ( mapLogicDataMap != null )
			  	{
					mapLogicData = mapLogicDataMap.get( formNo );
			  	}
			  	else
			  	{
			  		mapLogicDataMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			  	}
				if ( mapLogicData == null )
				{
					mapLogicData = new LinkedHashMap<String, String>();
				}
			  	BaseLogger.log("3",null,null,"mapLogicData [" + mapLogicData + "]");

			  	LinkedHashMap<String, HashMap<String, String>> defineMapData = null;
				//HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>> defineMapDataMap = (HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>>) getSessionAttribute( "defineMapDataMap" );
			  	HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>> defineMapDataMap = uploadBean.getDefineMapDataMap();
				BaseLogger.log("3",null,null, "defineMapDataMap - "+ defineMapDataMap );
				if ( defineMapDataMap != null )
			  	{
					defineMapData = defineMapDataMap.get( formNo );
			  	}
			  	else
			  	{
			  		defineMapDataMap = new HashMap<Integer, LinkedHashMap<String,HashMap<String,String>>>();
			  	}
				if ( defineMapData == null )
				{
					defineMapData = new LinkedHashMap<String, HashMap<String,String>>();
				}
			  	BaseLogger.log("3",null,null,"defineMapData [" + defineMapData + "]");

			  	//HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = (HashMap<Integer, HashMap<String, HashMap<String, String>>>) getSessionAttribute( "defineValueAllMap" );
			  	HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = uploadBean.getAllFormDefineValueMap();
			    BaseLogger.log("3",null,null,"defineValueAllMap [" + defineValueAllMap + "]");
			 	HashMap<String, HashMap<String, String>> defineValueMap = null;
			    if ( defineValueAllMap != null )
			    {
				    defineValueMap = defineValueAllMap.get( formNo );
			    }
			    else
			    {
			    	defineValueAllMap = new HashMap<Integer, HashMap<String, HashMap<String, String>>>();
			    }
			    if ( defineValueMap == null )
			    {
			    	defineValueMap = new HashMap<String, HashMap<String, String>>();
			    }
	    	    BaseLogger.log("3",null,null,"defineValueMap [" + defineValueMap + "]");

			  	LinkedHashMap<String, String> mapLogicValue = null;
				//HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = (HashMap<Integer, LinkedHashMap<String, String>>) getSessionAttribute( "mapLogicValueMap" );
			  	HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = uploadBean.getMapLogicValueMap();
				BaseLogger.log("3",null,null, "mapLogicValueMap - "+ mapLogicValueMap );
				if ( mapLogicValueMap != null )
			  	{
					mapLogicValue = mapLogicValueMap.get( formNo );
			  	}
			  	else
			  	{
			  		mapLogicValueMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			  	}
				if ( mapLogicValue == null )
				{
					mapLogicValue = new LinkedHashMap<String, String>();
				}
			  	BaseLogger.log("3",null,null,"mapLogicValue [" + mapLogicValue + "]");

				//HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = (HashMap<Integer, LinkedHashMap<String, String>>) getSessionAttribute( "actualColListMap" );
			  	HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = uploadBean.getActualColListMap();
				BaseLogger.log("3",null,null,"actualColListMap [" + actualColListMap + "]");
				if ( actualColListMap != null )
				{
					LinkedHashMap<String, String> actualColMap = actualColListMap.get( formNo );
					Set keys = actualColMap.keySet();
					int loopCnt = 0;
					for (Iterator k = keys.iterator(); k.hasNext();)
					{
						String colName = (String) k.next();
						String targetColValue = getRequestParamValue( "targetCol"+ loopCnt + "_" + formNo );

						BaseLogger.log("3",null,null, "colName - ["+ colName +"], targetColValue - ["+ targetColValue +"]" );
						targetColMap.put( colName, targetColValue );

						String mapLogicVal = getRequestParamValue( "mapLogic"+ loopCnt + "_" + formNo );
						BaseLogger.log("3",null,null, "mapLogicVal - ["+ colName +"], mapLogicVal - ["+ mapLogicVal +"]" );

						//Define datamap related changes for advance mappping --------------- Prasad
						HashMap<String, String> mapData = new LinkedHashMap<String, String>();
						if ( "D".equals( mapLogicVal ) )
						{
							if ( defineValueMap.get( "valueMap" + loopCnt ) != null )
							{
								HashMap<String, String> valueMap = (HashMap<String, String>) defineValueMap.get("valueMap" + loopCnt);
								BaseLogger.log("3",null,null,"valueMap ::: [" + valueMap + "]");
								Iterator<String> it = valueMap.keySet().iterator();

								while (it.hasNext())
								{
									String srcVal = (String) it.next();
									String replaceVal = (String) valueMap.get(srcVal);
									mapData.put( srcVal, replaceVal );
								}
								defineMapData.put( colName, mapData );
							}
						}
						else if ( "R".equals( mapLogicVal ) )
						{
							String sql = mapLogicValue.get("SQL_" + colName);
							String sqlInput = mapLogicValue.get("SQL_INPUT_" + colName);
							BaseLogger.log("3",null,null,"sql - [" + sql + "], sqlInput - [" + sqlInput + "]");

							mapLogicValue.put( "SQL_"+ colName, sql );
							mapLogicValue.put( "SQL_INPUT_" + colName, sqlInput );
						}
						else if ( "S".equals( mapLogicVal ) )
						{
							String startFrom = mapLogicValue.get("START_FROM_" + colName);
							String upTo = mapLogicValue.get("UP_TO_" + colName);
							BaseLogger.log("3",null,null,"startFrom - [" + startFrom + "], upTo - [" + upTo + "]");

							mapLogicValue.put( "START_FROM_"+ colName, startFrom );
							mapLogicValue.put( "UP_TO_" + colName, upTo );
						}
						BaseLogger.log("3",null,null, "mapLogicValue - ["+ mapLogicValue +"], defineMapData - ["+ defineMapData +"]" );
						//Define datamap related changes for advance mappping --------------- END

						mapLogicData.put( colName, mapLogicVal );

						loopCnt++;
					}

					targetColAllMap.put( formNo, targetColMap );
					//setSessionAttribute( "targetColAllMap", targetColAllMap );
					uploadBean.setTargetColAllMap( targetColAllMap );

					mapLogicDataMap.put( formNo, mapLogicData );
					//setSessionAttribute( "mapLogicDataMap", mapLogicDataMap );
					uploadBean.setMapLogicDataMap( mapLogicDataMap );

					defineMapDataMap.put( formNo, defineMapData );
					//setSessionAttribute( "defineMapDataMap", defineMapDataMap );
					uploadBean.setDefineMapDataMap( defineMapDataMap );

					mapLogicValueMap.put( formNo, mapLogicValue );
					//setSessionAttribute( "mapLogicValueMap", mapLogicValueMap );
					uploadBean.setMapLogicValueMap( mapLogicValueMap );
				}
			}
		}
		catch (ITMException itme)
		{
			throw itme;
		}
		return retStr;
	}

	//Added By Ravindra C on 19-01-21 to set the JSON file template Details - END
	private String setJsonTemplateData() throws Exception, ITMException
	{
		String retStr = "<Root><Detail>Success</Detail></Root>";
		try
		{
			HashMap<Integer, String> sheetInfoMap = uploadBean.getSheetInfo();
			if ( sheetInfoMap == null )
			{
				sheetInfoMap = new HashMap<Integer, String>();
			}
			int formNo = Integer.parseInt( getRequestParamValue( "formNo" ) );

			HashMap<Integer, String> excelSheetInfo = uploadBean.getExcelSheetInfo();
			int sheetNo = Integer.parseInt( getRequestParamValue( "sheetName"+ formNo ) );
			BaseLogger.log("3",null,null, "sheetNo - ["+ sheetNo +"]" );
			String sheetName = "";
			if ( excelSheetInfo != null && excelSheetInfo.containsKey( sheetNo ) )
			{
				sheetName = (String)excelSheetInfo.get( sheetNo );
			}
			sheetInfoMap.put( formNo, sheetName );

			uploadBean.setSheetInfo( sheetInfoMap );
			BaseLogger.log("3",null,null, "sheetInfoMap - ["+ sheetInfoMap +"]" );

			String shareScope = getRequestParamValue( "shareScope" );
			uploadBean.setShareScope( shareScope );

			String scopeValue = getRequestParamValue( "SCOPE_VAL" );
			uploadBean.setScopeValue( scopeValue );

			String tempRightsChar = getRequestParamValue( "RIGHT_CHAR" );
			uploadBean.setTempRightsChar( tempRightsChar );

			String excelFilePath = uploadBean.getFilePath();
			if ( excelFilePath != null )
			{
				BaseLogger.log("3",null,null, "excelFilePath - ["+ excelFilePath +"]" );

				if ( sheetName.length() > 0 )
				{
					HashMap<Integer, ArrayList<String>> excelColumnList = getJsonColumnList( uploadBean.getFilePath() );
					BaseLogger.log( "3", null, null, "excelColumns ==> :: ["+ excelColumnList +"]" );
					
					ArrayList<String> excelColList = excelColumnList.get(formNo);
					BaseLogger.log("3",null,null, "excelColList - ["+ excelColList +"]" );

					HashMap<Integer, ArrayList<String>> excelColListMap = uploadBean.getExcelColListMap();
					if ( excelColListMap == null )
					{
						excelColListMap = new HashMap<Integer, ArrayList<String>>();
					}
					excelColListMap.put( formNo, excelColList );
					uploadBean.setExcelColListMap( excelColListMap );
				}
				LinkedHashMap<String, String> targetColMap = null;
				HashMap<Integer, LinkedHashMap<String, String>> targetColAllMap = uploadBean.getTargetColAllMap();
				BaseLogger.log("3",null,null,"targetColAllMap [" + targetColAllMap + "]");
			  	if ( targetColAllMap != null )
			  	{
					targetColMap = targetColAllMap.get( formNo );
			  	}
			  	else
			  	{
			  		targetColAllMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			  	}
			  	if ( targetColMap == null )
			  	{
			  		targetColMap = new LinkedHashMap<String, String>();
			  	}
				BaseLogger.log("3",null,null,"targetColMap [" + targetColMap + "]");

				LinkedHashMap<String, String> mapLogicData = null;
				HashMap<Integer, LinkedHashMap<String, String>> mapLogicDataMap = uploadBean.getMapLogicDataMap();
				BaseLogger.log("3",null,null, "mapLogicDataMap - "+ mapLogicDataMap );
				if ( mapLogicDataMap != null )
			  	{
					mapLogicData = mapLogicDataMap.get( formNo );
			  	}
			  	else
			  	{
			  		mapLogicDataMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			  	}
				if ( mapLogicData == null )
				{
					mapLogicData = new LinkedHashMap<String, String>();
				}
			  	BaseLogger.log("3",null,null,"mapLogicData [" + mapLogicData + "]");

			  	LinkedHashMap<String, HashMap<String, String>> defineMapData = null;
			  	HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>> defineMapDataMap = uploadBean.getDefineMapDataMap();
				BaseLogger.log("3",null,null, "defineMapDataMap - "+ defineMapDataMap );
				if ( defineMapDataMap != null )
			  	{
					defineMapData = defineMapDataMap.get( formNo );
			  	}
			  	else
			  	{
			  		defineMapDataMap = new HashMap<Integer, LinkedHashMap<String,HashMap<String,String>>>();
			  	}
				if ( defineMapData == null )
				{
					defineMapData = new LinkedHashMap<String, HashMap<String,String>>();
				}
			  	BaseLogger.log("3",null,null,"defineMapData [" + defineMapData + "]");

			  	HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = uploadBean.getAllFormDefineValueMap();
			    BaseLogger.log("3",null,null,"defineValueAllMap [" + defineValueAllMap + "]");
			 	HashMap<String, HashMap<String, String>> defineValueMap = null;
			    if ( defineValueAllMap != null )
			    {
				    defineValueMap = defineValueAllMap.get( formNo );
			    }
			    else
			    {
			    	defineValueAllMap = new HashMap<Integer, HashMap<String, HashMap<String, String>>>();
			    }
			    if ( defineValueMap == null )
			    {
			    	defineValueMap = new HashMap<String, HashMap<String, String>>();
			    }
	    	    BaseLogger.log("3",null,null,"defineValueMap [" + defineValueMap + "]");

			  	LinkedHashMap<String, String> mapLogicValue = null;
			  	HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = uploadBean.getMapLogicValueMap();
				BaseLogger.log("3",null,null, "mapLogicValueMap - "+ mapLogicValueMap );
				if ( mapLogicValueMap != null )
			  	{
					mapLogicValue = mapLogicValueMap.get( formNo );
			  	}
			  	else
			  	{
			  		mapLogicValueMap = new HashMap<Integer, LinkedHashMap<String,String>>();
			  	}
				if ( mapLogicValue == null )
				{
					mapLogicValue = new LinkedHashMap<String, String>();
				}
			  	BaseLogger.log("3",null,null,"mapLogicValue [" + mapLogicValue + "]");

			  	HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = uploadBean.getActualColListMap();
				BaseLogger.log("3",null,null,"actualColListMap [" + actualColListMap + "]");
				if ( actualColListMap != null )
				{
					LinkedHashMap<String, String> actualColMap = actualColListMap.get( formNo );
					Set keys = actualColMap.keySet();
					int loopCnt = 0;
					for (Iterator k = keys.iterator(); k.hasNext();)
					{
						String colName = (String) k.next();
						String targetColValue = getRequestParamValue( "targetCol"+ loopCnt + "_" + formNo );

						BaseLogger.log("3",null,null, "colName - ["+ colName +"], targetColValue - ["+ targetColValue +"]" );
						targetColMap.put( colName, targetColValue );

						String mapLogicVal = getRequestParamValue( "mapLogic"+ loopCnt + "_" + formNo );
						BaseLogger.log("3",null,null, "mapLogicVal - ["+ colName +"], mapLogicVal - ["+ mapLogicVal +"]" );

						HashMap<String, String> mapData = new LinkedHashMap<String, String>();
						if ( "D".equals( mapLogicVal ) )
						{
							if ( defineValueMap.get( "valueMap" + loopCnt ) != null )
							{
								HashMap<String, String> valueMap = (HashMap<String, String>) defineValueMap.get("valueMap" + loopCnt);
								BaseLogger.log("3",null,null,"valueMap ::: [" + valueMap + "]");
								Iterator<String> it = valueMap.keySet().iterator();

								while (it.hasNext())
								{
									String srcVal = (String) it.next();
									String replaceVal = (String) valueMap.get(srcVal);
									mapData.put( srcVal, replaceVal );
								}
								defineMapData.put( colName, mapData );
							}
						}
						else if ( "R".equals( mapLogicVal ) )
						{
							String sql = mapLogicValue.get("SQL_" + colName);
							String sqlInput = mapLogicValue.get("SQL_INPUT_" + colName);
							BaseLogger.log("3",null,null,"sql - [" + sql + "], sqlInput - [" + sqlInput + "]");

							mapLogicValue.put( "SQL_"+ colName, sql );
							mapLogicValue.put( "SQL_INPUT_" + colName, sqlInput );
						}
						else if ( "S".equals( mapLogicVal ) )
						{
							String startFrom = mapLogicValue.get("START_FROM_" + colName);
							String upTo = mapLogicValue.get("UP_TO_" + colName);
							BaseLogger.log("3",null,null,"startFrom - [" + startFrom + "], upTo - [" + upTo + "]");

							mapLogicValue.put( "START_FROM_"+ colName, startFrom );
							mapLogicValue.put( "UP_TO_" + colName, upTo );
						}
						BaseLogger.log("3",null,null, "mapLogicValue - ["+ mapLogicValue +"], defineMapData - ["+ defineMapData +"]" );

						mapLogicData.put( colName, mapLogicVal );
						loopCnt++;
					}

					targetColAllMap.put( formNo, targetColMap );
					uploadBean.setTargetColAllMap( targetColAllMap );

					mapLogicDataMap.put( formNo, mapLogicData );
					uploadBean.setMapLogicDataMap( mapLogicDataMap );

					defineMapDataMap.put( formNo, defineMapData );
					uploadBean.setDefineMapDataMap( defineMapDataMap );

					mapLogicValueMap.put( formNo, mapLogicValue );
					uploadBean.setMapLogicValueMap( mapLogicValueMap );
				}
			}
		}
		catch (ITMException itme)
		{
			throw itme;
		}
		return retStr;
	}
	//Added By Ravindra C on 19-01-21 to set the JSON file template Details - END

	//Added By Ankush S on 01-Nov-2022 to set the XML file template Details - START
		private String setXmlTemplateData() throws Exception, ITMException
		{
			String retStr = "<Root><Detail>Success</Detail></Root>";
			try
			{
				HashMap<Integer, String> sheetInfoMap = uploadBean.getSheetInfo();
				if ( sheetInfoMap == null )
				{
					sheetInfoMap = new HashMap<Integer, String>();
				}
				int formNo = Integer.parseInt( getRequestParamValue( "formNo" ) );
				BaseLogger.log("3",userInfo,null, "xml FormNo - ["+ formNo +"]" );
				HashMap<Integer, String> excelSheetInfo = uploadBean.getExcelSheetInfo();
				int sheetNo = Integer.parseInt( getRequestParamValue( "sheetName"+ formNo ) );
				BaseLogger.log("3",userInfo,null, "xml sheetNo - ["+ sheetNo +"]" );
				String sheetName = "";
				if ( excelSheetInfo != null && excelSheetInfo.containsKey( sheetNo ) )
				{
					sheetName = (String)excelSheetInfo.get( sheetNo );
				}
				sheetInfoMap.put( formNo, sheetName );

				uploadBean.setSheetInfo( sheetInfoMap );
				BaseLogger.log("3",null,null, "sheetInfoMap - ["+ sheetInfoMap +"]" );

				String shareScope = getRequestParamValue( "shareScope" );
				uploadBean.setShareScope( shareScope );

				String scopeValue = getRequestParamValue( "SCOPE_VAL" );
				uploadBean.setScopeValue( scopeValue );

				String tempRightsChar = getRequestParamValue( "RIGHT_CHAR" );
				uploadBean.setTempRightsChar( tempRightsChar );

				String excelFilePath = uploadBean.getFilePath();
				if ( excelFilePath != null )
				{
					BaseLogger.log("3",userInfo,null, "xmlFilePath - ["+ excelFilePath +"]" );

					if ( sheetName.length() > 0 )
					{
						
						HashMap<Integer, ArrayList<String>>excelColumnList = getXmlColumnList(uploadBean.getFilePath());
						BaseLogger.log( "3", userInfo, null, "xmlColumns ==> :: ["+ excelColumnList +"]" );
						
						ArrayList<String> excelColList = excelColumnList.get(formNo);
						BaseLogger.log("3",userInfo,null, "xmlColList - ["+ excelColList +"]" );

						HashMap<Integer, ArrayList<String>> excelColListMap = uploadBean.getExcelColListMap();
						if ( excelColListMap == null )
						{
							excelColListMap = new HashMap<Integer, ArrayList<String>>();
						}
						excelColListMap.put( formNo, excelColList );
						uploadBean.setExcelColListMap( excelColListMap );
					}
					LinkedHashMap<String, String> targetColMap = null;
					HashMap<Integer, LinkedHashMap<String, String>> targetColAllMap = uploadBean.getTargetColAllMap();
					BaseLogger.log("3",userInfo,null,"targetColAllMap [" + targetColAllMap + "]");
				  	if ( targetColAllMap != null )
				  	{
						targetColMap = targetColAllMap.get( formNo );
				  	}
				  	else
				  	{
				  		targetColAllMap = new HashMap<Integer, LinkedHashMap<String,String>>();
				  	}
				  	if ( targetColMap == null )
				  	{
				  		targetColMap = new LinkedHashMap<String, String>();
				  	}
					BaseLogger.log("3",userInfo,null,"targetColMap [" + targetColMap + "]");

					LinkedHashMap<String, String> mapLogicData = null;
					HashMap<Integer, LinkedHashMap<String, String>> mapLogicDataMap = uploadBean.getMapLogicDataMap();
					BaseLogger.log("3",userInfo,null, "mapLogicDataMap - "+ mapLogicDataMap );
					if ( mapLogicDataMap != null )
				  	{
						mapLogicData = mapLogicDataMap.get( formNo );
				  	}
				  	else
				  	{
				  		mapLogicDataMap = new HashMap<Integer, LinkedHashMap<String,String>>();
				  	}
					if ( mapLogicData == null )
					{
						mapLogicData = new LinkedHashMap<String, String>();
					}
				  	BaseLogger.log("3",userInfo,null,"mapLogicData [" + mapLogicData + "]");

				  	LinkedHashMap<String, HashMap<String, String>> defineMapData = null;
				  	HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>> defineMapDataMap = uploadBean.getDefineMapDataMap();
					BaseLogger.log("3",userInfo,null, "defineMapDataMap - "+ defineMapDataMap );
					if ( defineMapDataMap != null )
				  	{
						defineMapData = defineMapDataMap.get( formNo );
				  	}
				  	else
				  	{
				  		defineMapDataMap = new HashMap<Integer, LinkedHashMap<String,HashMap<String,String>>>();
				  	}
					if ( defineMapData == null )
					{
						defineMapData = new LinkedHashMap<String, HashMap<String,String>>();
					}
				  	BaseLogger.log("3",userInfo,null,"defineMapData [" + defineMapData + "]");

				  	HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = uploadBean.getAllFormDefineValueMap();
				    BaseLogger.log("3",userInfo,null,"defineValueAllMap [" + defineValueAllMap + "]");
				 	HashMap<String, HashMap<String, String>> defineValueMap = null;
				    if ( defineValueAllMap != null )
				    {
					    defineValueMap = defineValueAllMap.get( formNo );
				    }
				    else
				    {
				    	defineValueAllMap = new HashMap<Integer, HashMap<String, HashMap<String, String>>>();
				    }
				    if ( defineValueMap == null )
				    {
				    	defineValueMap = new HashMap<String, HashMap<String, String>>();
				    }
		    	    BaseLogger.log("3",userInfo,null,"defineValueMap [" + defineValueMap + "]");

				  	LinkedHashMap<String, String> mapLogicValue = null;
				  	HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = uploadBean.getMapLogicValueMap();
					BaseLogger.log("3",userInfo,null, "mapLogicValueMap - "+ mapLogicValueMap );
					if ( mapLogicValueMap != null )
				  	{
						mapLogicValue = mapLogicValueMap.get( formNo );
				  	}
				  	else
				  	{
				  		mapLogicValueMap = new HashMap<Integer, LinkedHashMap<String,String>>();
				  	}
					if ( mapLogicValue == null )
					{
						mapLogicValue = new LinkedHashMap<String, String>();
					}
				  	BaseLogger.log("3",userInfo,null,"mapLogicValue [" + mapLogicValue + "]");

				  	HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = uploadBean.getActualColListMap();
					BaseLogger.log("3",userInfo,null,"actualColListMap [" + actualColListMap + "]");
					if ( actualColListMap != null )
					{
						LinkedHashMap<String, String> actualColMap = actualColListMap.get( formNo );
						Set keys = actualColMap.keySet();
						int loopCnt = 0;
						for (Iterator k = keys.iterator(); k.hasNext();)
						{
							String colName = (String) k.next();
							String targetColValue = getRequestParamValue( "targetCol"+ loopCnt + "_" + formNo );

							BaseLogger.log("3",userInfo,null, "colName - ["+ colName +"], targetColValue - ["+ targetColValue +"]" );
							targetColMap.put( colName, targetColValue );

							String mapLogicVal = getRequestParamValue( "mapLogic"+ loopCnt + "_" + formNo );
							BaseLogger.log("3",userInfo,null, "mapLogicVal - ["+ colName +"], mapLogicVal - ["+ mapLogicVal +"]" );

							HashMap<String, String> mapData = new LinkedHashMap<String, String>();
							if ( "D".equals( mapLogicVal ) )
							{
								if ( defineValueMap.get( "valueMap" + loopCnt ) != null )
								{
									HashMap<String, String> valueMap = (HashMap<String, String>) defineValueMap.get("valueMap" + loopCnt);
									BaseLogger.log("3",userInfo,null,"valueMap ::: [" + valueMap + "]");
									Iterator<String> it = valueMap.keySet().iterator();

									while (it.hasNext())
									{
										String srcVal = (String) it.next();
										String replaceVal = (String) valueMap.get(srcVal);
										mapData.put( srcVal, replaceVal );
									}
									defineMapData.put( colName, mapData );
								}
							}
							else if ( "R".equals( mapLogicVal ) )
							{
								String sql = mapLogicValue.get("SQL_" + colName);
								String sqlInput = mapLogicValue.get("SQL_INPUT_" + colName);
								BaseLogger.log("3",userInfo,null,"sql - [" + sql + "], sqlInput - [" + sqlInput + "]");

								mapLogicValue.put( "SQL_"+ colName, sql );
								mapLogicValue.put( "SQL_INPUT_" + colName, sqlInput );
							}
							else if ( "S".equals( mapLogicVal ) )
							{
								String startFrom = mapLogicValue.get("START_FROM_" + colName);
								String upTo = mapLogicValue.get("UP_TO_" + colName);
								BaseLogger.log("3",null,null,"startFrom - [" + startFrom + "], upTo - [" + upTo + "]");

								mapLogicValue.put( "START_FROM_"+ colName, startFrom );
								mapLogicValue.put( "UP_TO_" + colName, upTo );
							}
							BaseLogger.log("3",userInfo,null, "mapLogicValue - ["+ mapLogicValue +"], defineMapData - ["+ defineMapData +"]" );

							mapLogicData.put( colName, mapLogicVal );
							loopCnt++;
						}

						targetColAllMap.put( formNo, targetColMap );
						uploadBean.setTargetColAllMap( targetColAllMap );

						mapLogicDataMap.put( formNo, mapLogicData );
						uploadBean.setMapLogicDataMap( mapLogicDataMap );

						defineMapDataMap.put( formNo, defineMapData );
						uploadBean.setDefineMapDataMap( defineMapDataMap );

						mapLogicValueMap.put( formNo, mapLogicValue );
						uploadBean.setMapLogicValueMap( mapLogicValueMap );
					}
				}
			}
			catch (ITMException itme)
			{
				throw itme;
			}
			BaseLogger.log("3",userInfo,null, "retStr=["+retStr+"]");
			return retStr;
		}
		//Added By Ankush S on 01-Nov-2022 to set the XML file template Details - END

	private boolean isNewTemplate()
	{
		return isNewTemplate;
	}

	private void removeSessionAttribute( String caller )
	{
		/*session.removeAttribute( "isValidUser" );
		session.removeAttribute( "tempList" );
		session.removeAttribute( "defaultTemplate" );
		session.removeAttribute( "selectedTemplate" );
		session.removeAttribute( "excelSheetInfo" );
		session.removeAttribute( "formDetailInfo" );
		session.removeAttribute( "sheetInfoMap" );
		session.removeAttribute( "excelFile" );
		session.removeAttribute( "fileType" );
		session.removeAttribute( "objName" );
		session.removeAttribute( "objDesc" );
		session.removeAttribute( "mapLogicData" );
		session.removeAttribute( "mapLogicValue" );
		session.removeAttribute( "defineMapData" );
		session.removeAttribute( "actualColMap" );
		session.removeAttribute( "targetCol" );
		session.removeAttribute( "tagInfoMap" );
		session.removeAttribute( "fileType" );
		session.removeAttribute( "tabName" );
		session.removeAttribute( "sheetsUsed" );
		session.removeAttribute( "errorMap" );

		session.removeAttribute( "objListMap" );
		session.removeAttribute( "isRetainPkValue" );
		session.removeAttribute( "templateMap" );
		session.removeAttribute( "shareScopeVal" );
		session.removeAttribute( "scopeValueVal" );
		session.removeAttribute( "tempRightsChar" );
		session.removeAttribute( "isDefaultTemp" );
		session.removeAttribute( "allActualColListMap" );
		session.removeAttribute( "mapLogicDataMap" );
		session.removeAttribute( "defineMapDataMap" );
		session.removeAttribute( "mapLogicValueMap" );
		session.removeAttribute( "targetColMap" );

		session.removeAttribute( "matrixRowMap" );
		session.removeAttribute( "targetColAllMap" );
		session.removeAttribute( "excelColListMap" );*/
		uploadBean = null;
		session.removeAttribute( caller + "UPLOAD_BEAN" );
	}

	private void setSelectedTemplate( String tempName )
	{
		if ( ! isNewTemplate() )
		{
			String templateXml = TemplateDetails.get(objName).getTemplateXml(tempName);
			String fileMappingXml = TemplateDetails.get(objName).getFileMapping(tempName);

			String shareScope = TemplateDetails.get(objName).getShareScope(tempName);
			//setSessionAttribute( "shareScopeVal", shareScope );
			uploadBean.setShareScope( shareScope );

			String scopeValue = TemplateDetails.get(objName).getScopeValue(tempName);
			//setSessionAttribute( "scopeValueVal", scopeValue );
			uploadBean.setScopeValue( scopeValue );

			String tempRightsChar = TemplateDetails.get(objName).getTempRightsChar(tempName);
			//setSessionAttribute( "tempRightsChar", tempRightsChar );
			uploadBean.setTempRightsChar( tempRightsChar );
			
			//Added By Ravindra C on 06-11-18 for template Rights to Employee/Profile - Start
			String rightChar = TemplateDetails.get(objName).getRightChar(tempName);
			uploadBean.setRightChar(rightChar);
			//Added By Ravindra C on 06-11-18 for template Rights to Employee/Profile - End

			String tempAddUser = TemplateDetails.get(objName).getAddUser(tempName);
			//setSessionAttribute( "tempAddUser", tempAddUser );
			uploadBean.setTempAddUser( tempAddUser );

			int totalForms = getNoOfForms();
			TemplateDetails.get(templateKey).createTemplateDetail(templateXml, totalForms);
			TemplateDetails.get(templateKey).createFileMappingDetail(fileMappingXml);

			HashMap<Integer, HashMap<String, Integer>> matrixRowMap = TemplateDetails.get( templateKey ).getFormWiseMatrixRowMap();
			//setSessionAttribute( "matrixRowMap", matrixRowMap );
			uploadBean.setMatrixRowMap( matrixRowMap );
			BaseLogger.log("3",null,null, "matrixRowMap - ["+ matrixRowMap +"]" );

			HashMap<Integer, String> sheetInfoMap = TemplateDetails.get( templateKey ).getSheetInfoMap();
			//setSessionAttribute( "sheetInfoMap", sheetInfoMap );
			uploadBean.setSheetInfo( sheetInfoMap );
			BaseLogger.log("3",null,null, "sheetInfoMap - ["+ sheetInfoMap +"]" );

			HashMap<Integer, ArrayList<String>> allActualColListMap = TemplateDetails.get( templateKey ).getActualColListMap();
			//setSessionAttribute( "allActualColListMap", allActualColListMap );
			uploadBean.setAllFormActualColListMap( allActualColListMap );
			BaseLogger.log("3",null,null, "allActualColListMap - ["+ allActualColListMap +"]" );

			HashMap<Integer, LinkedHashMap<String, String>> mapLogicDataMap = TemplateDetails.get( templateKey ).getFormWiseMapLogicData();
			//setSessionAttribute( "mapLogicDataMap", mapLogicDataMap );
			uploadBean.setMapLogicDataMap( mapLogicDataMap );
			BaseLogger.log("3",null,null, "mapLogicDataMap - "+ mapLogicDataMap );

			HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>> defineMapDataMap = TemplateDetails.get( templateKey ).getFormWiseDefineMapData();
			//setSessionAttribute( "defineMapDataMap", defineMapDataMap );
			uploadBean.setDefineMapDataMap( defineMapDataMap );
			BaseLogger.log("3",null,null, "defineMapDataMap - "+ defineMapDataMap );

			HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = TemplateDetails.get( templateKey ).getFormWiseMapLogicValue();
			//setSessionAttribute( "mapLogicValueMap", mapLogicValueMap );
			uploadBean.setMapLogicValueMap( mapLogicValueMap );
			BaseLogger.log("3",null,null, "mapLogicValueMap - "+ mapLogicValueMap );

			HashMap<Integer, LinkedHashMap<String, String>> targetColAllMap = TemplateDetails.get( templateKey ).getFormWiseTargetCol();
			//setSessionAttribute( "targetColAllMap", targetColAllMap );
			uploadBean.setTargetColAllMap( targetColAllMap );
			BaseLogger.log("3",null,null, "targetColAllMap - "+ targetColAllMap );

			boolean isDefault = TemplateDetails.get(objName).isDefaultTemplate(tempName);
			if( isDefault )
			{
				//setSessionAttribute("isDefaultTemp", "Y");
				uploadBean.setIsDefaultTemp( "Y" );
			}
			else
			{
				//setSessionAttribute("isDefaultTemp", "N");
				uploadBean.setIsDefaultTemp( "N" );
			}
			
			//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload] START
			boolean isAutoConfirm = TemplateDetails.get(objName).isAutoConfirm(tempName);
			if( isAutoConfirm )
			{ 
				uploadBean.setAutoConfirm( "Y" );
			}
			else
			{
				uploadBean.setAutoConfirm( "N" );
			}
			//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload] END
		}
	}
	//Added By Ravindra C on 14-04-2018 for upload Utility -- [Start]
	private void removeRowsFromExcel( String sheetName, String headingRow )
	{
		try
		{
			String uploadExcelpath = uploadBean.getUploadFilepath();
			if ( uploadExcelpath != null )
			{
				//uploadExcelpath = checkNull( (String) getSessionAttribute("uploadExcelpath") );

				if ( uploadExcelpath.length() > 0 )
				{
					int headingRowNo = Integer.parseInt( headingRow );

					FileInputStream fsIP = new FileInputStream(new File(uploadExcelpath));
					HSSFWorkbook wb = new HSSFWorkbook(fsIP);
					HSSFSheet worksheet = wb.getSheet( sheetName );
					HSSFRow row = worksheet.getRow( headingRowNo );
					int lastRowNum = worksheet.getLastRowNum();
					int lastCellNum = row.getLastCellNum();
					for( int rowCtr = headingRowNo; rowCtr <= lastRowNum; rowCtr++ )
					{
						for( int columnCtr = 0; columnCtr < lastCellNum; columnCtr++ )
						{
							worksheet.getRow( rowCtr ).getCell( columnCtr ).setCellValue( "" );
						}
					}
					fsIP.close();

					FileOutputStream output_file = new FileOutputStream(new File(uploadExcelpath));
					wb.write(output_file);
					output_file.flush();
					output_file.close();
				}
			}
		}
		catch( IOException e )
		{
			BaseLogger.log("0",null,null, "IOException :: removeRowsFromExcel : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch( Exception e )
		{
			BaseLogger.log("0",null,null, "Exception :: removeRowsFromExcel : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}
	//Added By Ravindra C on 14-04-2018 for upload Utility -- [End]

	private void downloadTemplate( String docId )
	{
		byte[] byteArray = null;
		try
		{
			BaseLogger.log("3",null,null, "docId : ["+ docId + "]" );
			//DocumentHandlerRemote docHandler = (DocumentHandlerRemote) getInitialContext().lookup( "ibase/DocumentHandlerEJB/remote" );
			DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
			//byteArray = docHandler.getDocument( docId, getUserInfo().getTransDB() );
			byteArray = docHandler.getDocument( docId, getUserInfo() );

			String fileName = docHandler.getDocumentName( docId, userInfo.getTransDB() );
			BaseLogger.log("3",null,null, "fileName of Downloaded document [" + fileName + "]" );

			String downloadedPath = CommonConstants.TEMP_FOLDER + File.separator + fileName;
			BaseLogger.log("3",null,null, "downloadedPath : ["+ downloadedPath +"]");

			FileOutputStream fos = new FileOutputStream(downloadedPath);
			if( byteArray != null )
			{
				fos.write( byteArray );
			}
			fos.close();
			fos.flush();

			//setSessionAttribute( "excelFile", downloadedPath );
			uploadBean.setFilePath( downloadedPath );

			String docType = fileName.substring( fileName.lastIndexOf(".") + 1 );
			BaseLogger.log("3",null,null, "docType : ["+ docType +"]" );
			if( "xls".equalsIgnoreCase( docType ) )
			{
				//setSessionAttribute( "fileType", "excel" );
				uploadBean.setFileType( "excel" );
			}
			else if( "xml".equalsIgnoreCase( docType ) )
			{
				//setSessionAttribute( "fileType", "xml" );
				uploadBean.setFileType( "xml" );
			}
			else if("json".equals(docType)) {
				BaseLogger.log("3",null,null, "heee i got json here : ["+ docType +"]" );
			}
		}
		catch (RemoteException e)
		{
			BaseLogger.log("0",null,null, "RemoteException : ["+ e.getMessage() + "]" );
			e.printStackTrace();
		}
		catch (ITMException e)
		{
			BaseLogger.log("0",null,null, "ITMException : ["+ e.getMessage() + "]" );
			e.printStackTrace();
		}
		catch (FileNotFoundException e)
		{
			BaseLogger.log("0",null,null, "FileNotFoundException : ["+ e.getMessage() + "]" );
			e.printStackTrace();
		}
		/*catch (NamingException e)
		{
			BaseLogger.log("3",null,null, "NamingException : ["+ e.getMessage() + "]" );
			e.printStackTrace();
		}*/
		catch (IOException e)
		{
			BaseLogger.log("0",null,null, "IOException : ["+ e.getMessage() + "]" );
			e.printStackTrace();
		}
	}
	//addded By Prasad R on 23-04-18 for Upload Utility - End

	//Added By Ravindra C on 05-06-2018 for validate Excel Data - Start
	private DBAccessRemote getDBAccess()
	{
		try
		{
			/*if ( dbAccess == null )
			{
				dbAccess = (DBAccessRemote) getInitialContext().lookup( "ibase/DBAccessEJB/remote" );
			}*/
			dbAccess = new DBAccessEJB();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return dbAccess;
	}

	/**
	 * Set object details
	 *
	 * @return
	 * @throws ITMException
	 */
	private String setObjectDetail(UserInfoBean userInfo) throws ITMException
	{
		String responseStr = "<Root><Detail>Success</Detail></Root>";
		try
		{
			HashMap<String, Object> objDetailMap = new HashMap<String, Object>();

			HashMap<String, String> tranSetupDtlMap = getDBAccess().getObjDetailMap( objName, userInfo );
			if ( tranSetupDtlMap == null || tranSetupDtlMap.size() == 0 )
			{
				return genericUtility.getErrorString( "", "VTTRSET1", userId );
			}
			else
			{
				DWFactory dws = new DWFactory(userInfo);
				ArrayList objFormsDetailList = dbAccess.getObjFormsDetailList( objName, userInfo );

				HashMap<String, String> formWisePkFldNameMap = new HashMap<String, String>();
				HashMap<String, HashMap<String, String>> formWiseColLogNameSizeMap = new HashMap<String, HashMap<String, String>>();
				HashMap<String, HashMap<String, String>> dbWiseColLogNameTypeMap = new HashMap<String, HashMap<String, String>>();

				//added by Ravindr C on 08-09-18 for Validate dropDown Data
				HashMap<String, HashMap<String, HashMap<String, String>>> formWiseDropDownColValueMap = new HashMap<String, HashMap<String,HashMap<String,String>>>();
				//Added By Ravindra C on 20-11-18 for upper/lower case data 
				HashMap<String, HashMap<String, String>> formWiseFieldCaseValueMap = new HashMap<String, HashMap<String,String>>();
				//Added By Ravindra C on 13-12-18 for field presicion data map. 
				HashMap<String, HashMap<String, Integer>> formWiseFieldPrecisionValueMap = new HashMap<String, HashMap<String,Integer>>();
				
				HashMap<String, HashMap<String, Integer>> metadataWiseColLogNameTypeMap = new HashMap<String, HashMap<String,Integer>>();
				
				HashMap<String, String> formNameMap = new HashMap<String, String>();
				int noOfForms = objFormsDetailList.size();
				for( int formNo = 0; formNo < noOfForms; formNo++ )
				{
					ArrayList currFormDetailList = (ArrayList)objFormsDetailList.get(formNo);
					String objContext = (String) currFormDetailList.get(14);

					String pkFldName = "";
					if ( "1".equals( objContext ) )
					{
						pkFldName = checkNull( tranSetupDtlMap.get( "TRAN_ID_COL" ) );
					}
					String formPkFldName = checkNull( ""+ currFormDetailList.get(27) );
					if ( formPkFldName.length() > 0 )
					{
						pkFldName = formPkFldName;
					}
					//Added by Prasad on 05/07/18 [change pkfieldName case in lowercase and replace ',' with ':'] START
					pkFldName = pkFldName.replaceAll( ",", COLUMN_SEPARATOR );
					pkFldName = pkFldName.toLowerCase();
					//Added by Prasad on 05/07/18 [change pkfieldName case in lowercase and replace ',' with ':'] END
					BaseLogger.log("3",null,null, "objContext : ["+ objContext +"], pkFldName : ["+ pkFldName +"]" );
					formWisePkFldNameMap.put( objContext, pkFldName );

					String formName = checkNull( "" + currFormDetailList.get(32) );
					BaseLogger.log("3",null,null, "objContext : ["+ objContext +"], formName : ["+ formName +"]" );
					formNameMap.put( objContext, formName );

					if ( formName.length() == 0 )
					{
						formName = objContext;
					}
					String metaDataFileName = objName + "2" + formName;

					// Commented and Added by Pankaj R on 24-Nov-20 as suggested by Danish sir
					// String filePath = CommonConstants.JBOSSHOME + File.separator + "bin" + File.separator + "metadata" + File.separator + metaDataFileName + ".xml";
					String filePath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator + metaDataFileName + ".xml";
					File fileObj = new File( filePath );
					if ( ! fileObj.exists() )
					{
						fileObj = null;
						return genericUtility.getErrorString( "", "METADATANT", userId );
					}
					fileObj = null;

					DWObject dwObj = (DWObject)dws.getDataWindow( metaDataFileName );
					if ( pkFldName.length() == 0 )
					{
						ArrayList primaryKeyLogNameList = dwObj.getPrimaryKeyLogNameList();
						StringBuffer pkFieldNameBuff = new StringBuffer();
						for ( int i = 0; i < primaryKeyLogNameList.size(); i++ )
						{
							String pkFieldName = (String) primaryKeyLogNameList.get(i);
							pkFieldNameBuff.append( pkFieldName ).append( COLUMN_SEPARATOR );
						}
						pkFldName = pkFieldNameBuff.toString();
						formWisePkFldNameMap.put( objContext, pkFldName );
					}

					HashMap<String, String> colLogNameSizeMap = dwObj.getColLogNameSizeMap();
					formWiseColLogNameSizeMap.put( objContext, colLogNameSizeMap );
					
					//Changed By Ravindra C on 30-05-2020 to get table column name type - Start
					HashMap<String, Integer> metadataColLogNameTypeMap = dwObj.getColLogNameTypeMap();
					metadataWiseColLogNameTypeMap.put( objContext, metadataColLogNameTypeMap );
					
					String tableName = dwObj.getTableToBeUpdated();
					BaseLogger.log( "3", userInfo, null, "tableName : ["+ tableName +"]" );
					HashMap<String, String> dbColLogNameTypeMap = getDBAccess().getColLogNameTypeMap( tableName, userInfo );
					BaseLogger.log( "3", userInfo, null, "DBColLogNameTypeMap : ["+ dbColLogNameTypeMap +"]" );
					//Changed By Ravindra C on 30-05-2020 to get table column name type - End
					dbWiseColLogNameTypeMap.put( objContext, dbColLogNameTypeMap );

					//Added by Ravindra C on 08-09-18 for Validate dropDown Data -start
					HashMap<String, HashMap<String, String>> dropDownColValueMap = dwObj.getDropDownColValueMap();
					formWiseDropDownColValueMap.put( objContext, dropDownColValueMap );
					//Added by Ravindra C on 08-09-18 for Validate dropDown Data - End
					
					//Added By Ravindra C on 20-11-18 for create file Case value map - Start
					HashMap< String, String > fieldCaseValueMap = dwObj.getFieldCaseValueMap();
					formWiseFieldCaseValueMap.put( objContext, fieldCaseValueMap );
					//Added By Ravindra C on 20-11-18 for create file Case value map - End 

					//Added By Ravindra C on 13-12-18 for field presicion data map. - Start
					HashMap< String, Integer > fieldPrecisionValueMap = dwObj.getFieldPrecisionValueMap();
					formWiseFieldPrecisionValueMap.put( objContext, fieldPrecisionValueMap );
					//Added By Ravindra C on 13-12-18 for field presicion data map. - End

					dwObj.remove();
					dwObj = null;
				}
				objDetailMap.put( "TOTAL_FORMS", noOfForms );
				objDetailMap.put( "PK_NAME", formWisePkFldNameMap );
				objDetailMap.put( "FORM_NAME", formNameMap );
				objDetailMap.put( "TRANSETUP", tranSetupDtlMap );
				objDetailMap.put( "COLUMN_SIZE", formWiseColLogNameSizeMap );
				objDetailMap.put( "COLUMN_TYPE_DB", dbWiseColLogNameTypeMap );
				objDetailMap.put( "COLUMN_TYPE_METADATA", metadataWiseColLogNameTypeMap );
				//Added By Ravindra C for DropDown Validation.
				objDetailMap.put( "COLUMN_TYPE_VALUES", formWiseDropDownColValueMap );
				//Added By Ravindra C on 20-11-18 for upper/lower case data
				objDetailMap.put( "FIELD_CASE_VALUES", formWiseFieldCaseValueMap );
				//Added By Ravindra C on 13-12-18 for field presicion data map.
				objDetailMap.put( "FIELD_PRECISION_VALUES", formWiseFieldPrecisionValueMap );
				
				dws = null;
			}
			BaseLogger.log("3",null,null, "objDetailMap ["+ objDetailMap +"]" );
			TemplateDetails.get( objName ).setObjDetailMap( objDetailMap );
		}
		catch (RemoteException e)
		{
			throw new ITMException( e );
		}
		catch (Exception e)
		{
			throw new ITMException( e );
		}

		return responseStr;
	}

	/**
	 *
	 * @param colName
	 * @param excelContent
	 * @param colLogNameTypeMap
	 * @param colLogNameSizeMap
	 * @return
	 */
	//added by Ravindr C on 08-09-18 for Validate dropDown Data
	//private String validateExcelInputData( String colName, String excelContent, HashMap<String, String> colLogNameTypeMap, HashMap<String, Integer> colLogNameSizeMap )
	private String validateExcelInputData( String colName, String excelContent, HashMap<String, String> metadataColLogNameTypeMap,
			HashMap<String, String> dbColLogNameTypeMap,
			HashMap<String, Integer> colLogNameSizeMap, 
			HashMap<String, HashMap<String, String>> dropDownColValueMap, 
			HashMap<String, Integer> colLogNamePrecisionMap )
	{
		StringBuffer errorDescr = new StringBuffer();
		try
		{
			HashMap<String, String> errorMap = new HashMap<String, String>();
			if ( dbColLogNameTypeMap != null && dbColLogNameTypeMap.containsKey( colName ) )
			{
				String colType = checkNull( dbColLogNameTypeMap.get( colName ) );
				BaseLogger.log( "3", null, null, "colType : ["+ colType +"]" );

				if ( "char".equalsIgnoreCase( colType ))
				{
					if ( colLogNameSizeMap != null && colLogNameSizeMap.containsKey( colName ) )
					{
						if ( excelContent.length() > 0 )
						{
							int actualSize = colLogNameSizeMap.get( colName ).intValue();
							int dataSize = excelContent.length();
							BaseLogger.log("3",null,null, "colName : ["+ colName +"] actualSize : ["+ actualSize +"], dataSize : ["+ dataSize +"]" );

							if ( dataSize > actualSize )
							{
								String validStr = "Value too large for ["+ excelContent +"] column, (actual: "+ dataSize +", maximum: "+ actualSize +")";
								errorMap.put( colName, validStr );
							}
						}
					}
				}
				else if ( "decimal".equalsIgnoreCase( colType ) )
				{
					try
					{
						if ( excelContent.length() > 0 )
						{
							Double.parseDouble( excelContent );
						}
					}
					catch(Exception e)
					{
						BaseLogger.log("0",null,null, "["+ colType +"] Exception - ["+ e.getMessage() +"]" );
						e.printStackTrace();
						String validStr = "Invalid number ["+ colName +"] for ["+ excelContent +"] column.";
						errorMap.put( colName, validStr );
					}
				}
			}
			//Added By Ravindra C on 20-07-2020 for data and datetime validation through metadata file - Start
			if ( metadataColLogNameTypeMap != null && metadataColLogNameTypeMap.containsKey( colName ) )
			{
				String colType = checkNull( metadataColLogNameTypeMap.get( colName ));
				BaseLogger.log("3",null,null, "colType : ["+colType+"] colName : ["+ colName +"]");
				if ( "datetime".equalsIgnoreCase( colType ) )
				{
					try
					{
						if ( excelContent.length() > 0 )
						{
							genericUtility.getValidDateTimeString( excelContent, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat() );
						}
					}
					catch(Exception e)
					{
						BaseLogger.log("0",null,null, "["+ colType +"] -------->Exception - ["+ e.getMessage() +"]" );
						e.printStackTrace();
						String validStr = "Invalid date ["+ excelContent +"] for ["+ colName +"] column.";
						errorMap.put( colName, validStr );
					}
				}
				else if ( "date".equalsIgnoreCase( colType ) )
				{
					try
					{
						if ( excelContent.length() > 0 )
						{
							genericUtility.getValidDateString( excelContent, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat() );
						}
					}
					catch(Exception e)
					{
						BaseLogger.log("0",null,null, "["+ colType +"] -------->Exception - ["+ e.getMessage() +"]" );
						e.printStackTrace();
						String validStr = "Invalid date ["+ excelContent +"] for ["+ colName +"] column.";
						errorMap.put( colName, validStr );
					}
				}
			}
			//Added By Ravindra C on 20-07-2020 for data and datetime validation through metadata file - End
			//added by Ravindr C on 08-09-18 for Validate dropDown Data - Start
			if( dropDownColValueMap != null && dropDownColValueMap.get( colName ) != null )
			{
				HashMap<String, String> itemData = dropDownColValueMap.get( colName );
				if( excelContent.length() > 0 && ! itemData.containsKey( excelContent ) )
				{
					String validStr = "Invalid value ["+ excelContent +"] for drop down field ["+ colName +"]";
					errorMap.put( colName, validStr );
				}
			}
			//added by Ravindr C on 08-09-18 for Validate dropDown Data -End
			//added by Ravindr C on 08-09-18 for Validate dropDown Data - Start
			if( colLogNamePrecisionMap != null && colLogNamePrecisionMap.get( colName ) != 0 )
			{
				int dataPrecision = colLogNamePrecisionMap.get(colName);
				BaseLogger.log("3", null, null, "dataPrecision : ["+ dataPrecision +"]");

				String excelContentPrecision[] = excelContent.split("\\.");
				String dataCount = excelContentPrecision[1];
				BaseLogger.log("3", null, null, "dataCount : ["+ dataCount +"]");

				if( dataCount.length() > dataPrecision )
				{
					String validStr = "Invalid value ["+ excelContent +"], precision is greater for ["+ colName +"], enter only ["+ dataPrecision +"] precision";
					errorMap.put( colName, validStr );
				}
			}
			//added by Ravindr C on 08-09-18 for Validate dropDown Data -End
			
			int errCnt = 1;
			if ( errorMap.size() > 0 )
			{
				for ( Map.Entry<String, String> entry : errorMap.entrySet() )
				{
					errorDescr.append( errCnt ).append( ". ").append( entry.getValue() ).append( "\n" );
					errCnt++;
				}
			}
			//added by Ravindra C on 13-12-18 for field data precision  - End.
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"In the validateExcelInputData Exception -- > ["+ e.getMessage() +"]");
			e.printStackTrace();
		}
		return errorDescr.toString();
	}

	/**
	 *
	 * @param dataMap
	 * @param pkNameList
	 * @param parentPkNameList
	 * @return
	 */
	private String[] getPkDetails( HashMap<String, String> dataMap, ArrayList<String> pkNameList, ArrayList<String> parentPkNameList )
	{
		String[] pkDtlArr = new String[3];
		StringBuffer pkNameBuff = new StringBuffer();
		StringBuffer pkValueBuff = new StringBuffer();
		StringBuffer parentPkValueBuff = new StringBuffer();
		if ( pkNameList != null && dataMap != null && parentPkNameList != null )
		{
			for ( int pkCtr = 0; pkCtr < pkNameList.size(); pkCtr++ )
			{
				String pkName = checkNull( pkNameList.get( pkCtr ) );
				pkNameBuff.append( pkName ).append( COLUMN_SEPARATOR );
				if ( dataMap.containsKey( pkName ) )
				{
					pkValueBuff.append( dataMap.get( pkName ) ).append( COLUMN_SEPARATOR );
					if ( parentPkNameList.contains( pkName ) )
					{
						parentPkValueBuff.append( dataMap.get( pkName ) ).append( COLUMN_SEPARATOR );
					}
				}
			}
			if ( pkValueBuff.toString().endsWith( COLUMN_SEPARATOR ) )
			{
				pkValueBuff = pkValueBuff.deleteCharAt( pkValueBuff.length() - 1 );
			}
			if ( parentPkValueBuff.toString().endsWith( COLUMN_SEPARATOR ) )
			{
				parentPkValueBuff = parentPkValueBuff.deleteCharAt( parentPkValueBuff.length() - 1 );
			}
		}
		pkDtlArr[0] = pkNameBuff.toString();
		pkDtlArr[1] = pkValueBuff.toString();
		pkDtlArr[2] = parentPkValueBuff.toString();
		return pkDtlArr;
	}
	//Added By Ravindra C on 05-06-2018 for to getPkDetails  - END

	//Added By Ravindra C on 25-06-18  For Xml file Upload - Start
	private LinkedHashMap<String, String> buildXmlData( String filePath ) throws ITMException
	{
		Document doc = null;
		LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			doc = genericUtility.parseFile( filePath );

			int noOfForms = TemplateDetails.get(objName).getFormCount();
			BaseLogger.log("3",userInfo,null,"noOfForms in buildXmlData : "+ noOfForms +"]");
			XPathFactory xpathFactory = XPathFactory.newInstance();
			XPath xpath = xpathFactory.newXPath();

			NodeList detail1NodeList = doc.getElementsByTagName( "Detail1" );
			int detail1NodeListLen = detail1NodeList.getLength();
			BaseLogger.log("3",userInfo,null,"detail1NodeListLen : "+ detail1NodeListLen +"]");

			HashMap<String, String> dbColLogNameTypeMap = TemplateDetails.get( objName ).getColumnTypeDB( "1" ); 
			HashMap<String, String> metaDataColLogNameTypeMap = TemplateDetails.get( objName ).getColumnTypeMetaDeta( "1" );
			
			HashMap<String, Integer> colLogNameSizeMap = TemplateDetails.get( objName ).getColumnSize( "1" );
			HashMap<String, HashMap<String, String>> colValueItemDropDownMap = TemplateDetails.get( objName ).getDropDownColValueMap( "1" );
			//Added By Ravindra C on 20-11-18 for upper/lower case data 
			HashMap<String, String> fieldCaseValueMap = TemplateDetails.get( objName ).getFieldCase( "1" );
			
			//Added By Ravindra C on 13-12-18 for field value precision realted data.
			HashMap<String, Integer> colLogNamePrecisionMap = TemplateDetails.get( objName ).getColumnPrecision( "1" );
			
			Node detail1Node = null;
			String pkNames = "";
			String dbId = "";
			for( int detail1Itr = 0; detail1Itr < detail1NodeListLen; detail1Itr++ )
			{
				StringBuffer detailDataBuff = new StringBuffer();
				detail1Node = detail1NodeList.item( detail1Itr );
				if ( detail1Node != null )
				{
					dbId = detail1Node.getAttributes().getNamedItem("dbID").getNodeValue();
					BaseLogger.log("3",null,null, "dbId : ["+ dbId +"]" );

					NodeList childList = detail1Node.getChildNodes();
					int childListLen = childList.getLength();
					//Changed By Ravindra C on 10-09-18 for xmldataVAlidation -- Start
					String childNodeName ="";
					String colValue ="";
					HashMap<String, String > colNameNValueMap = new HashMap<String, String>();

					for( int subChildItr = 0; subChildItr < childListLen; subChildItr++ )
					{
						Node subChildNode = childList.item(subChildItr);
						childNodeName = subChildNode.getNodeName();
						if( ! ("#text".equals( childNodeName ) ) && "attribute".equalsIgnoreCase( childNodeName ) )
						{
							if ( subChildNode.getAttributes().getNamedItem( "pkNames" ) != null )
							{
								pkNames = subChildNode.getAttributes().getNamedItem( "pkNames" ).getNodeValue();
							}
							//break;
						}
						else if( !"#text".equals( childNodeName ) && subChildNode.getFirstChild() != null )
						{
							colValue = subChildNode.getFirstChild().getNodeValue();
						}
						colNameNValueMap.put( childNodeName, colValue );
					}
					if( pkNames != null && pkNames.endsWith(":") )
					{
						pkNames = pkNames.substring( 0, pkNames.length() - 1 );
					}
					BaseLogger.log("3",null,null, " pkNames : ["+ pkNames +"]" );
					for( Entry<String, String> entry : colNameNValueMap.entrySet() )
					{
						String colName = entry.getKey();
						String colData = entry.getValue();

						String errorDataStr = validateExcelInputData( colName, colData, metaDataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, colValueItemDropDownMap, colLogNamePrecisionMap );
						errorDataStr = checkNull( errorDataStr );
						if ( errorDataStr.length() > 0 )
						{
							dataMap.put( "INPUT_DATA_ERR", genericUtility.getErrorString( "", errorDataStr, "Invalid data!", "" ) );
							return dataMap;
						}
						//Added By Ravindra C on 20-11-18 for upper/lower case data - start
						if( colData !="" )
						{
							colData = fieldCaseData( fieldCaseValueMap, colName, colData );
						}
						//Added By Ravindra C on 20-11-18 for upper/lower case data - End
					}
					//Changed By Ravindra C on 10-09-18 for xmldataVAlidation -- END
					detailDataBuff.append( genericUtility.serializeDom( detail1Node ) );
					for( int formNo = 2; formNo <= noOfForms; formNo++ )
					{
						LinkedHashMap<String, String> detailNodeMap = getNodebypkValue( doc, xpath, formNo, dbId, pkNames );
						if( detailNodeMap != null )
						{
							if( detailNodeMap.containsKey("INPUT_DATA_ERR") )
							{
								return detailNodeMap;
							}
							else
							{
								String detailDataStr = detailNodeMap.get(dbId);
								detailDataBuff.append( detailDataStr );
							}
						}
					}
					dataMap.put(dbId, detailDataBuff.toString());
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"in the BuildXmlData Exception : ["+ e.getMessage() +"]");
			throw new ITMException( e );
		}
		return dataMap;
	}
	//Added By Ravindra C on 25-06-18  For Xml file Upload - End

	//Added By Ravindra C on 25-06-18  For Xml file Upload (Searching using Xpath) - Start
	private LinkedHashMap<String, String> getNodebypkValue( Document doc, XPath xpath, int formNo, String pkValue, String pkName )
	{
		LinkedHashMap<String, String> detailNodeMap = new LinkedHashMap<String, String>();
		try
		{
			StringBuffer stringBuffer = new StringBuffer();

			String xpathExpr = getXPathExpr( pkName, pkValue );
			String xpathStr = "//Detail"+formNo+"["+ xpathExpr + "]";

			XPathExpression expr = xpath.compile( xpathStr );
			Object result = expr.evaluate(doc, XPathConstants.NODESET);
			NodeList detailNodeList = (NodeList) result;

			HashMap<String, String> dbColLogNameTypeMap = TemplateDetails.get( objName ).getColumnTypeDB( ""+ formNo ); 
			HashMap<String, String> metaDataColLogNameTypeMap = TemplateDetails.get( objName ).getColumnTypeMetaDeta( ""+ formNo );
			
			HashMap<String, Integer> colLogNameSizeMap = TemplateDetails.get( objName ).getColumnSize( ""+ formNo );
			HashMap<String, HashMap<String, String>> colValueItemDropDownMap = TemplateDetails.get( objName ).getDropDownColValueMap( ""+ formNo );
			
			//Added By Ravindra C on 20-11-18 for upper/lower case data
			HashMap<String, String> fieldCaseValueMap = TemplateDetails.get( objName ).getFieldCase( ""+ formNo );
			
			//Added By Ravindra C on 13-12-18 for field value precision realted data.
			HashMap<String, Integer> colLogNamePrecisionMap = TemplateDetails.get( objName ).getColumnPrecision( ""+formNo );
			
			if ( detailNodeList != null )
			{
				for ( int detailCnt = 0; detailCnt < detailNodeList.getLength(); detailCnt++ )
				{
					Node detailNode = detailNodeList.item( detailCnt );
					//Changed By Ravindra C on 10-09-18 for xmldataVAlidation -- Start
					NodeList detNodeList = detailNode.getChildNodes();
					String colValue = "";
					for ( int childNodeCtr = 0; childNodeCtr < detNodeList.getLength(); childNodeCtr++ )
					{
						Node childNode = detNodeList.item( childNodeCtr );
						String cNodeName = childNode.getNodeName();
						if( !"#text".equals( cNodeName ) && childNode.getFirstChild() != null )
						{
							colValue = checkNull( childNode.getFirstChild().getNodeValue() );
						}
						//Added By Ravindra C on 13-12-18 for field presicion data map. 
						//String errorDataStr = validateExcelInputData( cNodeName, colValue, colLogNameTypeMap, colLogNameSizeMap, colValueItemDropDownMap );
						String errorDataStr = validateExcelInputData( cNodeName, colValue, metaDataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, colValueItemDropDownMap , colLogNamePrecisionMap );
						errorDataStr = checkNull( errorDataStr );
						if ( errorDataStr.length() > 0 )
						{
							detailNodeMap.put( "INPUT_DATA_ERR", genericUtility.getErrorString( "", errorDataStr, "Invalid data!", "" ) );
							return detailNodeMap;
						}
						//Added By Ravindra C on 20-11-18 for upper/lower case data - start
						if(colValue !="")
						{
							colValue = fieldCaseData( fieldCaseValueMap, cNodeName, colValue );
						}
						//Added By Ravindra C on 20-11-18 for upper/lower case data - End
					}
					//Changed By Ravindra C on 10-09-18 for xmldataVAlidation -- End
					stringBuffer.append( genericUtility.serializeDom( detailNode ) );
				}
				detailNodeMap.put( pkValue, stringBuffer.toString() );
			}
		}
		catch (Exception  e)
		{
			BaseLogger.log("0",null,null, "getNodebypkValue Exception ["+ e.getMessage() +"]" );
		}
		return detailNodeMap;
	}
	//Added By Ravindra C on 25-06-18  For Xml file Upload (Searching using Xpath) - End

	//Added By Ravindra C on 25-06-18  For Xml file Upload (to create xpathExpresstion for multiple primary keys) - Start
	/**
	 *
	 * @param pkNames
	 * @param pkValues
	 * @return
	 */
	private String getXPathExpr( String pkNames, String pkValues )
	{
		StringBuffer exprStr = new StringBuffer();
		if ( pkNames != null && pkValues != null )
		{
			String[] pkNameArr = pkNames.split( ":" );
			String[] pkValueArr = pkValues.split( ":" );
			for ( int pkNameCtr = 0; pkNameCtr < (pkNameArr.length); pkNameCtr++ )
			{
				exprStr.append( pkNameArr[ pkNameCtr ] ).append( "=" ).append( "'" + pkValueArr[ pkNameCtr ] + "'" ).append( " and " );
			}
			if ( exprStr.toString().endsWith( " and " ) )
			{
				exprStr = new StringBuffer( exprStr.substring( 0, exprStr.lastIndexOf( " and " ) ) );
			}
		}
		BaseLogger.log("3",null,null, "exprStr : ["+ exprStr +"]" );
		return exprStr.toString();
	}

	//Added By Ravindra C on 25-06-18  For Xml file Upload (to create xpathExpresstion for multiple primary keys) - End
	private String buildDetailData( HashMap<String, String> dataMap, int formNo, String pkValue, int domId, String pkName )
	{
		StringBuffer detailDataBuff = new StringBuffer();

		//Added by Ravindra C on 05/03/2021 [if tranId not maaped then also upload should work]
		//if( pkValue != null && pkValue.length() > 0 )
		{
			detailDataBuff.append( "<Detail" + formNo + " dbID=\'"+ pkValue +"\' domID=\'"+ domId +"\' objName=\'"+ objName +"\' objContext=\'"+ formNo +"\'>");
			//Changed by Prasad on 19/08/18 [change updateFlag value from 'N' to 'A']
			//detailDataBuff.append( "<attribute pkNames=\'"+ pkName + "\' status='N' updateFlag='N' selected='N' />");
			detailDataBuff.append( "<attribute pkNames=\'"+ pkName + "\' status='N' updateFlag='A' selected='N' />");
			for ( Map.Entry<String, String> dataEntry : dataMap.entrySet() )
			{
				String colName = dataEntry.getKey();
				String colValue = dataEntry.getValue();
				detailDataBuff.append("<").append( colName ).append(" isDataUpload=\"true\"").append("><![CDATA[").append( colValue ).append("]]></" ).append( colName ).append(">");
			}
			detailDataBuff.append("</Detail" + formNo + ">");
			
		}
		return detailDataBuff.toString();
	}
	//Added By Ravindra C on 20-06-18 for to Create pkwise xml data map  - End
	
	//added by Ravindra c on 20-11-18 for upper/lower case Data. - Start
	private String fieldCaseData( HashMap<String, String> fieldCaseValueMap, String colName, String dataContent )
	{
		String finalData = dataContent;
		if( fieldCaseValueMap != null && fieldCaseValueMap.get( colName ) != null )
		{
			String colCaseVal = fieldCaseValueMap.get( colName );
			if( colCaseVal.equalsIgnoreCase( "upper" ) )
			{
				finalData = dataContent.toUpperCase();
			}
		}
		return finalData;
	}
	//added by Ravindra c on 20-11-18 for upper/lower case Data. - End
	
	private String setCharFieldSpaces( HashMap<String, String> colLogNameTypeMap, HashMap<String, Integer> colLogNameSizeMap, String colName, String colValue )
	{
		//Changed by Ravindra on 22/01/2021 [check contains key while get from map]
		//if( ( (String)colLogNameTypeMap.get( colName ) ).equalsIgnoreCase("char") )
		if( colLogNameTypeMap != null && colLogNameTypeMap.containsKey( colName ) && ( (String)colLogNameTypeMap.get( colName ) ).equalsIgnoreCase("char") )
		{
			int size = ((Integer)colLogNameSizeMap.get( colName )).intValue();
			if ( "line_no".equals( colName ) )
			{
				while( colValue.length() != size )
				{
					colValue = " " + colValue; 
				}
			}
			else
			{
				while( colValue.length() != size )
				{
					colValue = colValue + " "; 
				}
			}
		}
		return colValue;
	}
	
	//Added By Ravindra C on 07-08-19 for header matrix sheet with single primary key - Start
	private String getTempPKVal(HashMap<String,String> parentPkNameMap)
	{
		String key ="";
		for( Map.Entry entry : parentPkNameMap.entrySet())
		{
			if("MatrixColumn".equals(entry.getValue())) 
			{
				key = (String)entry.getKey();
			}
		}
		return key;
	}
	//Added By Ravindra C on 07-08-19 for header matrix sheet with single primary key - End

}